/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public abstract class DeclareSignalQuickFixCommon
extends AbstractVariableQuickFix {
    protected IRfDefElement declaration;
    protected boolean declareInside;
    private RfNamedElement enclosingElement;
    protected int insertOffset;

    protected DeclareSignalQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        if (this.enclosingElement instanceof RfType) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SIGNAL);
    }

    public String getDisplayString() {
        boolean isHierarchical = this.marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        if (isHierarchical) {
            String elementPathString = this.marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
            RfElementPath elementPath = RfElementPath.fromString((String)elementPathString, DeclareSignalQuickFixCommon.class);
            IRfNamedElement tempEnclosing = elementPath == null ? null : elementPath.toNamedElement(this.marker.getResource().getProject());
            this.enclosingElement = tempEnclosing instanceof RfNamedElement ? (RfNamedElement)tempEnclosing : null;
        } else {
            this.enclosingElement = VhdlQuickFixUtil.getInstance().getEnclosingScope((RfDefElement)this.enclosingScope, RfArchitecture.class);
        }
        if (this.enclosingElement instanceof RfType) {
            return "Declare field '" + this.elementName + "'";
        }
        return "Declare signal '" + this.elementName + "'";
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        boolean isHierarchical = this.marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        if (isHierarchical) {
            String elementPathString = this.marker.getAttribute("QUICKFIX_SCOPE_ELEMENT_PATH", null);
            RfElementPath elementPath = RfElementPath.fromString((String)elementPathString, DeclareSignalQuickFixCommon.class);
            IRfNamedElement tempEnclosing = elementPath == null ? null : elementPath.toNamedElement(this.marker.getResource().getProject());
            this.enclosingElement = tempEnclosing instanceof RfNamedElement ? (RfNamedElement)tempEnclosing : null;
        } else {
            this.enclosingElement = VhdlQuickFixUtil.getInstance().getEnclosingScope((RfDefElement)this.enclosingScope, RfArchitecture.class);
        }
        if (this.enclosingElement != null) {
            List<RfVariable> fields = this.enclosingElement.getLocalMembers(RfVariable.class);
            RfDefElement declaration = null;
            if (fields != null && !fields.isEmpty() && !fields.get(fields.size() - 1).isPredefined()) {
                Collections.sort(fields, new NamedElementsComparator());
                for (RfVariable field : fields) {
                    if (field.isPredefined() || (declaration = field.getDeclaration()) == null) continue;
                    if (declaration.getDefFile().getAdapter(IResource.class) != this.marker.getResource() || declaration.getStartOffset() <= this.offset) break;
                    declaration = null;
                }
            }
            if (declaration == null) {
                Collection<RfNamedElement> members = this.enclosingElement.getMembers();
                List<RfNamedElement> membersList = Collections.emptyList();
                if (members != null) {
                    membersList = new ArrayList<RfNamedElement>(members);
                }
                if (membersList != null && !membersList.isEmpty() && !membersList.get(membersList.size() - 1).isPredefined()) {
                    Collections.sort(membersList, new NamedElementsComparator());
                    for (RfNamedElement member : membersList) {
                        if (member.isPredefined() || !(member instanceof RfType) && !(member instanceof RfFunction) && !(member instanceof RfFunctionsHolder)) continue;
                        if (member instanceof RfFunctionsHolder && !member.isDirtyElement()) {
                            member = ((RfFunctionsHolder)member).getLastDefinedFunction();
                        }
                        if (member == null || (declaration = member.getDeclaration()) == null) continue;
                        if (declaration.getDefFile().getAdapter(IResource.class) != this.marker.getResource() || declaration.getStartOffset() <= this.offset) break;
                        declaration = null;
                    }
                }
            }
            if (declaration == null) {
                this.declareInside = true;
                declaration = this.enclosingElement.getDeclaration();
            }
            if (declaration != null && declaration.getDefFile() != null) {
                IResource resourceToApplyFix = (IResource)declaration.getDefFile().getAdapter(IResource.class);
                if (resourceToApplyFix != this.marker.getResource()) {
                    this.targetResource = resourceToApplyFix;
                }
                this.declaration = declaration;
            }
        }
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        int endVariableOffset;
        boolean isHierarchical = this.marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        boolean recordFieldDeclaration = isHierarchical && this.enclosingElement instanceof RfType;
        this.insertOffset = this.declaration.getStartOffset();
        if (this.declaration.getNamedElement() instanceof RfVariable && (endVariableOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, ";", this.declaration.getStartOffset(), this.offset, true)) >= 0) {
            this.insertOffset = endVariableOffset;
        }
        RfNamedElement closestContainer = VhdlQuickFixUtil.getInstance().getEnclosingScope((RfDefElement)this.enclosingScope, RfFunction.class, RfProcess.class, RfBlock.class, RfArchitecture.class, RfPackageBody.class);
        String typeName = VhdlQuickFixUtil.getInstance().getCorrectCase(VhdlQuickFixUtil.getInstance().guessElementType(closestContainer, this.elementName), true);
        boolean isIdentifier = DVTStringUtil.isIdentifier((String)typeName);
        String indent = DVTDocumentUtils.getIndent((int)this.insertOffset, (IDocument)document);
        if (indent.isEmpty()) {
            indent = TextUtils.getIndentTab((boolean)true, (int)this.tabWidth);
        }
        IRegion lineInformationOfOffset = document.getLineInformationOfOffset(this.insertOffset);
        StringBuilder replacementString = new StringBuilder();
        HashMap<String, List<Region>> trackedRegions = new HashMap<String, List<Region>>();
        String signalKeyword = VhdlQuickFixUtil.getInstance().getCorrectCase("SIGNAL ", false);
        if (!this.declareInside && !(this.declaration.getNamedElement() instanceof RfVariable)) {
            this.insertOffset = lineInformationOfOffset.getOffset();
            replacementString.append(String.valueOf(indent) + (recordFieldDeclaration ? "" : signalKeyword) + this.elementName + " : ");
            if (isIdentifier) {
                trackedRegions.put("typeName", Collections.singletonList(new Region(replacementString.length(), typeName.length())));
            }
            replacementString.append(String.valueOf(typeName) + ";" + "\n");
        } else {
            this.insertOffset = lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength();
            replacementString.append("\n" + indent + (recordFieldDeclaration ? "" : signalKeyword) + this.elementName + " : ");
            if (isIdentifier) {
                trackedRegions.put("typeName", Collections.singletonList(new Region(replacementString.length(), typeName.length())));
            }
            replacementString.append(String.valueOf(typeName) + ";");
        }
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, replacementString.toString());
        this.textFileChange.addEdit((TextEdit)insertEdit, trackedRegions);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        if (this.insertOffset < 0) {
            return;
        }
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, this.targetDocument, this.getDisplayString(), (Change)this.textFileChange);
        this.addLinkedPositions();
    }

    protected void addLinkedPositions() throws BadLocationException, BadPositionCategoryException {
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true, this.textFileChange);
        Collection typeNameRegions = this.textFileChange.getAbsoluteRegionsByCategory("typeName");
        if (typeNameRegions == null || typeNameRegions.isEmpty()) {
            return;
        }
        for (IRegion typeNameRegion : typeNameRegions) {
            this.linkedPositionProvider.addSingleLinkedPosition(typeNameRegion.getOffset(), typeNameRegion.getLength(), this.targetDocument);
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    public String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.declaration.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    static class NamedElementsComparator
    implements Comparator<RfNamedElement> {
        NamedElementsComparator() {
        }

        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            RfDefElement declaration1 = o1.getDeclaration();
            RfDefElement declaration2 = o2.getDeclaration();
            if (declaration1 == null || declaration2 == null) {
                return 0;
            }
            return declaration2.getStartOffset() - declaration1.getStartOffset();
        }
    }
}

