/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public abstract class DeclareVariableQuickFixCommon
extends AbstractVariableQuickFix {
    private static final String INITIAL_VALUE = "INITIAL_VALUE";
    protected int insertOffset;
    private IRfDefElement declaration;
    private boolean declareBeforeBegin;

    protected DeclareVariableQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_VARIABLE);
    }

    public String getDisplayString() {
        return "Declare variable '" + this.elementName + "'";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        RfDefElement enclosingScopeDef = (RfDefElement)this.enclosingScope;
        if (this.enclosingScope == null || !(this.enclosingScope.getNamedElement() instanceof RfNamedElement)) {
            return;
        }
        RfNamedElement closestContainer = VhdlQuickFixUtil.getInstance().getEnclosingScope(enclosingScopeDef, RfProcess.class, RfFunction.class);
        this.computeDeclarationAnchor(closestContainer);
        String indent = DVTDocumentUtils.getIndent((int)this.declaration.getStartOffset(), (IDocument)document);
        String typeName = VhdlQuickFixUtil.getInstance().getCorrectCase(VhdlQuickFixUtil.getInstance().guessElementType(closestContainer, this.elementName), true);
        boolean isIdentifier = DVTStringUtil.isIdentifier((String)typeName);
        boolean useSpacesNotTabs = this.triggerEditor.isInsertSpaces(VhdlPlugin.getDefault().getCombinedPreferenceStore());
        String tabOrSpace = TextUtils.getIndentTab((boolean)useSpacesNotTabs, (int)this.tabWidth);
        this.insertOffset = this.declaration.getStartOffset();
        if (this.declaration.getNamedElement() instanceof RfVariable) {
            this.insertOffset = this.declaration.getEndOffset();
        }
        IRegion lineInformationOfOffset = document.getLineInformationOfOffset(this.insertOffset);
        String variableKeyword = VhdlQuickFixUtil.getInstance().getCorrectCase("VARIABLE ", false);
        HashMap<String, List<Region>> trackedRegions = new HashMap<String, List<Region>>();
        StringBuilder replacementString = new StringBuilder();
        if (!this.declareBeforeBegin && this.declaration.getNamedElement() instanceof RfVariable) {
            int semicolonOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, ";", this.declaration.getStartOffset(), this.enclosingScope.getEndOffset(), false);
            if (this.offset >= this.declaration.getStartOffset() && this.offset <= semicolonOffset) {
                this.insertOffset = lineInformationOfOffset.getOffset();
                int beginKeywordLine = document.getLineOfOffset(this.insertOffset);
                int beginKeywordLineOffset = document.getLineOffset(beginKeywordLine);
                String textBeforeBegin = document.get(beginKeywordLineOffset, this.insertOffset - beginKeywordLineOffset);
                boolean noTextBeforeBeginKeyword = textBeforeBegin.trim().isEmpty();
                replacementString.append(String.valueOf(noTextBeforeBeginKeyword ? "" : String.valueOf(VhdlQuickFixUtil.NEW_LINE) + tabOrSpace) + indent + variableKeyword + this.elementName + " : ");
                if (isIdentifier) {
                    trackedRegions.put("typeName", Collections.singletonList(new Region(replacementString.length(), typeName.length())));
                }
                replacementString.append(String.valueOf(typeName) + " := ");
                trackedRegions.put("initialValue", Collections.singletonList(new Region(replacementString.length(), INITIAL_VALUE.length())));
                replacementString.append("INITIAL_VALUE;" + VhdlQuickFixUtil.NEW_LINE);
            } else {
                this.insertOffset = lineInformationOfOffset.getOffset() + lineInformationOfOffset.getLength();
                replacementString.append(String.valueOf(VhdlQuickFixUtil.NEW_LINE) + indent + variableKeyword + this.elementName + " : ");
                if (isIdentifier) {
                    trackedRegions.put("typeName", Collections.singletonList(new Region(replacementString.length(), typeName.length())));
                }
                replacementString.append(String.valueOf(typeName) + " := ");
                trackedRegions.put("initialValue", Collections.singletonList(new Region(replacementString.length(), INITIAL_VALUE.length())));
                replacementString.append("INITIAL_VALUE;");
            }
        } else if (!this.declareBeforeBegin && !(this.declaration.getNamedElement() instanceof RfVariable)) {
            this.insertOffset = lineInformationOfOffset.getOffset();
            int beginKeywordLine = document.getLineOfOffset(this.insertOffset);
            int beginKeywordLineOffset = document.getLineOffset(beginKeywordLine);
            String textBeforeBegin = document.get(beginKeywordLineOffset, this.insertOffset - beginKeywordLineOffset);
            boolean noTextBeforeBeginKeyword = textBeforeBegin.trim().isEmpty();
            replacementString.append(String.valueOf(noTextBeforeBeginKeyword ? "" : String.valueOf(VhdlQuickFixUtil.NEW_LINE) + tabOrSpace) + indent + variableKeyword + this.elementName + " : ");
            if (isIdentifier) {
                trackedRegions.put("typeName", Collections.singletonList(new Region(replacementString.length(), typeName.length())));
            }
            replacementString.append(String.valueOf(typeName) + " := ");
            trackedRegions.put("initialValue", Collections.singletonList(new Region(replacementString.length(), INITIAL_VALUE.length())));
            replacementString.append("INITIAL_VALUE;" + VhdlQuickFixUtil.NEW_LINE);
        } else {
            this.insertOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "begin", this.declaration.getStartOffset(), this.enclosingScope.getEndOffset(), false);
            IRfScope beginScope = RfUtils.getRfScope((ITextEditor)this.targetEditor, this.targetDocument, this.insertOffset);
            while (closestContainer.getDeclaration() != null && !closestContainer.getDeclaration().equals(beginScope)) {
                this.insertOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "begin", this.insertOffset, this.enclosingScope.getEndOffset(), false);
                if (this.insertOffset < 0 || this.insertOffset >= this.enclosingScope.getEndOffset()) {
                    this.insertOffset = -1;
                    return;
                }
                beginScope = RfUtils.getRfScope((ITextEditor)this.targetEditor, this.targetDocument, this.insertOffset);
                if (beginScope == null) break;
            }
            if (this.insertOffset < 0) {
                return;
            }
            this.insertOffset -= "begin".length();
            int beginKeywordLine = document.getLineOfOffset(this.insertOffset);
            int beginKeywordLineOffset = document.getLineOffset(beginKeywordLine);
            String textBeforeBegin = document.get(beginKeywordLineOffset, this.insertOffset - beginKeywordLineOffset);
            boolean noTextBeforeBeginKeyword = textBeforeBegin.trim().isEmpty();
            replacementString.append(String.valueOf(noTextBeforeBeginKeyword ? "" : String.valueOf(VhdlQuickFixUtil.NEW_LINE) + tabOrSpace) + indent + variableKeyword + this.elementName + " : ");
            if (isIdentifier) {
                trackedRegions.put("typeName", Collections.singletonList(new Region(replacementString.length(), typeName.length())));
            }
            replacementString.append(String.valueOf(typeName) + " := ");
            trackedRegions.put("initialValue", Collections.singletonList(new Region(replacementString.length(), INITIAL_VALUE.length())));
            replacementString.append("INITIAL_VALUE;" + VhdlQuickFixUtil.NEW_LINE + indent);
        }
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, replacementString.toString());
        this.textFileChange.addEdit((TextEdit)insertEdit, trackedRegions);
    }

    private void computeDeclarationAnchor(RfNamedElement closestContainer) {
        IRfDefElement declarationCandidate = VhdlQuickFixUtil.getInstance().computeDeclarationAnchor(closestContainer, -1, this.offset);
        if (declarationCandidate == null) {
            this.declareBeforeBegin = true;
            this.declaration = closestContainer.getDeclaration();
        } else if (declarationCandidate.getDefFile() != null) {
            IResource resourceToApplyFix = (IResource)declarationCandidate.getDefFile().getAdapter(IResource.class);
            if (resourceToApplyFix != this.marker.getResource()) {
                this.targetResource = resourceToApplyFix;
            }
            this.declaration = declarationCandidate;
        }
    }

    protected void addLinkedPositions() throws BadLocationException, BadPositionCategoryException {
        Collection initialValueRegions;
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true, this.textFileChange);
        Collection typeNameRegions = this.textFileChange.getAbsoluteRegionsByCategory("typeName");
        if (typeNameRegions != null && !typeNameRegions.isEmpty()) {
            for (IRegion typeNameRegion : typeNameRegions) {
                this.linkedPositionProvider.addSingleLinkedPosition(typeNameRegion.getOffset(), typeNameRegion.getLength(), this.targetDocument);
            }
        }
        if ((initialValueRegions = this.textFileChange.getAbsoluteRegionsByCategory("initialValue")) != null && !initialValueRegions.isEmpty()) {
            for (IRegion initialValueRegion : initialValueRegions) {
                this.linkedPositionProvider.addSingleLinkedPosition(initialValueRegion.getOffset(), initialValueRegion.getLength(), this.targetDocument);
            }
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    public String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

