/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public class DeprecatedPkgRemoveQuickFix
extends BaseAbstractQuickFix {
    private int startOffset;
    private int endOffset;

    public DeprecatedPkgRemoveQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Remove deprecated package '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.getDisplayString(), (Change)this.textFileChange);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.startOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(document, "use", Math.max(0, this.offset - 200), this.offset, true, true);
        if (this.startOffset < 0) {
            return;
        }
        int maxOffsetLimit = this.startOffset + 1000;
        this.endOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, ";", this.offset, maxOffsetLimit, true);
        if (this.endOffset < 0) {
            return;
        }
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        DeleteEdit deleteEdit = new DeleteEdit(this.startOffset, this.endOffset - this.startOffset);
        this.textFileChange.addEdit((TextEdit)deleteEdit);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

