/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public class DeprecatedPkgReplaceQuickFix
extends BaseAbstractQuickFix {
    private String replacementPackageName;

    public DeprecatedPkgReplaceQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Replace deprecated package '" + this.elementName + "' with '" + this.getReplacementPackageName() + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PACKAGE);
    }

    public String getReplacementPackageName() {
        if (this.elementName == null || this.elementName.length() == 0) {
            return null;
        }
        if (Character.isUpperCase(this.elementName.charAt(0))) {
            return "NUMERIC_STD";
        }
        return "numeric_std";
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.getDisplayString(), (Change)this.textFileChange);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.replacementPackageName = this.getReplacementPackageName();
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        ReplaceEdit replaceEdit = new ReplaceEdit(this.position.getOffset(), this.position.getLength(), this.replacementPackageName);
        this.textFileChange.addEdit((TextEdit)replaceEdit);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

