/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseImportOrFullyQualifyQuickFix;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public class FullyQualifyQuickFix
extends BaseImportOrFullyQualifyQuickFix {
    private String replacementString;

    public FullyQualifyQuickFix(IMarker marker, ITextViewer viewer, String qualifyName) {
        super(marker, viewer, qualifyName);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        StringBuilder qualifySeg = new StringBuilder();
        qualifySeg.append(this.fImportName);
        this.replacementString = qualifySeg.toString();
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.position.offset, this.replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit, (IRegion)new Region(this.replacementString.length(), this.replacementString.length()));
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.replacementString, (Change)this.textFileChange);
    }

    public String getDisplayString() {
        return "Fully qualify '" + this.fImportName + this.elementName + "'";
    }
}

