/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.ui.editor.quickassist.util.VhdlQuickAssistUtil;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseImportOrFullyQualifyQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public abstract class ImportQuickFixCommon
extends BaseImportOrFullyQualifyQuickFix {
    private static final String NEW_LINE = System.lineSeparator();
    private String USE = "use ";
    private String LIBRARY = "library ";
    private String ALL = "all";
    private ImportInfo libraryClause;
    private RfDefElement elementToImportAbove;
    private String libraryName;
    private String typeName;
    private DVTLinkedPositionProvider linkedPositionMaker;
    protected Position originalCursorPosition;
    private RfFileDef elementDeclarationFileDef;
    private IResource fileDefAdapter;

    protected ImportQuickFixCommon(IMarker marker, ITextViewer viewer, RfNamedElement typeToImport, RfDefElement elementToImportAbove, String importString, String libraryName) {
        super(marker, viewer, importString);
        this.typeName = typeToImport.getName();
        this.elementToImportAbove = elementToImportAbove;
        this.libraryClause = null;
        this.libraryName = libraryName;
        this.LIBRARY = VhdlQuickFixUtil.getInstance().getCorrectCase(this.LIBRARY, false);
        this.USE = VhdlQuickFixUtil.getInstance().getCorrectCase(this.USE, false);
        this.ALL = VhdlQuickFixUtil.getInstance().getCorrectCase(this.ALL, false);
        this.typeName = VhdlQuickFixUtil.getInstance().getCorrectCase(this.typeName, true);
        this.linkedProposalModel = new LinkedModeModel();
    }

    public String getDisplayString() {
        return "Add '" + this.USE + this.fImportName + this.ALL + "' to import '" + this.typeName + "' type";
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.triggerEditor = (DVTEditor)DVTUiUtils.getEditor((IDocument)document);
    }

    private boolean createChanges() throws BadLocationException {
        Region track;
        List<ImportInfo> libraryClauses = this.elementToImportAbove.getNamedElement().getLibraryClause();
        if (libraryClauses != null) {
            for (ImportInfo libraryClause : libraryClauses) {
                String libraryName;
                List<DataTypeChunk> useClauseList = libraryClause.getUseClauseList();
                if (useClauseList.isEmpty() || !(libraryName = useClauseList.get((int)0).name).equalsIgnoreCase(this.libraryName)) continue;
                this.libraryClause = libraryClause;
                break;
            }
        }
        int insertOffset = -1;
        StringBuilder importText = new StringBuilder();
        if (this.libraryClause == null) {
            boolean implicitLibraryAcess;
            insertOffset = this.elementToImportAbove.getStartOffset();
            indent = DVTDocumentUtils.getIndent((int)insertOffset, (IDocument)this.targetDocument);
            IRegion insertLineInfo = this.targetDocument.getLineInformationOfOffset(insertOffset);
            insertOffset = insertLineInfo.getOffset();
            boolean bl = implicitLibraryAcess = this.libraryName.equalsIgnoreCase("work") || this.libraryName.equalsIgnoreCase("std");
            if (!implicitLibraryAcess) {
                importText.append(indent).append(this.LIBRARY).append(this.libraryName).append(";").append(NEW_LINE);
            }
            importText.append(indent).append(this.USE).append(this.fImportName);
            track = new Region(importText.length(), this.ALL.length());
            importText.append(this.ALL).append(";").append(NEW_LINE).append(NEW_LINE);
        } else {
            insertOffset = this.libraryClause.getOffset();
            indent = DVTDocumentUtils.getIndent((int)insertOffset, (IDocument)this.targetDocument);
            int maxOffsetLimit = insertOffset + 1000;
            insertOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(this.targetDocument, ";", insertOffset, maxOffsetLimit, true);
            if (insertOffset < 0) {
                return false;
            }
            importText.append(indent).append(this.USE).append(this.fImportName);
            track = new Region(importText.length(), this.ALL.length());
            importText.append(this.ALL).append(";").append(NEW_LINE);
        }
        if (insertOffset < 0) {
            return false;
        }
        this.textFileChange = new VhdlTextFileChange(this.elementDeclarationFileDef.getName(), (IFile)this.fileDefAdapter);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        this.textFileChange.addEdit((TextEdit)new InsertEdit(insertOffset, importText.toString()), (IRegion)track);
        return true;
    }

    protected void addLinkedPositions(boolean editorChanged) throws Exception {
        Collection absoluteRegions = this.textFileChange.getAbsoluteRegions();
        if (absoluteRegions.isEmpty()) {
            return;
        }
        IRegion region = (IRegion)absoluteRegions.iterator().next();
        this.linkedPositionMaker.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.targetDocument);
        DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.triggerEditor.getCursor(), "__vhdl_partitioning");
        this.linkedPositionMaker.enterLinkedMode(this.targetDocument, config);
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.elementDeclarationFileDef = this.elementToImportAbove.getDefFile();
        this.fileDefAdapter = this.elementDeclarationFileDef.getFileAdapter();
        if (this.fileDefAdapter == null || !(this.fileDefAdapter instanceof IFile)) {
            return;
        }
        this.targetEditor = (DVTEditor)DVTUiUtils.getEditor((IResource)this.fileDefAdapter);
        if (this.targetEditor == null) {
            return;
        }
        this.targetDocument = this.targetEditor.getDocument();
        if (this.targetDocument == null) {
            return;
        }
        this.linkedPositionMaker = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true, this.textFileChange);
        if (!this.createChanges()) {
            VhdlQuickAssistUtil.popSomethingWentWrong((String)this.getDisplayString());
            return;
        }
    }

    public IFile[] getAffectedFiles() throws Exception {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = this.textFileChange.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile) {
                affectedFiles.add((IFile)o);
            }
            ++n2;
        }
        return affectedFiles.toArray(new IFile[affectedFiles.size()]);
    }
}

