/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.QuickFixException;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.ui.editor.edit.strategy.DocumentLineAccessor;
import ro.amiq.vhdldt.ui.editor.edit.strategy.VhdlCodeTokenProcessor;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public class RemoveUnusedSignalQuickFix
extends BaseAbstractQuickFix {
    private IRfDefElement declaration;
    private int startOffset;
    private int endOffset;
    private RfFileDef targetFile;

    public RemoveUnusedSignalQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SIGNAL);
    }

    public String getDisplayString() {
        return "Remove signal '" + this.elementName + "' (never used)";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.init(document);
        DocumentLineAccessor documentLineAccessor = new DocumentLineAccessor(document, this.declaration.getStartOffset(), 2500);
        VhdlCodeTokenProcessor.Token prevToken = this.getInitialStartOffset(documentLineAccessor);
        Object[] endPair = this.getInitialEndOffset(document);
        if (prevToken.getValue().equals(",")) {
            --this.startOffset;
            this.createTextFileChange();
            return;
        }
        if (((Character)endPair[0]).charValue() == ',') {
            this.startOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)this.startOffset, (boolean)true, (String)"__vhdl_partitioning") - 1;
            ++this.endOffset;
            this.createTextFileChange();
            return;
        }
        this.setStartOffset(document, prevToken, documentLineAccessor);
        this.setEndOffset(document, endPair);
        this.createTextFileChange();
    }

    protected void createTextFileChange() {
        this.textFileChange = new VhdlTextFileChange(this.targetFile.getName(), (IFile)this.targetFile.getFileAdapter());
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        DeleteEdit deleteEdit = new DeleteEdit(this.startOffset, this.endOffset - this.startOffset);
        this.textFileChange.addEdit((TextEdit)deleteEdit);
    }

    private void setEndOffset(IDocument document, Object[] endPair) throws Exception {
        IRfDefElement workingEnclosingScope = this.enclosingScope;
        if (workingEnclosingScope.getNamedElement() instanceof RfVariable) {
            IRfScopeElement rfScope = workingEnclosingScope.getNamedElement().getEnclosingScope();
            if (rfScope instanceof IRfDefElement) {
                workingEnclosingScope = (IRfDefElement)rfScope;
            } else if (rfScope instanceof IRfNamedElement) {
                workingEnclosingScope = ((IRfNamedElement)rfScope).getDeclaration();
            }
        }
        int searchLimit = workingEnclosingScope != null ? workingEnclosingScope.getEndOffset() : Math.min(document.getLength(), (Integer)endPair[1] + 1);
        while (((Character)endPair[0]).charValue() != ';') {
            if ((Integer)(endPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)((Integer)endPair[1] + 1), (boolean)true, (String)"__vhdl_partitioning"))[1] < searchLimit) continue;
            throw new QuickFixException();
        }
        this.endOffset = (Integer)endPair[1] + 1;
    }

    private void setStartOffset(IDocument document, VhdlCodeTokenProcessor.Token prevToken, DocumentLineAccessor documentLineAccessor) {
        while (!prevToken.getValue().equals(";") && !prevToken.getValue().equals("is")) {
            prevToken = documentLineAccessor.nextToken();
        }
        int prevTokenEndOffset = prevToken.getStartOffset() + prevToken.getValue().length();
        this.startOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)prevTokenEndOffset, (boolean)true, (String)"__vhdl_partitioning") - 1;
    }

    private void init(IDocument document) throws QuickFixException {
        if (this.enclosingScope == null) {
            throw new QuickFixException();
        }
        RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement((ITextEditor)this.triggerEditor, document, this.position.getOffset());
        if (elementAndScope == null) {
            throw new QuickFixException();
        }
        RfNamedElement field = elementAndScope.getNamedElement();
        if (!(field instanceof RfVariable)) {
            throw new QuickFixException();
        }
        this.declaration = field.getDeclaration();
        if (this.declaration == null) {
            throw new QuickFixException();
        }
        this.targetFile = (RfFileDef)this.declaration.getDefFile();
    }

    private VhdlCodeTokenProcessor.Token getInitialStartOffset(DocumentLineAccessor documentLineAccessor) throws QuickFixException {
        VhdlCodeTokenProcessor.Token prevToken = documentLineAccessor.nextToken();
        while (prevToken != null && prevToken.getType() == 3) {
            prevToken = documentLineAccessor.nextToken();
        }
        if (prevToken == null) {
            throw new QuickFixException();
        }
        this.startOffset = prevToken.getStartOffset() + prevToken.getValue().length();
        return prevToken;
    }

    private Object[] getInitialEndOffset(IDocument document) throws QuickFixException {
        int declarationEndOffset = this.declaration.getStartOffset() + this.elementName.length();
        Object[] endPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)declarationEndOffset, (boolean)true, (String)"__vhdl_partitioning");
        if (endPair == null) {
            throw new QuickFixException();
        }
        this.endOffset = (Integer)endPair[1];
        return endPair;
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.getDisplayString(), (Change)this.textFileChange);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IFile[] affectedFiles = new IFile[1];
        IResource funcResource = this.declaration.getFileAdapter();
        if (funcResource instanceof IFile) {
            affectedFiles[0] = (IFile)funcResource;
        }
        return affectedFiles;
    }
}

