/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.QuickFixException;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public class SensitivityAddQuickFix
extends BaseAbstractQuickFix {
    private IRfDefElement fDeclaration;

    public SensitivityAddQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Add signal '" + this.elementName + "' to sensitivity list";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        RfProcess process = (RfProcess)this.enclosingScope.getNamedElement().getEnclosingScope(RfProcess.class);
        this.fDeclaration = null;
        for (IRfDefElement iRfDefElement : process.getDeclarations()) {
            if (iRfDefElement.getDefFile() != this.enclosingScope.getDefFile() || this.offset <= iRfDefElement.getStartOffset() || this.offset >= iRfDefElement.getEndOffset()) continue;
            this.fDeclaration = iRfDefElement;
            break;
        }
        if (this.fDeclaration == null) {
            throw new QuickFixException();
        }
        int n = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "(", this.fDeclaration.getStartOffset(), this.fDeclaration.getEndOffset(), false);
        int rightBracket = DVTDocumentUtils.getMatchingRightBracketOffset((int)n, (DVTEditor)this.targetEditor, (IDocument)document);
        if (rightBracket < 0) {
            return;
        }
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        ReplaceEdit replaceEdit = new ReplaceEdit(rightBracket - 1, 0, ", " + this.elementName);
        this.textFileChange.addEdit((TextEdit)replaceEdit);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.getDisplayString(), (Change)this.textFileChange);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.fDeclaration.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

