/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public class SensitivityRemoveQuickFix
extends BaseAbstractQuickFix {
    private int startOffset;
    private int endOffset;

    public SensitivityRemoveQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Remove signal '" + this.elementName + "' from sensitivity list";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PROCESS);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.startOffset = this.position.getOffset();
        this.endOffset = this.startOffset + this.position.getLength();
        boolean lastItem = false;
        int maxOffsetLimit = this.endOffset + 1000;
        int rParenOffset = Math.max(this.endOffset, VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, ")", this.endOffset, maxOffsetLimit, false));
        int rCommaOffset = Math.min(rParenOffset, VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, ",", this.endOffset, rParenOffset, true));
        if (this.endOffset < rParenOffset && rParenOffset == rCommaOffset) {
            lastItem = true;
        } else {
            this.endOffset = Math.min(rParenOffset, rCommaOffset);
            if (this.endOffset == rParenOffset) {
                --this.endOffset;
            }
        }
        int lParenOffset = Math.min(this.startOffset, VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(document, "(", 0, this.startOffset, false));
        int lCommaOffset = Math.max(lParenOffset, VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(document, ",", lParenOffset, this.startOffset, true));
        if (lastItem) {
            this.startOffset = lCommaOffset;
            if (this.startOffset == lParenOffset) {
                ++this.startOffset;
            }
        } else if (this.startOffset > lParenOffset) {
            // empty if block
        }
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        DeleteEdit deleteEdit = new DeleteEdit(this.startOffset, this.endOffset - this.startOffset);
        this.textFileChange.addEdit((TextEdit)deleteEdit);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.getDisplayString(), (Change)this.textFileChange);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

