/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.vhdldt.model.reflection.ConstraintHolder;
import ro.amiq.vhdldt.model.reflection.IndexConstraint;
import ro.amiq.vhdldt.model.reflection.OpenIndexConstraint;
import ro.amiq.vhdldt.model.reflection.RecordConstraintHolder;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfScalarType;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;

public class TypeName {
    public static final TypeName DEFAULT_TYPE_NAME = new TypeName((IRfNamedElement)new DummyElement("integer"));
    private static final String DEFAULT_INDEX_CONSTRAINT_TEXT = "1 to 10";
    private IRfNamedElement element;
    private List<String> constraintsText;

    public TypeName(IRfNamedElement elem) {
        this.element = elem;
        this.constraintsText = elem instanceof RfType ? TypeName.getDefaultConstraints((RfType)elem) : null;
    }

    public String getTypeName() {
        return this.element != null ? SEvaluator.filterTypeName(this.element.getName()) : null;
    }

    public boolean hasConstraints() {
        return this.constraintsText != null && !this.constraintsText.isEmpty();
    }

    public List<String> getConstraints() {
        return this.constraintsText;
    }

    public static List<String> getDefaultConstraints(RfType type) {
        ConstraintHolder constraintHolder = type.getConstraintHolder();
        if (constraintHolder == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!(constraintHolder instanceof RecordConstraintHolder)) {
            List<IndexConstraint> constraints = constraintHolder.getConstraints();
            if (constraints == null || constraints.isEmpty()) {
                if (type instanceof RfListType) {
                    result.add(DEFAULT_INDEX_CONSTRAINT_TEXT);
                }
                return result;
            }
            for (IndexConstraint constraint : constraints) {
                if (constraint instanceof OpenIndexConstraint) continue;
                result.add(TypeName.getDefaultString(constraint));
            }
            return result;
        }
        RecordConstraintHolder holder = (RecordConstraintHolder)constraintHolder;
        List<RfVariable> localMembers = type.getLocalMembers(RfVariable.class);
        if (localMembers != null) {
            for (RfVariable localMember : localMembers) {
                List<String> defaultConstraints;
                IRfNamedElement localMemberType;
                String name = localMember.getName();
                ConstraintHolder recordMemberHolder = holder.getMemberConstraintHolder(name);
                if (recordMemberHolder == null || !recordMemberHolder.isFullyConstrained() || !((localMemberType = localMember.getAssociatedType()) instanceof RfType) || (defaultConstraints = TypeName.getDefaultConstraints((RfType)localMemberType)) == null || defaultConstraints.isEmpty()) continue;
                StringBuilder constrText = new StringBuilder(name).append("(");
                int i = 0;
                while (i < defaultConstraints.size()) {
                    constrText.append(defaultConstraints.get(i)).append(i == defaultConstraints.size() - 1 ? "" : ", ");
                    ++i;
                }
                constrText.append(")");
                result.add(constrText.toString());
            }
        }
        return result;
    }

    @NotNull
    public static String getDefaultString(IndexConstraint constraint) {
        if (constraint == null) {
            return DEFAULT_INDEX_CONSTRAINT_TEXT;
        }
        IRfNamedElement type = STransformer.INSTANCE.getBaseType(constraint.getConstraintResolvedType(), true);
        if (type instanceof RfScalarType) {
            StringBuilder result = new StringBuilder(type.getName());
            return result.append("'LOW to ").append(type.getName()).append("'HIGH").toString();
        }
        return DEFAULT_INDEX_CONSTRAINT_TEXT;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeName other = (TypeName)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }
}

