/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.quickassist.util.VhdlQuickAssistUtil;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public abstract class UpdateEntityInstanceQuickFixCommon
extends BaseAbstractQuickFix {
    private static final String SIGNAL_NAME_CATEGORY = "signal_name";
    private IRfInstanceElement instance;
    private List<IHidOperator> instancePortConnections;
    private Collection<? extends IRfPortElement> entityPortConnections;

    protected UpdateEntityInstanceQuickFixCommon(IMarker marker, ITextViewer viewer, IRfInstanceElement instance, List<IHidOperator> instancePortConnections, Collection<? extends IRfPortElement> modulePortConnections) {
        super(marker, viewer);
        this.instance = instance;
        this.entityPortConnections = modulePortConnections;
        this.instancePortConnections = instancePortConnections;
        this.linkedProposalModel = new LinkedModeModel();
        this.targetResource = instance.getFileAdapter();
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getName(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        this.targetEditor = (DVTEditor)DVTUiUtils.getEditor((IDocument)document);
        this.targetDocument = document;
        if (!this.createChangesInternal()) {
            VhdlQuickAssistUtil.popSomethingWentWrong((String)this.getDisplayString());
            return;
        }
    }

    private boolean createChangesInternal() throws Exception {
        boolean hasMissingPorts;
        int instanceStartOffset = this.instance.getDeclaration().getStartOffset();
        int instanceEndOffset = this.instance.getDeclaration().getEndOffset();
        if (instanceStartOffset < 0 || instanceEndOffset >= this.triggerDocument.getLength()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        Region instanceRegion = new Region(instanceStartOffset, instanceEndOffset - instanceStartOffset);
        ArrayList<IRfPortElement> instanceCommonPorts = new ArrayList<IRfPortElement>();
        ArrayList<IHid> portsToBeDeleted = new ArrayList<IHid>();
        ArrayList<IRfPortElement> portsToBeAdded = new ArrayList<IRfPortElement>();
        LinkedHashMap<IRfPortElement, Integer> commonPortsByOffsets = new LinkedHashMap<IRfPortElement, Integer>();
        this.computePortsLists(instanceRegion, instanceCommonPorts, portsToBeAdded, portsToBeDeleted, commonPortsByOffsets);
        ArrayList<String> portsToBeAddedOnLastPositions = new ArrayList<String>();
        LinkedHashMap<String, List<String>> portsToBeAddedByNextPortInInstance = new LinkedHashMap<String, List<String>>();
        boolean isSorted = this.isInstanceSorted(portsToBeDeleted, portsToBeAdded);
        if (isSorted) {
            this.computePositionMapForNewPorts(portsToBeDeleted, portsToBeAddedOnLastPositions, portsToBeAddedByNextPortInInstance);
        } else {
            for (IRfPortElement port : portsToBeAdded) {
                portsToBeAddedOnLastPositions.add(port.getName());
            }
        }
        int portMapOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(this.triggerDocument, "port map", instanceStartOffset, instanceEndOffset, false);
        boolean hasPortMap = true;
        if (portMapOffset >= instanceEndOffset) {
            hasPortMap = false;
        }
        int leftBracketOffset = -1;
        int rightBracketOffset = -1;
        if (hasPortMap) {
            leftBracketOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)portMapOffset, (boolean)true, (int)100, (IDocument)this.triggerDocument, (String)"__vhdl_partitioning");
            rightBracketOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)leftBracketOffset, (DVTEditor)this.triggerEditor, (IDocument)this.triggerDocument);
        }
        String tabOrSpace = DVTDocumentUtils.getTabOrSpace((DVTEditor)this.targetEditor, (IPreferenceStore)VhdlPlugin.getDefault().getCombinedPreferenceStore());
        if (this.instancePortConnections == null || this.instancePortConnections.isEmpty()) {
            String indent = String.valueOf(tabOrSpace) + tabOrSpace + DVTDocumentUtils.getIndent((int)instanceStartOffset, (IDocument)this.targetDocument);
            this.addMissingPorts(instanceRegion, portsToBeAddedOnLastPositions, portsToBeAddedByNextPortInInstance, portMapOffset, hasPortMap, rightBracketOffset, false, indent, false);
            return true;
        }
        if (leftBracketOffset < 0 || leftBracketOffset >= this.triggerDocument.getLength() || rightBracketOffset < 0 || rightBracketOffset >= this.triggerDocument.getLength()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IRfPortElement lastCommonPort = null;
        if (!instanceCommonPorts.isEmpty()) {
            lastCommonPort = (IRfPortElement)instanceCommonPorts.get(instanceCommonPorts.size() - 1);
        }
        boolean bl = hasMissingPorts = !portsToBeAdded.isEmpty();
        if (lastCommonPort == null) {
            if (hasMissingPorts) {
                if (!portsToBeDeleted.isEmpty()) {
                    int deleteStartOffset = leftBracketOffset + 1;
                    int deleteEndOffset = rightBracketOffset - 1;
                    DeleteEdit incorrectPortDelete = new DeleteEdit(deleteStartOffset, deleteEndOffset - deleteStartOffset);
                    this.textFileChange.addEdit((TextEdit)incorrectPortDelete);
                }
                String indent = String.valueOf(tabOrSpace) + tabOrSpace + DVTDocumentUtils.getIndent((int)instanceStartOffset, (IDocument)this.targetDocument);
                this.addMissingPorts(instanceRegion, portsToBeAddedOnLastPositions, portsToBeAddedByNextPortInInstance, portMapOffset, hasPortMap, rightBracketOffset, false, indent, true);
            } else {
                int deleteStartOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(this.targetDocument, "port map", instanceStartOffset, portMapOffset, false);
                DeleteEdit deletePortMapEdit = new DeleteEdit(deleteStartOffset, rightBracketOffset - deleteStartOffset);
                this.textFileChange.addEdit((TextEdit)deletePortMapEdit);
            }
        } else {
            boolean addComma = false;
            IHid lastPortInInstanceHid = PortConnectionUtils.getPortHid((IHidOperator)this.instancePortConnections.get(this.instancePortConnections.size() - 1));
            Integer lastPortInInstanceOffset = this.getPortOffsetInInstance(instanceRegion, lastPortInInstanceHid);
            this.deletePorts(instanceRegion, portsToBeDeleted, commonPortsByOffsets, rightBracketOffset, lastCommonPort, lastPortInInstanceOffset, hasMissingPorts);
            if (hasMissingPorts) {
                IRfPortElement lastInstanceCommonPort = (IRfPortElement)instanceCommonPorts.get(instanceCommonPorts.size() - 1);
                Integer lastInstanceCommonPortOffset = (Integer)commonPortsByOffsets.get(lastInstanceCommonPort);
                if (lastInstanceCommonPortOffset.equals(lastPortInInstanceOffset)) {
                    addComma = true;
                }
                String indent = DVTDocumentUtils.getIndent((int)lastInstanceCommonPortOffset, (IDocument)this.targetDocument);
                this.addMissingPorts(instanceRegion, portsToBeAddedOnLastPositions, portsToBeAddedByNextPortInInstance, portMapOffset, hasPortMap, rightBracketOffset, addComma, indent, true);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void computePositionMapForNewPorts(List<IHid> portsToBeDeleted, List<String> portsToBeAddedOnLastPositions, Map<String, List<String>> portsToBeAddedByNextPortInInstance) {
        void var5_9;
        if (this.entityPortConnections == null && this.instancePortConnections == null) {
            return;
        }
        ArrayList<String> portsInEntityDef = new ArrayList<String>();
        for (IRfPortElement iRfPortElement : this.entityPortConnections) {
            portsInEntityDef.add(iRfPortElement.getName());
        }
        if (this.instancePortConnections == null) {
            this.instancePortConnections = Collections.emptyList();
        }
        boolean bl = false;
        int portIndexInInstance = 0;
        while (portIndexInInstance < this.instancePortConnections.size()) {
            if (var5_9 == portsInEntityDef.size()) break;
            IHidOperator instancePort = this.instancePortConnections.get(portIndexInInstance);
            String entityPortName = (String)portsInEntityDef.get((int)var5_9);
            IHid instancePortHid = PortConnectionUtils.getPortHid((IHidOperator)instancePort);
            if (portsToBeDeleted.contains(instancePortHid)) {
                ++portIndexInInstance;
                continue;
            }
            if (entityPortName.equals(PortConnectionUtils.getPortName((IHidOperator)instancePort))) {
                ++portIndexInInstance;
                ++var5_9;
                continue;
            }
            List<String> newPortsList = portsToBeAddedByNextPortInInstance.get(PortConnectionUtils.getPortName((IHidOperator)instancePort));
            if (newPortsList == null) {
                newPortsList = new ArrayList<String>();
            }
            while (var5_9 < portsInEntityDef.size() && !entityPortName.equals(PortConnectionUtils.getPortName((IHidOperator)instancePort))) {
                newPortsList.add(entityPortName);
                entityPortName = (String)portsInEntityDef.get((int)(++var5_9));
            }
            portsToBeAddedByNextPortInInstance.put(PortConnectionUtils.getPortName((IHidOperator)instancePort), newPortsList);
        }
        if (var5_9 < portsInEntityDef.size()) {
            portsToBeAddedOnLastPositions.addAll(portsInEntityDef.subList((int)var5_9, portsInEntityDef.size()));
        }
    }

    private boolean isInstanceSorted(List<IHid> portsToBeDeleted, List<IRfPortElement> portsToBeAdded) {
        ArrayList<String> portsInEntity = new ArrayList<String>();
        if (this.entityPortConnections != null) {
            for (IRfPortElement iRfPortElement : this.entityPortConnections) {
                portsInEntity.add(iRfPortElement.getName());
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.instancePortConnections != null) {
            for (IHidOperator iHidOperator : this.instancePortConnections) {
                arrayList.add(PortConnectionUtils.getPortName((IHidOperator)iHidOperator));
            }
        }
        for (IRfPortElement iRfPortElement : portsToBeAdded) {
            portsInEntity.remove(iRfPortElement.getName());
        }
        for (IHid iHid : portsToBeDeleted) {
            arrayList.remove(iHid.getName());
        }
        return portsInEntity.equals(arrayList);
    }

    private void deletePorts(Region instanceRegion, List<IHid> portsToBeDeleted, Map<IRfPortElement, Integer> commonPortsByOffsets, int rightBracketOffset, IRfPortElement lastCommonPort, Integer lastPortInInstanceOffset, boolean hasMissingPorts) throws BadLocationException, BadPartitioningException {
        int nextCommaOffset;
        if (portsToBeDeleted.isEmpty() || instanceRegion == null) {
            return;
        }
        int instanceStartOffset = instanceRegion.getOffset();
        int instanceEndOffset = instanceStartOffset + instanceRegion.getLength();
        int deletedPortsSize = portsToBeDeleted.size();
        int i = 0;
        while (i < deletedPortsSize - 1) {
            int nextCommaOffset2;
            IHid portToBeDeleted = portsToBeDeleted.get(i);
            Integer currDeletedPortOffset = this.getPortOffsetInInstance(instanceRegion, portToBeDeleted);
            if (currDeletedPortOffset != null && (nextCommaOffset2 = DVTDocumentUtils.getCharOffset((char)',', (int)currDeletedPortOffset, (boolean)true, (int)100, (IDocument)this.triggerDocument, (String)"__vhdl_partitioning")) >= 0 && nextCommaOffset2 <= instanceEndOffset) {
                DeleteEdit deleteEdit = new DeleteEdit(currDeletedPortOffset.intValue(), nextCommaOffset2 - currDeletedPortOffset + 1);
                this.textFileChange.addEdit((TextEdit)deleteEdit);
            }
            ++i;
        }
        IHid lastPortToBeDeleted = portsToBeDeleted.get(deletedPortsSize - 1);
        Integer lastPortToBeDeletedOffset = this.getPortOffsetInInstance(instanceRegion, lastPortToBeDeleted);
        if (lastPortToBeDeletedOffset != null && lastPortToBeDeletedOffset.equals(lastPortInInstanceOffset)) {
            DeleteEdit deleteEdit = new DeleteEdit(lastPortToBeDeletedOffset.intValue(), rightBracketOffset - lastPortToBeDeletedOffset - 1);
            this.textFileChange.addEdit((TextEdit)deleteEdit);
            Integer lastCommonPortOffset = commonPortsByOffsets.get(lastCommonPort);
            if (lastCommonPortOffset != null && !hasMissingPorts) {
                int nextCommaOffset3 = DVTDocumentUtils.getCharOffset((char)',', (int)lastCommonPortOffset, (boolean)true, (int)100, (IDocument)this.triggerDocument, (String)"__vhdl_partitioning");
                DeleteEdit commaDelete = new DeleteEdit(nextCommaOffset3, 1);
                this.textFileChange.addEdit((TextEdit)commaDelete);
            }
        } else if (lastPortToBeDeletedOffset != null && (nextCommaOffset = DVTDocumentUtils.getCharOffset((char)',', (int)lastPortToBeDeletedOffset, (boolean)true, (int)100, (IDocument)this.triggerDocument, (String)"__vhdl_partitioning") + 1) >= instanceStartOffset && nextCommaOffset <= instanceEndOffset) {
            DeleteEdit deleteEdit = new DeleteEdit(lastPortToBeDeletedOffset.intValue(), nextCommaOffset - lastPortToBeDeletedOffset);
            this.textFileChange.addEdit((TextEdit)deleteEdit);
        }
    }

    private void addMissingPorts(Region instanceRegion, List<String> portsToBeAddedOnLastPosition, Map<String, List<String>> portsToBeAddedByNextPortInInstance, int portMapOffset, boolean hasPortMap, int rightBracketOffset, boolean addComma, String indent, boolean addNewLineBeforeFirstPort) throws Exception {
        if (instanceRegion == null) {
            return;
        }
        Set<String> nextPortInInstance = portsToBeAddedByNextPortInInstance.keySet();
        String[] instancePortNames = nextPortInInstance.toArray(new String[nextPortInInstance.size()]);
        int i = 0;
        while (i < instancePortNames.length) {
            String instancePortName = instancePortNames[i];
            int startOffset = -1;
            List<String> portsToBeAddedForInstancePort = portsToBeAddedByNextPortInInstance.get(instancePortName);
            int portIndex = 0;
            while (portIndex < portsToBeAddedForInstancePort.size()) {
                String portName = portsToBeAddedForInstancePort.get(portIndex);
                String indentString = "," + DVTQuickFixUtil.NEW_LINE + indent;
                String portConnectionString = String.valueOf(portName) + " => " + portName + indentString;
                IHidOperator nextPort = this.computeNextPort(instancePortName);
                if (nextPort == null) {
                    return;
                }
                startOffset = PortConnectionUtils.getOpenBoundary((IHidOperator)nextPort);
                if (startOffset < 0) {
                    return;
                }
                InsertEdit insertEdit = new InsertEdit(startOffset, portConnectionString);
                this.textFileChange.addEdit((TextEdit)insertEdit, this.computeRegionsByCategory(insertEdit.getText(), portName));
                ++portIndex;
            }
            ++i;
        }
        int addedPortsOffset = -1;
        String portMap = "";
        if (!hasPortMap) {
            portMap = String.valueOf(portMap) + System.lineSeparator() + indent + "port map (" + System.lineSeparator();
        } else if (rightBracketOffset < 0 || rightBracketOffset > this.targetDocument.getLength()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (hasPortMap) {
            addedPortsOffset = rightBracketOffset - 1;
        } else {
            int instanceStartOffset = this.instance.getDeclaration().getStartOffset();
            int instanceEndOffset = this.instance.getDeclaration().getEndOffset();
            addedPortsOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(this.triggerDocument, ";", instanceStartOffset, instanceEndOffset, false);
        }
        boolean isFirstPort = true;
        int i2 = 0;
        while (i2 < portsToBeAddedOnLastPosition.size()) {
            String portName = portsToBeAddedOnLastPosition.get(i2);
            String indentString = "";
            if (isFirstPort && !hasPortMap) {
                indentString = String.valueOf(indentString) + portMap;
            }
            indentString = String.valueOf(indentString) + (isFirstPort && addComma ? String.valueOf(DVTQuickFixUtil.NEW_LINE) + indent + ", " : String.valueOf(DVTQuickFixUtil.NEW_LINE) + indent);
            String portConnectionString = String.valueOf(indentString) + portName + " => " + portName;
            if (isFirstPort) {
                isFirstPort = false;
            }
            if (i2 < portsToBeAddedOnLastPosition.size() - 1) {
                portConnectionString = String.valueOf(portConnectionString) + ",";
            }
            if (i2 == portsToBeAddedOnLastPosition.size() - 1) {
                portConnectionString = String.valueOf(portConnectionString) + DVTQuickFixUtil.NEW_LINE + indent;
            }
            if (!hasPortMap && i2 == portsToBeAddedOnLastPosition.size() - 1) {
                portConnectionString = String.valueOf(portConnectionString) + ")";
            }
            InsertEdit insertEdit = new InsertEdit(addedPortsOffset, portConnectionString);
            this.textFileChange.addEdit((TextEdit)insertEdit, this.computeRegionsByCategory(insertEdit.getText(), portName));
            ++i2;
        }
    }

    private IHidOperator computeNextPort(String instancePortName) {
        if (this.instancePortConnections == null) {
            return null;
        }
        for (IHidOperator instancePort : this.instancePortConnections) {
            if (!instancePortName.equals(PortConnectionUtils.getPortName((IHidOperator)instancePort))) continue;
            return instancePort;
        }
        return null;
    }

    private void computePortsLists(Region instanceRegion, List<IRfPortElement> instanceCommonPorts, List<IRfPortElement> portsToBeAdded, List<IHid> portsToBeDeleted, Map<IRfPortElement, Integer> instancePortsWithOffsets) {
        if (this.instancePortConnections == null && this.entityPortConnections == null) {
            return;
        }
        if (this.instancePortConnections == null) {
            this.instancePortConnections = Collections.emptyList();
        }
        if (this.entityPortConnections == null) {
            this.entityPortConnections = Collections.emptyList();
        }
        for (IHidOperator instancePC : this.instancePortConnections) {
            IHid instancePortHid = PortConnectionUtils.getPortHid((IHidOperator)instancePC);
            if (instancePortHid == null) continue;
            IRfNamedElement instancePort = instancePortHid.getElement();
            if (instancePort == null) {
                portsToBeDeleted.add(instancePortHid);
                continue;
            }
            if (!(instancePort instanceof IRfPortElement)) {
                portsToBeDeleted.add(instancePortHid);
                continue;
            }
            instanceCommonPorts.add((IRfPortElement)instancePort);
            instancePortsWithOffsets.put((IRfPortElement)instancePort, this.getPortOffsetInInstance(instanceRegion, instancePortHid));
        }
        portsToBeAdded.addAll(this.entityPortConnections);
        portsToBeAdded.removeAll(instanceCommonPorts);
    }

    private Integer getPortOffsetInInstance(Region region, IHid instancePortHid) {
        int occOffset;
        HidOccurrence hidOccurrence = instancePortHid.getOccurrence();
        if (hidOccurrence != null && (occOffset = hidOccurrence.getOffset()) >= region.getOffset() && occOffset <= region.getOffset() + region.getLength()) {
            return occOffset;
        }
        return -1;
    }

    protected void addLinkedPositions() throws Exception {
        Collection linkedPositionRegions = this.textFileChange.getAbsoluteRegionsByCategory(SIGNAL_NAME_CATEGORY);
        if (linkedPositionRegions == null || linkedPositionRegions.isEmpty()) {
            return;
        }
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.targetEditor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        for (IRegion region : linkedPositionRegions) {
            this.linkedPositionProvider.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.targetDocument);
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    private Map<String, List<IRegion>> computeRegionsByCategory(String text, String portName) {
        LinkedHashMap<String, List<IRegion>> regionsByCategory = new LinkedHashMap<String, List<IRegion>>();
        List<IRegion> signalNameRegion = this.getLinkedRegionsForSignalName(text, portName);
        if (portName != null && !portName.isEmpty()) {
            regionsByCategory.put(SIGNAL_NAME_CATEGORY, signalNameRegion);
        }
        return regionsByCategory;
    }

    private List<IRegion> getLinkedRegionsForSignalName(String text, String word) {
        ArrayList<IRegion> result = new ArrayList<IRegion>();
        String capturingGroup = "GROUP";
        Matcher matcher = Pattern.compile(" => (?<" + capturingGroup + ">\\w+)").matcher("");
        int regionOffset = 0;
        int regionLength = word.length();
        matcher.reset(text);
        while (matcher.find()) {
            regionOffset = matcher.start(capturingGroup);
            Region wordRegion = new Region(regionOffset, regionLength);
            result.add((IRegion)wordRegion);
        }
        return result;
    }

    private String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public String getDisplayString() {
        return "Update instance to match entity definition";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY_INSTANCE);
    }

    public IFile[] getAffectedFiles() throws Exception {
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        Object[] objectArray = this.textFileChange.getAffectedObjects();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IFile) {
                affectedFiles.add((IFile)o);
            }
            ++n2;
        }
        IFile[] affectedFilesArray = affectedFiles.toArray(new IFile[affectedFiles.size()]);
        return affectedFilesArray;
    }
}

