/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.util;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;

public class EnumTypeLHHidOperatorVisitor
implements IHidVisitor<HidOperator> {
    private RfEnum lastEnum = null;
    private IProgressMonitor progressMonitor;
    private String elementName;
    private Position position;
    private boolean monitorCancelled;

    public EnumTypeLHHidOperatorVisitor(IProgressMonitor progressMonitor, String elementName, Position position) {
        this.progressMonitor = progressMonitor;
        this.elementName = elementName;
        this.position = position;
    }

    public boolean visit(HidOperator operator) {
        if (this.progressMonitor.isCanceled()) {
            this.monitorCancelled = true;
            return false;
        }
        ListContainer rhValues = operator.getRHValues();
        if (rhValues == null || rhValues.size() != 1) {
            return true;
        }
        IHidObject rhValue = (IHidObject)rhValues.get(0);
        if (!(rhValue instanceof RfHid)) {
            return true;
        }
        RfHid rightHandHid = (RfHid)rhValue;
        if (!this.elementName.equals(rightHandHid.getName())) {
            return true;
        }
        if (!DVTQuickFixUtil.isHidInRegion((IHidOccurrenceHolder)rightHandHid, (IRegion)new Region(this.position.getOffset(), this.position.getLength()))) {
            return true;
        }
        IRfNamedElement type = null;
        HidAccess parentAccess = rightHandHid.getParentAccess();
        if (parentAccess != null && parentAccess.getAccessKind() == 0 && !(parentAccess.getAssociatedType() instanceof RfPackage)) {
            return true;
        }
        Set lhValues = operator.getLHHids(DVTQuickFixUtil.FLATTENING_OPTIONS);
        if (lhValues == null || lhValues.size() != 1) {
            return true;
        }
        IHid lhValue = (IHid)lhValues.iterator().next();
        if (!(lhValue instanceof RfHid)) {
            return true;
        }
        IRfNamedElement lhElement = ((RfHid)lhValue).getElement();
        if (lhElement instanceof RfAssociatedType) {
            type = ((RfAssociatedType)lhElement).getAssociatedType();
        }
        if (type instanceof RfAlias) {
            type = ((RfAlias)type).getTranslatedType();
        }
        if (!(type instanceof RfType)) {
            return true;
        }
        List<RfEnum> enums = ((RfType)type).getEnumsWithPrefix("", 2);
        if (enums == null || enums.isEmpty()) {
            return true;
        }
        this.lastEnum = enums.get(enums.size() - 1);
        return false;
    }

    public Class<HidOperator> getType() {
        return HidOperator.class;
    }

    public RfEnum getEnum() {
        return this.lastEnum;
    }

    public boolean isMonitorCancelled() {
        return this.monitorCancelled;
    }
}

