/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.vhdldt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;

public class GetTypesInProjectVisitor
implements IRfNamedElementVisitor {
    private List<RfType> types;
    private IProgressMonitor fProgressMonitor;
    private boolean monitorCancelled;

    public GetTypesInProjectVisitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
        this.types = new ArrayList<RfType>();
    }

    @Override
    public boolean visit(RfNamedElement namedElement) {
        if (this.fProgressMonitor.isCanceled()) {
            this.monitorCancelled = true;
            return false;
        }
        if (namedElement instanceof RfProject) {
            Collection<RfLibrary> libraries = ((RfProject)namedElement).getLibraries();
            if (libraries == null || libraries.isEmpty()) {
                return true;
            }
            for (RfLibrary library : libraries) {
                if (this.fProgressMonitor.isCanceled()) {
                    this.monitorCancelled = true;
                    return false;
                }
                if (this.visit(library)) continue;
                return false;
            }
        }
        if (namedElement instanceof RfLibrary) {
            List<RfPackage> packages = ((RfLibrary)namedElement).getPackagesWithPrefix("", 2);
            if (packages == null || packages.isEmpty()) {
                return true;
            }
            for (RfPackage pack : packages) {
                if (this.visit(pack)) continue;
                return false;
            }
        }
        if (namedElement instanceof RfPackage) {
            Collection<RfNamedElement> members = namedElement.getMembers();
            if (members == null || members.isEmpty()) {
                return true;
            }
            for (RfNamedElement member : members) {
                if (this.fProgressMonitor.isCanceled()) {
                    this.monitorCancelled = true;
                    return false;
                }
                if (member instanceof RfPackage && !this.visit(member)) {
                    return false;
                }
                if (!(member instanceof RfType)) continue;
                this.types.add((RfType)member);
            }
        }
        return true;
    }

    public List<RfType> getTypes() {
        return this.types;
    }

    public boolean isMonitorCancelled() {
        return this.monitorCancelled;
    }
}

