/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.AbstractQuickFix;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.DesignElementQuickFixProxy;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtilCommon;

public class VhdlQuickFixUtil
extends VhdlQuickFixUtilCommon {
    private static VhdlQuickFixUtil INSTANCE;
    private static final Object SYNC_OBJECT;
    public static final Set<HidFlatteningOption> FLATTENING_OPTIONS;

    static {
        SYNC_OBJECT = new Object();
        FLATTENING_OPTIONS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VhdlQuickFixUtil getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VhdlQuickFixUtil();
            }
        }
        return INSTANCE;
    }

    @Override
    protected List<ICompletionProposal> computeQuickFixProposalsOnJob(final int quickFixKind, final boolean isHierarchical, final IMarker marker, final ITextViewer viewer, final Object scope, final int offset, final Position position, final String elementName, final List<ICompletionProposal> existingProposals, boolean b) {
        final ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        final AtomicBoolean done = new AtomicBoolean(false);
        Job computingQuickFixProposalJob = new Job("Compute Quick Fix Proposals Job"){

            protected IStatus run(IProgressMonitor monitor) {
                List<ICompletionProposal> proposalsByKindInternal = VhdlQuickFixUtil.this.getProposalsByKindInternal(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, monitor, false);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                result.addAll(proposalsByKindInternal);
                done.set(true);
                return Status.OK_STATUS;
            }
        };
        computingQuickFixProposalJob.schedule();
        long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
        DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingQuickFixProposalJob, (AtomicBoolean)done, (String)"Computing quick fix proposals...", (long)busyIndicatorTimeout);
        return result;
    }

    @Override
    protected List<ICompletionProposal> computeQuickFixProposals(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, Object scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, boolean b, IProgressMonitor monitor) {
        VhdlQuickFixUtil.scheduleTimeoutWatchDog((IProgressMonitor)monitor, (int)200);
        List<ICompletionProposal> proposalsByKindInternal = this.getProposalsByKindInternal(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, monitor, true);
        return proposalsByKindInternal;
    }

    @Override
    protected AbstractQuickFix getUpdateInstanceProposal(List<IHidOperator> instancePortConnections, DesignElementQuickFixProxy designElementProxy, Collection<? extends IRfPortElement> entityPorts, IMarker marker, ITextViewer viewer, IRfInstanceElement instance) {
        return designElementProxy.getUpdateInstanceQuickFix(instancePortConnections, entityPorts);
    }

    @Override
    protected AbstractQuickFix getAddPortProposal(IHidOperator operator, DesignElementQuickFixProxy designElementProxy, IMarker marker, ITextViewer viewer) {
        return designElementProxy.getAddPortQuickFix(operator.getRHHids(FLATTENING_OPTIONS));
    }

    @Override
    protected AbstractQuickFix getAddGenericProposal(IHidOperator operator, DesignElementQuickFixProxy designElementProxy, IMarker marker, ITextViewer viewer) {
        return designElementProxy.getAddGenericQuickFix();
    }
}

