/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.GenericValueUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.AbstractQuickFix;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.DesignElementQuickFixProxy;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.editor.quickfix.util.MinWordDistanceComparator;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfActionBlock;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidUtils;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.r2lparser.R2LManager;
import ro.amiq.vhdldt.r2lparser.R2LNoProposalElement;
import ro.amiq.vhdldt.r2lparser.R2LProposalManager;
import ro.amiq.vhdldt.r2lparser.R2LResultContainer;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.CaseChoiseAddQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.CaseChoiseRemoveQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.DeclareArgumentQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.DeclareEnumQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.DeclareSignalQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.DeclareVariableQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.DeprecatedPkgRemoveQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.DeprecatedPkgReplaceQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.DidYouMeanQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.FullyQualifyQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.ImportQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.LibraryClauseRemoveQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.RemoveUnusedSignalQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.SensitivityAddQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.SensitivityRemoveQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.EnumTypeLHHidOperatorVisitor;
import ro.amiq.vhdldt.ui.editor.quickfix.util.GetTypesInProjectVisitor;
import ro.amiq.vhdldt.ui.editor.quickfix.util.TypeOperatorVisitor;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;

public abstract class VhdlQuickFixUtilCommon
extends DVTQuickFixUtil {
    public List<ICompletionProposal> getProposalsByKind(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, Object scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, boolean startMonitorJob, IProgressMonitor monitor) {
        if (startMonitorJob) {
            return this.computeQuickFixProposalsOnJob(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, true);
        }
        return this.computeQuickFixProposals(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, true, monitor);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected List<ICompletionProposal> getProposalsByKindInternal(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, Object scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        boolean addDidYouMeanProposal = true;
        try {
            switch (quickFixKind) {
                case 1: {
                    if (!(scope instanceof RfDefElement)) break;
                    RfDefElement enclosingScope = (RfDefElement)scope;
                    RfNamedElement namedElement = enclosingScope.getNamedElement();
                    BaseAbstractQuickFix proposal = null;
                    EnumTypeLHHidOperatorVisitor enumVisitor = this.getEnumVisitor(namedElement, elementName, position, isHierarchical, progressMonitor);
                    if (enumVisitor == null) break;
                    if (enumVisitor.isMonitorCancelled() && isTooltipTriggered) {
                        return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                    }
                    RfEnum lastEnum = enumVisitor.getEnum();
                    if (lastEnum != null && lastEnum.getDeclaration() != null) {
                        RfDefElement enumDeclaration = lastEnum.getDeclaration();
                        marker.setAttribute("QUICKFIX_ENUM_INSERT_OFFSET", enumDeclaration.getStartOffset() + enumDeclaration.getName().length());
                        marker.setAttribute("QUICKFIX_INSERT_FILE", (Object)enumDeclaration.getParserPath().toString());
                        proposal = new DeclareEnumQuickFix(marker, viewer);
                        ArrayList quickFixClass = new ArrayList();
                        quickFixClass.add(((Object)((Object)proposal)).getClass());
                        if (!VhdlQuickFixUtilCommon.containsProposal(quickFixClass, existingProposals, (String)elementName)) {
                            proposal.setParameters(offset, position, enclosingScope, elementName);
                            proposals.add((ICompletionProposal)proposal);
                        }
                    }
                    if (namedElement instanceof RfFunction || namedElement instanceof RfProcess || namedElement instanceof RfActionBlock) {
                        proposal = new DeclareVariableQuickFix(marker, viewer);
                        proposal.setParameters(offset, position, enclosingScope, elementName);
                        proposals.add((ICompletionProposal)proposal);
                    }
                    if (!isHierarchical && namedElement != null && namedElement.getEnclosingScope(RfFunction.class) != null) {
                        proposal = new DeclareArgumentQuickFix(marker, viewer);
                        proposal.setParameters(offset, position, enclosingScope, elementName);
                        proposals.add((ICompletionProposal)proposal);
                    }
                    boolean doNotProposeDeclareSignal = false;
                    if (namedElement != null && namedElement instanceof IRfInstanceElement) {
                        IRfInstanceElement instance = (IRfInstanceElement)namedElement;
                        RfDefElement rfDefElement = (RfDefElement)instance.getDeclaration();
                        if (rfDefElement == null) break;
                        IRfNamedElement instanceDesignElement = instance.getGenericDesign(null);
                        List instancePortConnections = instance.getHidOperators(ELConstants.PORT_AND_GENERIC_VALUES_QUALIFIERS_ARRAY, true);
                        if (instanceDesignElement == null || !(instanceDesignElement instanceof IRfDesignElement) || instancePortConnections == null) break;
                        HashSet<Class<RfEntity>> classes = new HashSet<Class<RfEntity>>();
                        classes.add(RfEntity.class);
                        IRfScopeElement triggerEntityScope = rfDefElement.getEnclosingScope(classes);
                        if (!(triggerEntityScope instanceof IRfDesignElement)) break;
                        block16: for (IHidOperator operator : instancePortConnections) {
                            boolean isHidofAccess;
                            IHid candidateHid;
                            if (isTooltipTriggered && progressMonitor.isCanceled()) {
                                proposals.clear();
                                return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                            }
                            boolean isPortConnection = operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION);
                            IHid iHid = candidateHid = isPortConnection ? PortConnectionUtils.getPortHid((IHidOperator)operator) : GenericValueUtils.getGenericHid((IHidOperator)operator);
                            if (candidateHid == null || HidUtils.isResolved((IHidObject)candidateHid)) continue;
                            ArrayList<IHid> candidates = new ArrayList<IHid>(2);
                            candidates.add(candidateHid);
                            IHidObject lhValue = operator.getLHValue();
                            boolean bl = isHidofAccess = HidUtils.isHidAccess((IHidObject)lhValue) && candidateHid == ((HidAccess)lhValue).getParentHid();
                            if (isHidofAccess) {
                                Set additionalHids = HidUtils.flattenToHids((List)((HidAccess)lhValue).getSelects(), EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_SELECTS));
                                for (IHid hid : additionalHids) {
                                    boolean resolved = HidUtils.isResolved((IHidObject)hid);
                                    if (isTooltipTriggered && progressMonitor.isCanceled()) {
                                        proposals.clear();
                                        return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                                    }
                                    if (resolved && hid.getElement() instanceof RfPort) {
                                        candidates = new ArrayList(1);
                                        break;
                                    }
                                    if (hid == null || resolved) continue;
                                    candidates.add(hid);
                                }
                            }
                            DesignElementQuickFixProxy designElementProxy = new DesignElementQuickFixProxy(marker, viewer, instance, (IRfDesignElement)instanceDesignElement, (IRfDesignElement)triggerEntityScope);
                            for (IHid candidate : candidates) {
                                if (isPortConnection) {
                                    List entityPorts;
                                    if (!VhdlQuickFixUtilCommon.isHidInRegion((IHidOccurrenceHolder)candidate, (IRegion)new Region(position.getOffset(), position.getLength()))) continue;
                                    if (isTooltipTriggered && progressMonitor.isCanceled()) {
                                        proposals.clear();
                                        return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                                    }
                                    doNotProposeDeclareSignal = true;
                                    proposal = this.getAddPortProposal(operator, designElementProxy, marker, viewer);
                                    if (proposal != null) {
                                        proposal.setParameters(offset, position, enclosingScope, elementName);
                                        proposals.add((ICompletionProposal)proposal);
                                    }
                                    if ((proposal = this.getUpdateInstanceProposal(instancePortConnections, designElementProxy, entityPorts = ((IRfDesignElement)instanceDesignElement).getLocalPortsNoAliases(), marker, viewer, instance)) == null) continue;
                                    ArrayList quickFixClass = new ArrayList();
                                    quickFixClass.add(((Object)((Object)proposal)).getClass());
                                    if (VhdlQuickFixUtilCommon.containsProposal(quickFixClass, existingProposals, (String)elementName)) continue;
                                    proposal.setParameters(offset, position, enclosingScope, elementName);
                                    proposals.add((ICompletionProposal)proposal);
                                    continue;
                                }
                                if (!VhdlQuickFixUtilCommon.isHidInRegion((IHidOccurrenceHolder)candidate, (IRegion)new Region(position.getOffset(), position.getLength()))) continue;
                                doNotProposeDeclareSignal = true;
                                proposal = this.getAddGenericProposal(operator, designElementProxy, marker, viewer);
                                if (proposal == null) continue block16;
                                proposal.setParameters(offset, position, enclosingScope, elementName);
                                proposals.add((ICompletionProposal)proposal);
                            }
                        }
                    }
                    if (doNotProposeDeclareSignal || namedElement == null || namedElement.getEnclosingScope(RfArchitecture.class) == null) break;
                    proposal = new DeclareSignalQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, enclosingScope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 2: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new SensitivityAddQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 3: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new SensitivityRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 48: {
                    if (!(scope instanceof RfDefElement)) break;
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new RemoveUnusedSignalQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 4: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new CaseChoiseAddQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 5: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new CaseChoiseRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 6: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new DeprecatedPkgReplaceQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 7: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new DeprecatedPkgRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 8: {
                    addDidYouMeanProposal = false;
                    BaseAbstractQuickFix proposal = new LibraryClauseRemoveQuickFix(marker, viewer);
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 9: {
                    BaseAbstractQuickFix proposal = new DeclareEnumQuickFix(marker, viewer);
                    ArrayList quickFixClasses = new ArrayList();
                    quickFixClasses.add(((Object)((Object)proposal)).getClass());
                    if (VhdlQuickFixUtilCommon.containsProposal(quickFixClasses, existingProposals, (String)elementName)) break;
                    proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
                case 10: {
                    RfDefElement elementToImportAbove;
                    BaseAbstractQuickFix proposal;
                    RfProject enclosingProject = ((RfDefElement)scope).getRfProject();
                    if (enclosingProject == null) break;
                    GetTypesInProjectVisitor visitor = new GetTypesInProjectVisitor(progressMonitor);
                    visitor.visit(enclosingProject);
                    List<RfType> types = visitor.getTypes();
                    if (types == null || types.isEmpty()) break;
                    if (isTooltipTriggered && visitor.isMonitorCancelled()) {
                        return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                    }
                    RfNamedElement enclosingScope = ((RfDefElement)scope).getNamedElement();
                    while (enclosingScope != null && !(enclosingScope.getEnclosingScope() instanceof RfLibrary)) {
                        enclosingScope = enclosingScope.getEnclosingScope();
                    }
                    if (enclosingScope == null || (elementToImportAbove = enclosingScope.getDeclaration()) == null) break;
                    for (RfNamedElement rfNamedElement : types) {
                        String segmentsString;
                        if (progressMonitor.isCanceled()) {
                            if (isTooltipTriggered) {
                                return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                            }
                            return null;
                        }
                        if (rfNamedElement.getEnclosingScope() == null || !rfNamedElement.getName().equalsIgnoreCase(elementName) || !(rfNamedElement.getEnclosingScope() instanceof RfPackage)) continue;
                        String libraryName = this.getLibNameFromElement(rfNamedElement);
                        String importScopeLibraryName = this.getLibNameFromElement(elementToImportAbove.getNamedElement());
                        if (libraryName.equalsIgnoreCase("work") && !libraryName.equalsIgnoreCase(importScopeLibraryName)) continue;
                        if (importScopeLibraryName.equalsIgnoreCase(libraryName)) {
                            libraryName = "work";
                        }
                        if ((segmentsString = VhdlQuickFixUtilCommon.getSegmentsString(rfNamedElement, progressMonitor, libraryName)) == null) continue;
                        proposal = new ImportQuickFix(marker, viewer, rfNamedElement, elementToImportAbove, segmentsString, libraryName);
                        proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                        proposals.add((ICompletionProposal)proposal);
                        proposal = new FullyQualifyQuickFix(marker, viewer, segmentsString);
                        proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                        proposals.add((ICompletionProposal)proposal);
                    }
                    break;
                }
                case 38: 
                case 44: {
                    List entityPorts;
                    DesignElementQuickFixProxy designElementProxy;
                    IRfInstanceElement instance;
                    RfDefElement instanceDeclaration;
                    RfDefElement rfDefElement;
                    RfNamedElement namedElement;
                    BaseAbstractQuickFix proposal;
                    addDidYouMeanProposal = false;
                    if (!(scope instanceof RfDefElement) || (namedElement = (rfDefElement = (RfDefElement)scope).getNamedElement()) == null || !(namedElement instanceof IRfInstanceElement) || (instanceDeclaration = (RfDefElement)(instance = (IRfInstanceElement)namedElement).getDeclaration()) == null) break;
                    IRfNamedElement instanceDesignElement = instance.getGenericDesign(null);
                    List instancePortConnections = instance.getHidOperators(ELConstants.PORT_AND_GENERIC_VALUES_QUALIFIERS_ARRAY, true);
                    if (instanceDesignElement == null || !(instanceDesignElement instanceof IRfDesignElement)) break;
                    HashSet<Class<RfEntity>> classes = new HashSet<Class<RfEntity>>();
                    classes.add(RfEntity.class);
                    IRfScopeElement triggerEntityScope = instanceDeclaration.getEnclosingScope(classes);
                    if (!(triggerEntityScope instanceof IRfDesignElement) || (proposal = this.getUpdateInstanceProposal(instancePortConnections, designElementProxy = new DesignElementQuickFixProxy(marker, viewer, instance, (IRfDesignElement)instanceDesignElement, (IRfDesignElement)triggerEntityScope), entityPorts = ((IRfDesignElement)instanceDesignElement).getLocalPortsNoAliases(), marker, viewer, instance)) == null) break;
                    ArrayList quickFixClass = new ArrayList();
                    quickFixClass.add(((Object)((Object)proposal)).getClass());
                    if (VhdlQuickFixUtilCommon.containsProposal(quickFixClass, existingProposals, (String)elementName)) break;
                    proposal.setParameters(offset, position, rfDefElement, elementName);
                    proposals.add((ICompletionProposal)proposal);
                    break;
                }
            }
            int wordLength = position.getLength();
            if (addDidYouMeanProposal && wordLength > 2) {
                ArrayList<Class<DidYouMeanQuickFix>> quickFixClass = new ArrayList<Class<DidYouMeanQuickFix>>();
                quickFixClass.add(DidYouMeanQuickFix.class);
                if (!VhdlQuickFixUtilCommon.containsProposal(quickFixClass, existingProposals, (String)elementName)) {
                    this.addDidYouMeanProposal(marker, viewer, scope, offset, position, elementName, proposals, progressMonitor, isTooltipTriggered);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return proposals;
    }

    private EnumTypeLHHidOperatorVisitor getEnumVisitor(RfNamedElement container, String elementName, Position position, boolean isHierarchical, IProgressMonitor progressMonitor) {
        if (elementName == null || elementName.isEmpty() || container == null) {
            return null;
        }
        EnumTypeLHHidOperatorVisitor enumVisitor = new EnumTypeLHHidOperatorVisitor(progressMonitor, elementName, position);
        container.visitHidObject(container.getRfProject(), enumVisitor);
        return enumVisitor;
    }

    private void addDidYouMeanProposal(IMarker marker, ITextViewer viewer, Object scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) throws BadLocationException {
        RfFileDef file;
        RfDefElement containingScope = (RfDefElement)scope;
        if (containingScope == null) {
            return;
        }
        RfFileDef rfFileDef = file = containingScope instanceof RfFileDef ? (RfFileDef)containingScope : containingScope.getDefFile();
        if (file == null) {
            return;
        }
        IResource fileAdapter = file.getFileAdapter();
        IDocument document = file.getDocument();
        RfProject rfProject = containingScope.getRfProject();
        if (fileAdapter == null || document == null || rfProject == null) {
            return;
        }
        if (position == null) {
            return;
        }
        int startOffset = position.getOffset();
        int length = position.getLength();
        if (startOffset < 0 || length == 0) {
            return;
        }
        String distanceTo = document.get(startOffset, length);
        IRfNamedElement[] candidates = this.getSortedCandidates(rfProject, containingScope, fileAdapter, document, startOffset + length, distanceTo, progressMonitor);
        if (candidates == null) {
            return;
        }
        int maxCandidates = Math.min(candidates.length, 3);
        int i = 0;
        while (i < maxCandidates) {
            if (progressMonitor.isCanceled() && isTooltipTriggered) {
                proposals.clear();
                proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
                return;
            }
            IRfNamedElement candidate = candidates[i];
            String name = candidate.getName();
            if (name != null && !name.isEmpty() && !name.equalsIgnoreCase(elementName)) {
                Image image;
                if (candidate instanceof RfType) {
                    name = this.getCorrectCase(name, true);
                }
                if ((image = candidate.getImage()) == null || image.isDisposed()) {
                    image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
                }
                DidYouMeanQuickFix proposal = new DidYouMeanQuickFix(marker, viewer, name, image, file);
                proposal.setParameters(offset, position, (RfDefElement)scope, elementName);
                proposals.add((ICompletionProposal)proposal);
            }
            ++i;
        }
    }

    private IRfNamedElement[] getSortedCandidates(RfProject rfProject, IRfScope containingScope, IResource fileAdapter, IDocument document, int proposalEndOffset, String distanceTo, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        R2LProposalManager manager = new R2LProposalManager(rfProject, containingScope, fileAdapter, document, proposalEndOffset, true);
        R2LResultContainer r2lResultContainer = ((R2LManager)manager).getProposals();
        if (r2lResultContainer == null) {
            return null;
        }
        IRfNamedElement[] candidates = r2lResultContainer.candidates;
        if (candidates == null || candidates.length == 0 || candidates[0] instanceof R2LNoProposalElement) {
            return null;
        }
        ArrayList<IRfNamedElement> listOfCandidates = new ArrayList<IRfNamedElement>();
        HashSet<String> candidateNames = new HashSet<String>();
        IRfNamedElement[] iRfNamedElementArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            IRfNamedElement candidate = iRfNamedElementArray[n2];
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return null;
            }
            String candidateName = candidate.getName();
            if (!candidateName.equals(distanceTo) && !candidateNames.contains(candidateName)) {
                listOfCandidates.add(candidate);
                candidateNames.add(candidateName);
            }
            ++n2;
        }
        candidates = listOfCandidates.toArray(new IRfNamedElement[listOfCandidates.size()]);
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        Arrays.sort(candidates, new MinWordDistanceComparator(distanceTo));
        return candidates;
    }

    public final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces, boolean grabEndOfLine) {
        try {
            grabWhiteSpaces |= grabEndOfLine;
            text = text.toUpperCase();
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), false);
            String content = null;
            int index = 0;
            char pch = ' ';
            do {
                int ch;
                if ((ch = scanner.read()) == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                index = Character.toUpperCase((char)ch) == text.charAt(text.length() - index - 1) && (index != 0 || index == 0 && Character.isJavaIdentifierPart(ch) && !Character.isJavaIdentifierPart(pch) || index == 0 && !Character.isJavaIdentifierPart(ch)) ? ++index : 0;
                if (index == text.length()) {
                    ch = scanner.read();
                    if (!(Character.isJavaIdentifierStart(text.charAt(0)) && Character.isJavaIdentifierStart((char)ch) || ch != -1 && Character.isWhitespace((char)ch) && Character.isJavaIdentifierPart((char)ch))) {
                        while (grabWhiteSpaces && Character.isWhitespace((char)ch) && (grabEndOfLine || (char)ch != '\r' && (char)ch != '\n')) {
                            ch = scanner.read();
                        }
                        scanner.unread();
                        return scanner.getOffset();
                    }
                    index = 0;
                }
                if (!(content = ((IDocumentExtension3)document).getContentType("__vhdl_partitioning", scanner.getOffset(), false)).equals("__dftl_partition_content_type")) continue;
                pch = (char)ch;
            } while (scanner.getOffset() > minOffsetLimit);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public final int getForwardOffsetFor(IDocument document, String text, int offset, int maxOffsetLimit, boolean grabEndOfLine) {
        String content;
        int ch;
        DVTCharacterScanner scanner;
        block29: {
            char pch;
            int index;
            block28: {
                maxOffsetLimit = Math.min(document.getLength(), maxOffsetLimit);
                text = text.toUpperCase();
                scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), true);
                index = 0;
                pch = ' ';
                ch = 0;
                content = ((IDocumentExtension3)document).getContentType("__vhdl_partitioning", scanner.getOffset(), false);
                if ("__dftl_partition_content_type".equals(content)) break block28;
                return -1;
            }
            do {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__vhdl_partitioning", scanner.getOffset(), false);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if (!"__dftl_partition_content_type".equals(content)) continue;
                index = Character.toUpperCase((char)ch) == text.charAt(index) && (!Character.isJavaIdentifierPart(ch) || Character.isWhitespace(pch) || Character.isJavaIdentifierPart(pch)) ? ++index : 0;
                if (index == text.length()) {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    scanner.unread();
                    if (ch == -1 || !Character.isWhitespace((char)ch) || !Character.isJavaIdentifierPart((char)ch)) {
                        if (grabEndOfLine && ch != -1) break;
                        return scanner.getOffset();
                    }
                    index = 0;
                }
                pch = (char)ch;
            } while (scanner.getOffset() < maxOffsetLimit);
            if (index != 0 && grabEndOfLine) break block29;
            return 0;
        }
        try {
            boolean removedMlComment = false;
            while (true) {
                if ("__dftl_partition_content_type".equals(content)) {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    content = ((IDocumentExtension3)document).getContentType("__vhdl_partitioning", scanner.getOffset(), false);
                    if (ch == -1) {
                        scanner.unread();
                        return scanner.getOffset();
                    }
                    if ((char)ch == '\r' || (char)ch == '\n') {
                        scanner.unread();
                    } else {
                        if (Character.isWhitespace((char)ch)) continue;
                        scanner.unread();
                        return scanner.getOffset();
                    }
                }
                removedMlComment = false;
                while ("__vhdl_ml_comment".equals(content)) {
                    removedMlComment = true;
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    content = ((IDocumentExtension3)document).getContentType("__vhdl_partitioning", scanner.getOffset(), false);
                    if (ch != -1) continue;
                    scanner.unread();
                    return scanner.getOffset();
                }
                if (!removedMlComment) break;
            }
            while ("__vhdl_sl_comment".equals(content)) {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__vhdl_partitioning", scanner.getOffset(), false);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch != '\r' && (char)ch != '\n') continue;
                scanner.unread();
                break;
            }
            if ("__dftl_partition_content_type".equals(content) || "__vhdl_sl_comment".equals(content)) {
                ch = scanner.read();
                if (scanner.getOffset() == maxOffsetLimit) {
                    return maxOffsetLimit;
                }
                content = ((IDocumentExtension3)document).getContentType("__vhdl_partitioning", scanner.getOffset(), false);
                if (ch == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch == '\r') {
                    ch = scanner.read();
                    if (scanner.getOffset() == maxOffsetLimit) {
                        return maxOffsetLimit;
                    }
                    if ((char)ch == '\n') {
                        return scanner.getOffset();
                    }
                    scanner.unread();
                    return scanner.getOffset();
                }
                if ((char)ch == '\n') {
                    return scanner.getOffset();
                }
                scanner.unread();
                return scanner.getOffset();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public String guessElementType(IRfNamedElement container, String elementName) {
        TypeOperatorVisitor visitor = new TypeOperatorVisitor(elementName);
        container.visitHidObject(null, (IHidVisitor)visitor);
        return visitor.getTypeName();
    }

    public String getCorrectCase(String dataTypeOrKeyword, boolean isDataType) {
        int preferenceValue;
        int keywordsPreference = VhdlPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.keywords");
        int dataTypesPreference = VhdlPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.data_types");
        int n = preferenceValue = isDataType ? dataTypesPreference : keywordsPreference;
        if (preferenceValue == 2) {
            return dataTypeOrKeyword.toUpperCase();
        }
        if (preferenceValue == 3) {
            return dataTypeOrKeyword.toLowerCase();
        }
        return dataTypeOrKeyword;
    }

    public String guessVariableDirection(RfNamedElement container, String elementName) {
        List<IHidOperator> operators = container.getHidOperators(ASSIGN_EXPRESSIONS, false);
        if (operators == null) {
            return "IN";
        }
        String direction = null;
        for (IHidOperator operator : operators) {
            Set lhHids = operator.getLHHids(VhdlQuickFixUtil.FLATTENING_OPTIONS);
            Set rhHids = operator.getRHHids(VhdlQuickFixUtil.FLATTENING_OPTIONS);
            for (IHid lhHid : lhHids) {
                if (!lhHid.getName().equals(elementName)) continue;
                int operatorType = operator.getOperatorType();
                if (operatorType == 194 || operatorType == 190) {
                    direction = "IN".equals(direction) ? "INOUT" : "OUT";
                } else {
                    String string = direction = "OUT".equals(direction) ? "INOUT" : "IN";
                }
                if (!"INOUT".equals(direction)) continue;
                return direction;
            }
            for (IHid rhHid : rhHids) {
                if (!rhHid.getName().equals(elementName)) continue;
                String string = direction = "OUT".equals(direction) ? "INOUT" : "IN";
                if (!"INOUT".equals(direction)) continue;
                return direction;
            }
        }
        if (direction == null) {
            return "IN";
        }
        return direction;
    }

    public final String getDefaultTypeName() {
        return "STD_LOGIC";
    }

    public final int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces) {
        return this.getBackwardOffsetFor(document, text, minOffsetLimit, offset, grabWhiteSpaces, false);
    }

    public final boolean updateVarTypeFromHids(Set<IHid> hids, String[] typeName) {
        return this.updateVarTypeFromHids(hids, typeName, true, false);
    }

    public final boolean updateVarTypeFromHids(Set<IHid> hids, String[] typeName, boolean allowRange, boolean translateType) {
        for (IHid hid : hids) {
            RfFunction functionCandidate;
            if (hid instanceof RfHidImplicit) {
                String guess = ((RfHidImplicit)hid).guessTypeName(false);
                if (guess == null) continue;
                typeName[0] = guess;
                continue;
            }
            IRfNamedElement element = hid.getElement();
            if (element instanceof RfEnum) {
                typeName[0] = ((RfEnum)element).getParentEnumTypeName();
                continue;
            }
            if (element instanceof RfFunctionsHolder && (functionCandidate = ((RfFunctionsHolder)element).getLastDefinedFunction()) != null) {
                element = functionCandidate;
            }
            if (!(element instanceof RfAssociatedType)) continue;
            String tempName = translateType ? RfHidUtils.getAssocBaseType((RfAssociatedType)element) : ((RfAssociatedType)element).getAssociatedTypeName();
            StringBuilder range = new StringBuilder();
            switch (((RfHid)hid).hasSelect(range, ((RfAssociatedType)element).getRange())) {
                case SELECT_BIT: {
                    int index = tempName.toUpperCase().indexOf("_VECTOR");
                    typeName[0] = index > 0 ? tempName.substring(0, index) : tempName;
                    break;
                }
                case SELECT_RANGE: {
                    boolean startsWithRange = range.toString().toUpperCase().startsWith("RANGE");
                    if (startsWithRange) {
                        typeName[0] = range.length() == 0 || !allowRange ? tempName : String.valueOf(tempName) + " " + range.toString();
                        break;
                    }
                    typeName[0] = range.length() == 0 || !allowRange ? tempName : String.valueOf(tempName) + "(" + range.toString() + ")";
                    break;
                }
                case SELECT_NONE: {
                    boolean startsWithRange = range.toString().toUpperCase().startsWith("RANGE");
                    typeName[0] = startsWithRange ? (range.length() == 0 || !allowRange ? tempName : String.valueOf(tempName) + " " + range.toString()) : (range.length() == 0 || !allowRange ? tempName : String.valueOf(tempName) + "(" + range.toString() + ")");
                    return true;
                }
            }
        }
        return false;
    }

    public RfDefElement getEnclosingDefAtOffset(int offset, DVTEditor editor, Set<?> classes) {
        RfDefElement defScopeAtOffset = (RfDefElement)RfUtils.getRfScope((ITextEditor)editor, editor.getDocument(), offset);
        if (defScopeAtOffset == null) {
            return null;
        }
        return this.getEnclosingDefScope(defScopeAtOffset, classes);
    }

    public RfDefElement getEnclosingDefScope(RfDefElement defElement, Set<?> classes) {
        RfNamedElement parentNamedElement = defElement.getNamedElement();
        RfDefElement enclosingDefFunction = null;
        int offset = defElement.getStartOffset();
        while (parentNamedElement != null) {
            if (classes.contains(parentNamedElement.getClass())) break;
            parentNamedElement = parentNamedElement.getEnclosingScope();
        }
        if (parentNamedElement == null) {
            return null;
        }
        for (RfDefElement rfDefElement : parentNamedElement.getDeclarations()) {
            if (rfDefElement.getStartOffset() > offset || rfDefElement.getEndOffset() < offset || !rfDefElement.getDefFile().equals(defElement.getDefFile())) continue;
            enclosingDefFunction = rfDefElement;
            break;
        }
        return enclosingDefFunction;
    }

    public RfNamedElement getEnclosingScope(RfDefElement defElement, Class<?> ... classes) {
        RfNamedElement scope = defElement.getNamedElement();
        HashSet classesSet = new HashSet(Arrays.asList(classes));
        do {
            if (!classesSet.contains(scope.getClass())) continue;
            return scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public IRfDefElement computeDeclarationAnchor(RfNamedElement enclosingScope, int minAnchorOffset, int maxAnchorOffset) {
        Collection<RfNamedElement> members;
        List<RfVariable> variables = enclosingScope.getLocalMembers(RfVariable.class);
        if (variables != null) {
            Collections.sort(variables, new VariableDeclarationOrder());
            for (RfVariable variable : variables) {
                RfDefElement declaration;
                if (variable.isArgument() || (declaration = variable.getDeclaration()) == null || declaration.getStartOffset() > maxAnchorOffset || declaration.getStartOffset() < minAnchorOffset) continue;
                return declaration;
            }
        }
        if ((members = enclosingScope.getMembers()) == null || members.isEmpty()) {
            return null;
        }
        ArrayList<RfNamedElement> membersList = new ArrayList<RfNamedElement>();
        for (RfNamedElement element : members) {
            if (element instanceof RfFunctionsHolder) {
                Collection<RfNamedElement> functions = ((RfFunctionsHolder)element).getMembers();
                if (functions == null) continue;
                membersList.addAll(functions);
                continue;
            }
            membersList.add(element);
        }
        Collections.sort(membersList, new MembersDeclarationOrder());
        for (RfNamedElement member : membersList) {
            RfDefElement declaration;
            if (member instanceof RfVariable && ((RfVariable)member).isArgument() || member instanceof RfActionBlock || (declaration = member.getDeclaration()) == null || declaration.getStartOffset() > maxAnchorOffset || declaration.getStartOffset() < minAnchorOffset) continue;
            return declaration;
        }
        return null;
    }

    public String getLibNameFromElement(RfNamedElement element) {
        LibraryPackageScope libPkg = element.getLibPkgScope();
        if (libPkg == null) {
            return null;
        }
        String libraryName = libPkg.getLibraryName();
        if (libraryName == null || libraryName.isEmpty()) {
            return null;
        }
        return libraryName;
    }

    public static String getSegmentsString(RfNamedElement type, IProgressMonitor progressMonitor, String libraryName) {
        DVTStringBuilder qname = new DVTStringBuilder();
        for (RfNamedElement enclosingScope = type.getEnclosingScope(); enclosingScope != null && !(enclosingScope instanceof RfLibrary); enclosingScope = enclosingScope.getEnclosingScope()) {
            if (!(enclosingScope instanceof RfPackage)) continue;
            qname.prepend('.').prepend(enclosingScope.getName());
            if (!progressMonitor.isCanceled()) continue;
            return null;
        }
        qname.prepend('.');
        qname.prepend(libraryName);
        return qname.toString();
    }

    protected abstract List<ICompletionProposal> computeQuickFixProposalsOnJob(int var1, boolean var2, IMarker var3, ITextViewer var4, Object var5, int var6, Position var7, String var8, List<ICompletionProposal> var9, boolean var10);

    protected abstract List<ICompletionProposal> computeQuickFixProposals(int var1, boolean var2, IMarker var3, ITextViewer var4, Object var5, int var6, Position var7, String var8, List<ICompletionProposal> var9, boolean var10, IProgressMonitor var11);

    protected abstract AbstractQuickFix getUpdateInstanceProposal(List<IHidOperator> var1, DesignElementQuickFixProxy var2, Collection<? extends IRfPortElement> var3, IMarker var4, ITextViewer var5, IRfInstanceElement var6);

    protected abstract AbstractQuickFix getAddPortProposal(IHidOperator var1, DesignElementQuickFixProxy var2, IMarker var3, ITextViewer var4);

    protected abstract AbstractQuickFix getAddGenericProposal(IHidOperator var1, DesignElementQuickFixProxy var2, IMarker var3, ITextViewer var4);

    public static class MembersDeclarationOrder
    implements Comparator<RfNamedElement> {
        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            RfDefElement declaration1 = o1.getDeclaration();
            RfDefElement declaration2 = o2.getDeclaration();
            if (declaration1 == null || declaration2 == null) {
                return 0;
            }
            return declaration1.getStartOffset() - declaration2.getStartOffset();
        }
    }

    public static class VariableDeclarationOrder
    implements Comparator<RfNamedElement> {
        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            RfDefElement declaration1 = o1.getDeclaration();
            RfDefElement declaration2 = o2.getDeclaration();
            if (declaration1 == null || declaration2 == null) {
                return 0;
            }
            if (declaration1.getNamedElement() instanceof RfFunction && declaration2.getNamedElement() instanceof RfFunction) {
                return declaration1.getStartOffset() - declaration2.getStartOffset();
            }
            return declaration2.getStartOffset() - declaration1.getStartOffset();
        }
    }
}

