/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.vhdldt.ui.editor.VhdlCodeScanner;

public class PslSlCommentRule
implements IRule {
    private IToken fDefaultToken;

    public PslSlCommentRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fDefaultToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        IDocument document = ((VhdlCodeScanner)scanner).getDocument();
        int offset = ((VhdlCodeScanner)scanner).getOffset() - 1;
        if ((char)c == '-') {
            c = scanner.read();
            if ((char)c == '-') {
                try {
                    int line = document.getLineOfOffset(offset);
                    IRegion region = document.getLineInformation(line);
                    String beforeText = document.get(region.getOffset(), offset - region.getOffset());
                    if (beforeText.trim().length() == 0) {
                        while ((c = scanner.read()) != -1 && Character.isWhitespace((char)c)) {
                        }
                        if ((char)c == 'p') {
                            c = scanner.read();
                            if ((char)c == 's') {
                                c = scanner.read();
                                if ((char)c == 'l') {
                                    return this.fDefaultToken;
                                }
                                scanner.unread();
                                return this.fDefaultToken;
                            }
                            scanner.unread();
                            return this.fDefaultToken;
                        }
                        scanner.unread();
                        return this.fDefaultToken;
                    }
                }
                catch (Exception exception) {
                    return Token.UNDEFINED;
                }
                while ((c = scanner.read()) != -1 && (char)c != '\r' && (char)c != '\n') {
                }
                return this.fDefaultToken;
            }
            scanner.unread();
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

