/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.rules;

import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.vhdldt.ui.editor.VhdlCodeScanner;

public class VhdlAttributesRule
implements IRule {
    private IToken fDefaultToken;
    private static HashSet<String> fWords = new HashSet();
    private StringBuilder fBuffer = new StringBuilder();

    public VhdlAttributesRule(String[] words, IToken token) {
        Assert.isNotNull((Object)token);
        Assert.isNotNull((Object)words);
        this.fDefaultToken = token;
        int i = 0;
        while (i < words.length) {
            fWords.add(words[i]);
            ++i;
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        int whitespacesNumber = 0;
        if ((char)c == '\'') {
            this.fBuffer.setLength(0);
            this.fBuffer.append((char)c);
            do {
                c = scanner.read();
                ++whitespacesNumber;
            } while (c != -1 && Character.isWhitespace((char)c));
            --whitespacesNumber;
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && Character.isJavaIdentifierPart((char)c));
            scanner.unread();
            if (fWords.contains(this.fBuffer.toString().toLowerCase())) {
                return this.fDefaultToken;
            }
            ((VhdlCodeScanner)scanner).unreadLength(this.fBuffer.length() + whitespacesNumber);
            return Token.UNDEFINED;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

