/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.vhdldt.ui.editor.VhdlCommentScanner;

public class VhdlCommentUserFoldingRule
implements IRule {
    private IToken fDefaultToken;
    private StringBuilder fBuffer = new StringBuilder();
    private int fNofLines;

    public VhdlCommentUserFoldingRule(IToken token, int nofLines) {
        Assert.isNotNull((Object)token);
        this.fDefaultToken = token;
        this.fNofLines = nofLines;
    }

    public IToken evaluate(VhdlCommentScanner scanner, boolean enable) {
        try {
            IDocument document = scanner.getDocument();
            if (document.getNumberOfLines() < this.fNofLines) {
                int c = scanner.read();
                if ((char)c == '{' || (char)c == '}') {
                    boolean close;
                    this.fBuffer.setLength(0);
                    do {
                        this.fBuffer.append((char)c);
                    } while ((c = scanner.read()) != -1 && ((char)c == '{' || (char)c == '}'));
                    scanner.unread();
                    String text = this.fBuffer.toString();
                    boolean open = text.equals("{{{") || text.equals("{{");
                    boolean bl = close = text.equals("}}}") || text.equals("}}");
                    if (enable && (open || close)) {
                        int offset = scanner.getOffset() - 1;
                        if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, DVTFoldingPosition.Type.USERDEF_BRACKET, open ? DVTFoldingPosition.SubType.START : DVTFoldingPosition.SubType.END));
                        }
                        return this.fDefaultToken;
                    }
                    scanner.unreadLength(this.fBuffer.length());
                    return Token.UNDEFINED;
                }
                if (c == 35) {
                    this.fBuffer.setLength(0);
                    do {
                        this.fBuffer.append((char)c);
                    } while ((c = scanner.read()) != -1 && (c == 101 || c == 103 || c == 105 || c == 111 || c == 110 || c == 100 || c == 114));
                    scanner.unread();
                    String text = this.fBuffer.toString();
                    boolean open = text.equals("#region");
                    boolean close = text.equals("#endregion");
                    if (enable && (open || close)) {
                        int offset = scanner.getOffset() - 1;
                        if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                            document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, DVTFoldingPosition.Type.USERDEF_REGION, open ? DVTFoldingPosition.SubType.START : DVTFoldingPosition.SubType.END));
                        }
                        return this.fDefaultToken;
                    }
                    scanner.unreadLength(this.fBuffer.length());
                    return Token.UNDEFINED;
                }
                scanner.unread();
            }
        }
        catch (Exception exception) {}
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate((VhdlCommentScanner)scanner, this.fNofLines != 0);
    }

    public void setNofLinesFolding(int nofLines) {
        this.fNofLines = nofLines;
    }
}

