/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.rules;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.vhdldt.ui.editor.VhdlCodeScanner;

public class VhdlFoldingZoneMarker
implements IRule {
    private int fNofLines;

    public VhdlFoldingZoneMarker(int nofLines) {
        this.fNofLines = nofLines;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate((VhdlCodeScanner)scanner, this.fNofLines != 0);
    }

    public IToken evaluate(VhdlCodeScanner scanner, boolean enable) {
        try {
            IDocument document = scanner.getDocument();
            if (document.getNumberOfLines() < this.fNofLines) {
                char ch = (char)scanner.read();
                if (enable && ch == '(') {
                    int offset = scanner.getOffset() - 1;
                    if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                        document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, ch));
                    }
                    scanner.unread();
                    return Token.UNDEFINED;
                }
                if (enable && ch == ')') {
                    int offset = scanner.getOffset() - 1;
                    if (document.containsPositionCategory("__dvt_folding_position") && !document.containsPosition("__dvt_folding_position", offset, 1)) {
                        document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, ch));
                    }
                    scanner.unread();
                    return Token.UNDEFINED;
                }
                scanner.unread();
                return Token.UNDEFINED;
            }
        }
        catch (Exception exception) {}
        return Token.UNDEFINED;
    }

    public void setNofLinesFolding(int nofLines) {
        this.fNofLines = nofLines;
    }
}

