/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.rules;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightPosition;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vhdldt.ui.editor.VhdlCodeScanner;
import ro.amiq.vhdldt.ui.editor.VhdlStyle;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class VhdlKeyWordRule
implements IRule,
IHighlightListener {
    private static final Comparator<Position> POSITION_COMPARATOR = new Comparator<Position>(){

        @Override
        public int compare(Position o1, Position o2) {
            return o1.getOffset() - o2.getOffset();
        }
    };
    private IToken fDefaultKeywordToken;
    private IToken fDefaultTemplateToken;
    private IToken fDefaultWordToken;
    private IToken fDefaultTypeToken;
    private IToken fDefaultMethodToken;
    private IToken fDefaultVariableToken;
    private IToken fDefaultPortToken;
    private IToken fDefaultOutPortToken;
    private IToken fDefaultConstantToken;
    private IToken fDefaultEnumItemsToken;
    private IToken fDefaultSignalToken;
    private IToken fDefaultAttributeToken;
    private IToken fDefaultLabelToken;
    private IToken fDefaultEndLabelToken;
    private IToken fDefaultRecordElementToken;
    private IToken fDefaultArgumentToken;
    private Position[] fSHPositions;
    private IDocument fDocument;
    private VhdlStyle fStyle;
    private int fNofLines;
    private HashSet<String> fWords = new HashSet();
    private HashSet<String> fTypes = new HashSet();
    private StringBuilder fBuffer = new StringBuilder();
    private static Matcher fx_ID_xTemplatePattern = Pattern.compile("x_[a-zA-Z$][a-zA-Z0-9$_]*?_x").matcher("");
    private Map<String, String> fNameToKeyWordMap = new LinkedHashMap<String, String>(8, 0.75f, true){
        private static final int MAX_ENTRIES = 256;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 256;
        }
    };
    private static Set<String> fBlockDefiningKeywords = new HashSet<String>(Arrays.asList("begin", "component", "case", "type", "if", "loop", "process", "generate", "architecture", "package", "record", "block", "configuration", "for", "procedure", "function", "entity", "protected"));
    private static Set<String> fMayTerminateWithEndName = new HashSet<String>(Arrays.asList("entity", "component", "process", "package", "architecture", "configuration", "procedure", "function", "block", "generate", "case"));
    private static Set<String> fLabeledBlocks = new HashSet<String>(Arrays.asList("process", "block", "generate", "if", "for", "function"));

    public VhdlKeyWordRule(String[] tokens, String[] types, VhdlStyle style, int nofLines) {
        IToken keywordToken = style.getToken("highlight.keyword");
        Assert.isNotNull((Object)keywordToken);
        Assert.isNotNull((Object)tokens);
        this.fDefaultKeywordToken = keywordToken;
        this.fDefaultTypeToken = style.getToken("highlight.types");
        this.fDefaultTemplateToken = style.getToken("highlight.template_id");
        this.fDefaultWordToken = style.getToken("highlight.default");
        this.fDefaultMethodToken = style.getToken("highlight.semantic_method");
        this.fDefaultVariableToken = style.getToken("highlight.semantic_variable");
        this.fDefaultPortToken = style.getToken("highlight.semantic_port");
        this.fDefaultOutPortToken = style.getToken("highlight.semantic_out_port");
        this.fDefaultConstantToken = style.getToken("highlight.semantic_constant");
        this.fDefaultEnumItemsToken = style.getToken("highlight.semantic_enum_item");
        this.fDefaultSignalToken = style.getToken("highlight.semantic_signal");
        this.fDefaultAttributeToken = style.getToken("highlight.attributes");
        this.fDefaultLabelToken = style.getToken("highlight.label");
        this.fDefaultEndLabelToken = style.getToken("highlight.end_label");
        this.fDefaultRecordElementToken = style.getToken("highlight.semantic_record_element");
        this.fDefaultArgumentToken = style.getToken("highlight.semantic_argument");
        this.fSHPositions = null;
        this.fDocument = null;
        this.fStyle = style;
        int i = 0;
        while (i < tokens.length) {
            this.fWords.add(tokens[i]);
            ++i;
        }
        i = 0;
        while (i < types.length) {
            this.fTypes.add(types[i]);
            ++i;
        }
        this.fNofLines = nofLines;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        try {
            TestHelper.getInstance().setLastTokenTime();
            int x_ID_xIdentifierMatches = 0;
            boolean isXTemplateIdentifierEnabled = this.fStyle.isXTemplateIdentifierHighlightEnabled();
            int startOffset = ((VhdlCodeScanner)scanner).getOffset() - 1;
            int ch = scanner.read();
            if (ch == -1) {
                return Token.UNDEFINED;
            }
            this.fDocument = ((VhdlCodeScanner)scanner).getDocument();
            if (Character.isJavaIdentifierStart(ch)) {
                SemanticHighlightPosition highlightPosition;
                Matcher matcher;
                this.fBuffer.delete(0, this.fBuffer.length());
                int p = 0;
                do {
                    this.fBuffer.append((char)ch);
                    if (isXTemplateIdentifierEnabled) {
                        if ((char)ch == '_' && (char)p == 'x') {
                            x_ID_xIdentifierMatches += 2;
                        }
                        if ((char)ch == 'x' && (char)p == '_') {
                            x_ID_xIdentifierMatches += 2;
                        }
                    }
                    p = ch;
                } while ((ch = scanner.read()) != -1 && Character.isJavaIdentifierPart(ch));
                scanner.unread();
                String text = this.fBuffer.toString();
                String lowerCaseText = text.toLowerCase();
                if (x_ID_xIdentifierMatches >= 4 && (matcher = fx_ID_xTemplatePattern.reset(lowerCaseText)).find()) {
                    if (matcher.start() == 0) {
                        ((VhdlCodeScanner)scanner).unreadLength(lowerCaseText.length() - matcher.end());
                        return this.fDefaultTemplateToken;
                    }
                    ((VhdlCodeScanner)scanner).unreadLength(lowerCaseText.length() - matcher.start());
                    return this.fDefaultWordToken;
                }
                if (this.fWords.contains(lowerCaseText)) {
                    if (this.fNofLines != 0 && this.fDocument.containsPositionCategory("__dvt_folding_position") && this.fDocument.getNumberOfLines() < this.fNofLines) {
                        int offset = ((VhdlCodeScanner)scanner).getOffset() - 1;
                        if (lowerCaseText.equals("component") || lowerCaseText.equals("case") || lowerCaseText.equals("if") || lowerCaseText.equals("loop") || lowerCaseText.equals("process") || lowerCaseText.equals("generate") || lowerCaseText.equals("architecture") || lowerCaseText.equals("package") || lowerCaseText.equals("record") || lowerCaseText.equals("type") || lowerCaseText.equals("protected") || lowerCaseText.equals("begin") || lowerCaseText.equals("block")) {
                            Keyword prevKeyword = this.getPreviousWord(this.fDocument, offset - text.length(), lowerCaseText.equals("if") || lowerCaseText.equals("component"), false);
                            String prevWord = prevKeyword.value;
                            if (prevWord == null || !prevWord.equalsIgnoreCase("end")) {
                                int openOffset = offset - text.length() + 1;
                                if (this.fDocument.getNumberOfLines() < this.fNofLines && this.fDocument.containsPositionCategory("__dvt_folding_position") && !this.fDocument.containsPosition("__dvt_folding_position", openOffset, 1)) {
                                    this.addPosition(this.fDocument, lowerCaseText, offset, openOffset);
                                }
                            }
                        } else if (lowerCaseText.equals("configuration")) {
                            Keyword keyword = this.getPreviousWord(this.fDocument, offset - text.length(), true, false);
                            String prevWord = keyword.value;
                            if (prevWord == null || !prevWord.equalsIgnoreCase("end") && !prevWord.equalsIgnoreCase("use") && lowerCaseText.equals("configuration")) {
                                int openOffset = offset - text.length() + 1;
                                if (this.fDocument.getNumberOfLines() < this.fNofLines && this.fDocument.containsPositionCategory("__dvt_folding_position") && !this.fDocument.containsPosition("__dvt_folding_position", openOffset, 1)) {
                                    this.addPosition(this.fDocument, lowerCaseText, offset, openOffset);
                                }
                            }
                        } else if (lowerCaseText.equals("protected")) {
                            Keyword keyword = this.getPreviousWord(this.fDocument, offset - text.length(), true, false);
                            String prevWord = keyword.value;
                            if (prevWord != null && prevWord.equalsIgnoreCase("is")) {
                                int openOffset = offset - text.length() + 1;
                                if (this.fDocument.getNumberOfLines() < this.fNofLines && this.fDocument.containsPositionCategory("__dvt_folding_position") && !this.fDocument.containsPosition("__dvt_folding_position", openOffset, 1)) {
                                    this.addPosition(this.fDocument, lowerCaseText, offset, openOffset);
                                }
                            }
                        } else if (lowerCaseText.equals("for")) {
                            Keyword nextKeyword = this.getNextWord(this.fDocument, offset, true);
                            String nextWord = nextKeyword.value;
                            int length = 0;
                            while (nextWord == null && (((VhdlCodeScanner)scanner).getOffset() <= nextKeyword.offset || Character.isWhitespace(ch))) {
                                ch = scanner.read();
                                ++length;
                            }
                            ((VhdlCodeScanner)scanner).unreadLength(length);
                            if (ch != 58 && (nextWord == null || !nextWord.equalsIgnoreCase("loop") && !nextWord.equalsIgnoreCase("generate"))) {
                                Keyword keyword = this.getPreviousWord(this.fDocument, offset - text.length(), false, false);
                                String prevWord = keyword.value;
                                if (prevWord == null || !prevWord.equalsIgnoreCase("end") && !prevWord.equalsIgnoreCase("wait")) {
                                    int openOffset = offset - text.length() + 1;
                                    if (this.fDocument.containsPositionCategory("__dvt_folding_position") && !this.fDocument.containsPosition("__dvt_folding_position", openOffset, 1)) {
                                        this.addPosition(this.fDocument, lowerCaseText, offset, openOffset);
                                    }
                                }
                            }
                        } else if (lowerCaseText.equals("end")) {
                            if (this.fDocument.containsPositionCategory("__dvt_folding_position")) {
                                String lowerCaseNextWord;
                                String nextWord = this.getNextWord((IDocument)this.fDocument, (int)offset, (boolean)false).value;
                                String string = lowerCaseNextWord = nextWord == null ? null : nextWord.toLowerCase();
                                if (lowerCaseNextWord != null && !fBlockDefiningKeywords.contains(lowerCaseNextWord)) {
                                    lowerCaseNextWord = this.fNameToKeyWordMap.get(lowerCaseNextWord);
                                }
                                if (!this.fDocument.containsPosition("__dvt_folding_position", offset, 1)) {
                                    this.fDocument.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(offset, 1, lowerCaseNextWord == null ? "end" : lowerCaseNextWord, DVTFoldingPosition.SubType.END));
                                }
                            }
                        } else if (lowerCaseText.equals("procedure") || lowerCaseText.equals("function")) {
                            int openOffset = offset - text.length() + 1;
                            if (!this.fDocument.containsPosition("__dvt_folding_position", openOffset, 1)) {
                                Keyword nextKeyword = this.getNextWord(this.fDocument, offset, true);
                                String nextWord = nextKeyword.value;
                                Keyword prevKeyword = this.getPreviousWord(this.fDocument, offset - text.length(), false, true);
                                String prevWord = prevKeyword.value;
                                if (nextWord != null && nextWord.equalsIgnoreCase("is") && (prevWord == null || !prevWord.equalsIgnoreCase("of")) && this.fDocument.containsPositionCategory("__dvt_folding_position") && !this.fDocument.containsPosition("__dvt_folding_position", openOffset, 1)) {
                                    this.addPosition(this.fDocument, lowerCaseText, offset, openOffset);
                                }
                            }
                        } else if (lowerCaseText.equals("entity") || lowerCaseText.equals("component")) {
                            int prevCh = this.getPreviousChar(this.fDocument, startOffset);
                            Keyword keyword = this.getPreviousWord(this.fDocument, offset - text.length(), false, false);
                            String prevWord = keyword.value;
                            int openOffset = offset - text.length() + 1;
                            if (!(prevWord != null && prevWord.equals("use") || prevCh == 58 || this.fDocument.containsPosition("__dvt_folding_position", openOffset, 1) || !this.fDocument.containsPositionCategory("__dvt_folding_position") || this.fDocument.containsPosition("__dvt_folding_position", openOffset, 1))) {
                                this.addPosition(this.fDocument, lowerCaseText, offset, openOffset);
                            }
                        } else if (lowerCaseText.equals("when") && this.fDocument.containsPositionCategory("__dvt_folding_position")) {
                            int openOffset = offset - text.length() + 1;
                            if (!this.fDocument.containsPosition("__dvt_folding_position", offset, 1)) {
                                this.addPosition(this.fDocument, lowerCaseText, offset, openOffset);
                            }
                        }
                    }
                    return this.fDefaultKeywordToken;
                }
                int offset = ((VhdlCodeScanner)scanner).getOffset() - 1;
                int openOffset = offset - text.length() + 1;
                boolean isSemanticHighlightEnabled = this.fStyle.isSemanticHighlightEnabled();
                if (isSemanticHighlightEnabled && (highlightPosition = (SemanticHighlightPosition)this.getPosition(openOffset)) != null) {
                    HighlightKind highlighKind = highlightPosition.getHighlightKind();
                    if (highlighKind == HighlightKind.METHOD) {
                        return this.fDefaultMethodToken;
                    }
                    if (highlighKind == HighlightKind.PORT) {
                        return this.fDefaultPortToken;
                    }
                    if (highlighKind == HighlightKind.OUT_PORT) {
                        return this.fDefaultOutPortToken;
                    }
                    if (highlighKind == HighlightKind.TYPE) {
                        return this.fDefaultTypeToken;
                    }
                    if (highlighKind == HighlightKind.VARIABLE) {
                        return this.fDefaultVariableToken;
                    }
                    if (highlighKind == HighlightKind.CONSTANT) {
                        return this.fDefaultConstantToken;
                    }
                    if (highlighKind == HighlightKind.VHDL_ENUM_ITEMS) {
                        return this.fDefaultEnumItemsToken;
                    }
                    if (highlighKind == HighlightKind.SIGNAL) {
                        return this.fDefaultSignalToken;
                    }
                    if (highlighKind == HighlightKind.ATTRIBUTE) {
                        return this.fDefaultAttributeToken;
                    }
                    if (highlighKind == HighlightKind.LABEL) {
                        return this.fDefaultLabelToken;
                    }
                    if (highlighKind == HighlightKind.RECORD_ELEMENT) {
                        return this.fDefaultRecordElementToken;
                    }
                    if (highlighKind == HighlightKind.ARGUMENT) {
                        return this.fDefaultArgumentToken;
                    }
                    if (highlighKind == HighlightKind.DEFAULT) {
                        return this.fDefaultWordToken;
                    }
                    return Token.UNDEFINED;
                }
                if (this.fTypes.contains(lowerCaseText)) {
                    return this.fDefaultTypeToken;
                }
                if (ch == 39) {
                    ch = scanner.read();
                    ch = scanner.read();
                    scanner.unread();
                    scanner.unread();
                    if (ch == 40) {
                        return this.fDefaultTypeToken;
                    }
                } else {
                    if (this.getPreviousChar(this.fDocument, startOffset) == 58) {
                        if (ch == 59 || ch == 58 || ch == 40) {
                            return this.fDefaultTypeToken;
                        }
                        int length = 0;
                        while (Character.isWhitespace(ch)) {
                            ch = scanner.read();
                            ++length;
                        }
                        ((VhdlCodeScanner)scanner).unreadLength(length);
                        if (ch == 59 || ch == 58 || ch == 41 || ch == 40) {
                            return this.fDefaultTypeToken;
                        }
                        return Token.UNDEFINED;
                    }
                    Keyword prevWord = this.getPreviousWord(this.fDocument, startOffset, false, false);
                    if (prevWord.value != null && (prevWord.value.equals("return") || prevWord.value.equals("access") || prevWord.value.equals("in") || prevWord.value.equals("out") || prevWord.value.equals("inout"))) {
                        if (ch == 43 || ch == 42 || ch == 45 || ch == 47 || ch == 60 || ch == 62 || ch == 61) {
                            return Token.UNDEFINED;
                        }
                        while (Character.isWhitespace(ch = scanner.read())) {
                        }
                        scanner.unread();
                        if (ch != 39) {
                            return this.fDefaultTypeToken;
                        }
                        return this.fDefaultWordToken;
                    }
                    if (isSemanticHighlightEnabled) {
                        int nextChar = this.getNextChar(this.fDocument, offset);
                        if (nextChar == 58) {
                            Keyword nextWord = this.getNextWord(this.fDocument, offset, false);
                            if ((fLabeledBlocks.contains(nextWord.value) || nextWord.value.equals("if") || nextWord.value.equals("for")) && nextChar == 58) {
                                return this.fDefaultLabelToken;
                            }
                        } else {
                            if (prevWord.value != null && prevWord.value.equals("end")) {
                                return this.fDefaultEndLabelToken;
                            }
                            if (this.fWords.contains(prevWord.value)) {
                                Keyword secondPrevWord = this.getPreviousWord(this.fDocument, prevWord.offset, false, false);
                                if (secondPrevWord.value != null && secondPrevWord.value.equals("end")) {
                                    return this.fDefaultEndLabelToken;
                                }
                            }
                        }
                    }
                }
                return this.fDefaultWordToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
        catch (Exception exception) {
            return Token.UNDEFINED;
        }
    }

    private void addPosition(IDocument document, String lowerCaseText, int offset, int openOffset) throws BadLocationException, BadPositionCategoryException {
        if (fMayTerminateWithEndName.contains(lowerCaseText)) {
            String word = null;
            if (!fLabeledBlocks.contains(lowerCaseText)) {
                word = this.getNextWord((IDocument)document, (int)offset, (boolean)false).value;
            }
            if (word != null) {
                word = word.toLowerCase();
                this.fNameToKeyWordMap.put(word, lowerCaseText);
            }
        }
        document.addPosition("__dvt_folding_position", (Position)new DVTFoldingPosition(openOffset, 1, lowerCaseText, DVTFoldingPosition.SubType.START));
    }

    private Keyword getPreviousWord(IDocument document, int offset, boolean checkColon, boolean checkType) {
        try {
            DVTCharacterScanner tempScanner = new DVTCharacterScanner(20, document, offset, false);
            int ch = 48;
            int keywordOffset = -1;
            ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__vhdl_partitioning", tempScanner.getOffset(), false);
            DVTStringBuilder result = new DVTStringBuilder();
            while (ch != -1 && tempScanner.getOffset() >= partition.getOffset()) {
                if (tempScanner.getOffset() <= 0) {
                    return new Keyword(0, result.toString());
                }
                keywordOffset = tempScanner.getOffset();
                ch = tempScanner.read();
                if (Character.isWhitespace(ch) && result.length() == 0) continue;
                if (checkColon && ch == 58 && result.length() == 0) {
                    return new Keyword(keywordOffset, "end");
                }
                if (checkType && ch == 58 && result.length() == 0) {
                    return new Keyword(keywordOffset, "of");
                }
                if (Character.isJavaIdentifierPart(ch)) {
                    result.prepend((char)ch);
                    continue;
                }
                if (result.length() == 0 && !Character.isJavaIdentifierPart(ch) && !Character.isWhitespace(ch)) {
                    return new Keyword(keywordOffset, null);
                }
                String word = result.toString().toLowerCase();
                boolean isKeyword = this.fWords.contains(word);
                if (isKeyword) break;
                result.clear();
            }
            if (result.length() == 0 && tempScanner.getOffset() < partition.getOffset()) {
                int startOffset = tempScanner.getOffset() - 1;
                while (startOffset > 0) {
                    partition = ((IDocumentExtension3)document).getPartition("__vhdl_partitioning", startOffset, false);
                    if ("__dftl_partition_content_type".equals(partition.getType())) break;
                    startOffset = partition.getOffset() - 1;
                }
                if (startOffset == offset) {
                    return new Keyword(-1, null);
                }
                return this.getPreviousWord(document, startOffset, checkColon, checkType);
            }
            return new Keyword(keywordOffset, result.toString().toLowerCase());
        }
        catch (Exception exception) {
            return new Keyword(-1, null);
        }
    }

    private int getPreviousChar(IDocument document, int offset) {
        block5: {
            int startOffset;
            block6: {
                try {
                    DVTCharacterScanner tempScanner = new DVTCharacterScanner(20, document, offset, false);
                    ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__vhdl_partitioning", tempScanner.getOffset(), false);
                    int ch = 48;
                    while (ch != -1 && tempScanner.getOffset() >= partition.getOffset()) {
                        ch = tempScanner.read();
                        if (Character.isWhitespace((char)ch)) continue;
                        return ch;
                    }
                    if (tempScanner.getOffset() >= partition.getOffset()) break block5;
                    startOffset = tempScanner.getOffset() - 1;
                    while (startOffset > 0) {
                        partition = ((IDocumentExtension3)document).getPartition("__vhdl_partitioning", startOffset, false);
                        if ("__dftl_partition_content_type".equals(partition.getType())) break;
                        startOffset = partition.getOffset() - 1;
                    }
                    if (startOffset != offset) break block6;
                    return 48;
                }
                catch (Exception exception) {
                    return 48;
                }
            }
            return this.getPreviousChar(document, startOffset);
        }
        return 48;
    }

    private Keyword getNextWord(IDocument document, int offset, boolean keyword) {
        try {
            DVTCharacterScanner tempScanner = new DVTCharacterScanner(20, document, offset + 1, true);
            int ch = -2;
            int nested = 0;
            int keywordOffset = -1;
            StringBuilder result = new StringBuilder();
            ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__vhdl_partitioning", tempScanner.getOffset(), false);
            while (ch != -1 && tempScanner.getOffset() < partition.getLength() + partition.getOffset()) {
                if (tempScanner.getOffset() <= 0) {
                    return new Keyword(0, result.toString());
                }
                keywordOffset = tempScanner.getOffset();
                ch = tempScanner.read();
                if ((Character.isWhitespace(ch) || ch == 45 || ch == 43 || ch == 58) && result.length() == 0) continue;
                if (!keyword && result.length() != 0 && !Character.isJavaIdentifierPart(ch)) {
                    return new Keyword(keywordOffset, result.toString());
                }
                if (ch == 41) {
                    result.delete(0, result.length());
                    ++nested;
                    continue;
                }
                if (ch == 40) {
                    result.delete(0, result.length());
                    --nested;
                    continue;
                }
                if (nested != 0) {
                    result.delete(0, result.length());
                    continue;
                }
                if (Character.isJavaIdentifierPart(ch)) {
                    result.append((char)ch);
                    continue;
                }
                if (result.length() == 0 && !Character.isJavaIdentifierPart(ch) && !Character.isWhitespace(ch)) {
                    return new Keyword(keywordOffset, null);
                }
                if (result.length() != 0 && ch == 39) {
                    result.delete(0, result.length());
                    continue;
                }
                String word = result.toString().toLowerCase();
                boolean isKeyword = this.fWords.contains(word);
                if (!keyword || isKeyword && !word.equals("return") && !word.equals("in") && !word.equals("range") && !word.equals("to") && !word.equals("downto")) break;
                result.delete(0, result.length());
            }
            if (ch != -2 && ch != -1 && result.length() == 0 && tempScanner.getOffset() >= partition.getLength() + partition.getOffset()) {
                int startOffset = tempScanner.getOffset();
                while (document.getLength() > startOffset) {
                    partition = ((IDocumentExtension3)document).getPartition("__vhdl_partitioning", startOffset, false);
                    if ("__dftl_partition_content_type".equals(partition.getType())) break;
                    startOffset = partition.getLength() + partition.getOffset();
                }
                return this.getNextWord(document, startOffset, keyword);
            }
            return new Keyword(keywordOffset, result.toString());
        }
        catch (Exception exception) {
            return new Keyword(-1, null);
        }
    }

    private int getNextChar(IDocument document, int offset) {
        try {
            DVTCharacterScanner tempScanner = new DVTCharacterScanner(20, document, offset + 1, true);
            ITypedRegion partition = ((IDocumentExtension3)document).getPartition("__vhdl_partitioning", tempScanner.getOffset(), false);
            int ch = 48;
            while (ch != -1 && tempScanner.getOffset() < partition.getLength() + partition.getOffset()) {
                ch = tempScanner.read();
                if (Character.isWhitespace((char)ch)) continue;
                return ch;
            }
            if (tempScanner.getOffset() >= partition.getLength() + partition.getOffset()) {
                int startOffset = tempScanner.getOffset();
                while (document.getLength() > startOffset) {
                    partition = ((IDocumentExtension3)document).getPartition("__vhdl_partitioning", startOffset, false);
                    if ("__dftl_partition_content_type".equals(partition.getType())) break;
                    startOffset = partition.getLength() + partition.getOffset();
                }
                return this.getNextChar(document, startOffset);
            }
            return 48;
        }
        catch (Exception exception) {
            return 48;
        }
    }

    public void setNofLinesFolding(int nofLines) {
        this.fNofLines = nofLines;
    }

    public void updateSHPositions(IDocument document, IRfFileDef file) {
        try {
            if (this.fDocument == null || !this.fDocument.equals(document)) {
                return;
            }
            if (!this.fDocument.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                return;
            }
            this.fSHPositions = this.fDocument.getPositions("SEMANTIC_HIGHLIGHT");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateKeywords() {
        String[] keywords = PrefConst.getVHDLLowercaseKeywords();
        this.fWords.clear();
        int i = 0;
        while (i < keywords.length) {
            this.fWords.add(keywords[i]);
            ++i;
        }
    }

    private Position getPosition(int offset) {
        if (this.fSHPositions == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.fSHPositions, new DVTPosition(offset), POSITION_COMPARATOR);
        if (index >= 0) {
            return this.fSHPositions[index];
        }
        return null;
    }

    static class Keyword {
        int offset;
        String value;

        public Keyword(int offset, String value) {
            this.offset = offset;
            this.value = value;
        }
    }
}

