/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class VhdlPreprocessRule
implements IRule {
    private IToken fDefaultTokenPreproc;

    public VhdlPreprocessRule(IToken tokenPreproc) {
        Assert.isNotNull((Object)tokenPreproc);
        this.fDefaultTokenPreproc = tokenPreproc;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        try {
            int c = scanner.read();
            if ((char)c == '`') {
                StringBuilder buffer = new StringBuilder();
                do {
                    buffer.append((char)c);
                    c = scanner.read();
                    while (c != -1 && buffer.length() == 1 && Character.isWhitespace(c)) {
                        c = scanner.read();
                    }
                } while (c != -1 && Character.isJavaIdentifierPart((char)c));
                scanner.unread();
                return this.fDefaultTokenPreproc;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
        catch (Exception exception) {
            return Token.UNDEFINED;
        }
    }
}

