/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.namechecker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.problems.VhdlProblemKinds;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.namechecker.Collision;
import ro.amiq.dvt.ui.namechecker.Convention;
import ro.amiq.dvt.ui.namechecker.ConventionStoreUtil;
import ro.amiq.dvt.ui.namechecker.Identifier;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class NameCheckerWarningsManagerCommon {
    private static final String POSITIVE = "positive";
    private static final String ANY = "ANY";
    private List<Collision> fConventionNames = new ArrayList<Collision>();
    private List<Convention> fConventions;
    private List<Collision> fReservedNames = new ArrayList<Collision>();
    private Set<String> fKeywords;

    protected NameCheckerWarningsManagerCommon() {
    }

    private String extractMessage(Collision c) {
        int kind = c.getKind();
        String result = DVTStringUtil.appendString((Object[])new Object[]{"The '", c.getName(), "' ", c.getElement().toLowerCase().replace('_', ' '), " name"});
        if (kind == 0) {
            return DVTStringUtil.appendString((Object[])new Object[]{"IEEE1076-2008 KEYWORD: ", result, " is reserved by the standard as keyword."});
        }
        return DVTStringUtil.appendString((Object[])new Object[]{c.getNamingConvention().toUpperCase(), ": ", result, " does not satisfy the naming convention."});
    }

    private void recursiveParseChildren(Set<RfDefElement> visited, RfDefElement element, RfFileDef file, Set<String> keywords, List<Convention> conventions) {
        Collection<RfDefElement> children;
        String type;
        if (element == null) {
            return;
        }
        if (visited.contains(element)) {
            return;
        }
        visited.add(element);
        RfNamedElement namedElement = element.getNamedElement();
        if (namedElement != null && !namedElement.isAnonymous() && (type = this.getType(namedElement)) != null) {
            String name = element.getName();
            if (keywords.contains(name.toLowerCase())) {
                Collision newID = new Collision(0, name, new Identifier(name, type, file.getName(), element.getStartLine(), element.getStartOffset()), null);
                this.fReservedNames.add(newID);
            }
            int nofConventions = conventions.size();
            int j = 0;
            while (j < nofConventions) {
                Matcher m;
                Convention rule = conventions.get(j);
                if (rule.getLanguage().equals("VHDL") && !rule.isOverriden() && rule.getEnabled() && (rule.getKind().equals(type) || rule.getKind().equals(ANY)) && (!(m = rule.getPattern().matcher(name)).matches() && rule.getMatch().equalsIgnoreCase(POSITIVE) || m.matches() && !rule.getMatch().equalsIgnoreCase(POSITIVE))) {
                    Collision newID = new Collision(1, name, new Identifier(name, type, file.getName(), element.getStartLine(), element.getStartOffset()), rule);
                    this.fConventionNames.add(newID);
                }
                ++j;
            }
        }
        if ((children = element.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (RfDefElement child : children) {
            this.recursiveParseChildren(visited, child, file, keywords, conventions);
        }
    }

    public void build(int buildKind, RfFileDef file, IProject project) {
        DVTProblem problem;
        if (file == null || project == null) {
            return;
        }
        if (BuildConfigManager.isNamingConventionChecksDisabled((IProject)project)) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
            return;
        }
        if (this.fKeywords == null) {
            this.fKeywords = new HashSet<String>(Arrays.asList(PrefConst.getNamecheckKeywords()));
        }
        if (this.fConventions == null) {
            this.fConventions = new ArrayList<Convention>();
            try {
                ConventionStoreUtil.load(this.fConventions, (IProject)project);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        this.recursiveParseChildren(new HashSet<RfDefElement>(), file, file, this.fKeywords, this.fConventions);
        ParserPath parserPath = file.getParserPath();
        DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(project, VhdlProblemCategories.VHDL_NAME_CHECKING, parserPath.path);
        for (Collision c : this.fConventionNames) {
            problem = new DVTProblem(project, VhdlProblemKinds.VHDL_NAMING_CONVENTION, parserPath.path, buildKind == 1, c.getLineNumber(), new String[]{this.extractMessage(c)});
            problem.setAttribute("charStart", (Object)c.getStartOffset());
            problem.setAttribute("charEnd", (Object)c.getEndOffset());
            DVTProblemManager.getInstance().reportProblem(problem);
        }
        for (Collision c : this.fReservedNames) {
            problem = new DVTProblem(project, VhdlProblemKinds.VHDL_RESERVED_ID, parserPath.path, false, c.getLineNumber(), new String[]{this.extractMessage(c)});
            problem.setAttribute("charStart", (Object)c.getStartOffset());
            problem.setAttribute("charEnd", (Object)c.getEndOffset());
            DVTProblemManager.getInstance().reportProblem(problem);
        }
        IResource resource = file.getFileAdapter();
        if (resource instanceof IFile && buildKind == 0) {
            DVTProblemsUiUpdaterRegistry.get((String)VhdlProblemCategories.VHDL_NAME_CHECKING.getId()).update((IFile)resource, buildKind == 1);
        }
        this.fConventionNames.clear();
        this.fReservedNames.clear();
    }

    private String getType(IRfNamedElement element) {
        if (element == null) {
            return null;
        }
        if (element.getName().startsWith("\"") && element.getName().endsWith("\"")) {
            return null;
        }
        if (element instanceof RfEnum) {
            return "CONSTANT";
        }
        if (element instanceof RfPort) {
            if (((RfPort)element).isInput()) {
                return "PORT_INPUT";
            }
            if (((RfPort)element).isOutput()) {
                return "PORT_OUTPUT";
            }
            return "PORT_INOUT";
        }
        if (element instanceof RfVariable) {
            RfVariable variable = (RfVariable)element;
            if (variable.isParameter()) {
                return "GENERIC";
            }
            if (variable.isConstant() && !variable.isArgument()) {
                return "CONSTANT";
            }
            if (variable.isSignal()) {
                return "SIGNAL";
            }
            if (variable.isArgument()) {
                return "ARGUMENT";
            }
            if (variable.isVariable() || variable.isSharedVariable()) {
                return "VARIABLE";
            }
            if (variable instanceof RfAlias) {
                return this.getType(((RfAlias)element).getTranslatedType());
            }
        } else {
            if (element instanceof RfFunctionsHolder) {
                RfFunctionsHolder functionsHolder = (RfFunctionsHolder)element;
                RfFunction function = functionsHolder.getLastDefinedFunction();
                if (function.isTask()) {
                    return "PROCEDURE";
                }
                return "FUNCTION";
            }
            if (element instanceof RfFunction) {
                RfFunction function = (RfFunction)element;
                if (function.isTask()) {
                    return "PROCEDURE";
                }
                return "FUNCTION";
            }
            if (element instanceof RfArchitecture) {
                return "ARCHITECTURE";
            }
            if (element instanceof RfProcess) {
                return "PROCESS";
            }
            if (element instanceof RfEntity) {
                return "ENTITY";
            }
            if (element instanceof RfPackage) {
                return "PACKAGE";
            }
            if (element instanceof RfComponent) {
                return "COMPONENT";
            }
            if (element instanceof RfType) {
                return "TYPE";
            }
        }
        return null;
    }

    public void clean() {
        this.fKeywords = null;
        this.fConventions = null;
    }
}

