/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.IntegerFieldEditor;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class EditorPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final int MAX_NUMBER_OF_CHARACTERS = 8;
    BooleanFieldEditor fUseTabCharacters = null;
    BooleanFieldEditor fUseUpperCase = null;
    private Group fGeneralVhdlLanguageEditor;
    private Group fCodeHighlighting;
    private Group fCodeFolding;
    private Group fCompareViewer;
    private BooleanFieldEditor fMatchingBracketsEnableButton;
    private ColorFieldEditor fMatchingBracketsColorButton;
    private IntegerFieldEditor fCodeFoldingNofLinesField;
    private IntegerFieldEditor fCompareViewerMaxLinesField;
    private Button fActivateCodeFolding = null;
    private Button fActivateManualCodeFolding = null;

    public EditorPage() {
        super(1);
        this.setPreferenceStore(VhdlPlugin.getDefault().getPreferenceStore());
        this.setDescription("General Settings for VHDL Language Editor");
    }

    public void init(IWorkbench _workbench) {
    }

    protected void createFieldEditors() {
        this.createHeader(this.getFieldEditorParent());
        BooleanFieldEditor button = new BooleanFieldEditor("editor.disable_tool_tips", "Disable tool-tips", (Composite)this.fGeneralVhdlLanguageEditor);
        this.addField((FieldEditor)button);
        button = new BooleanFieldEditor("autoindent.disabled", "Disable auto-indentation", (Composite)this.fGeneralVhdlLanguageEditor);
        this.addField((FieldEditor)button);
        button = new BooleanFieldEditor("inactiveCodeHighlightEnable", "Translate pragma regions", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)button);
        Label borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        ColorFieldEditor cfeInactive = new ColorFieldEditor("inactiveCodeHighlightColor", "", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)cfeInactive);
        button = new BooleanFieldEditor("inactiveGenerateBranchHighlightEnable", "Inactive generate branches", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)button);
        borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        ColorFieldEditor cfeInactiveGenerateBranches = new ColorFieldEditor("inactiveGenerateBranchHighlightColor", "", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)cfeInactiveGenerateBranches);
        this.fMatchingBracketsEnableButton = new BooleanFieldEditor("matchingBracketsVhdlEnable", "Matching brackets", (Composite)this.fCodeHighlighting);
        this.addField((FieldEditor)this.fMatchingBracketsEnableButton);
        borderLabel = new Label((Composite)this.fCodeHighlighting, 0);
        borderLabel.setText("");
        this.fMatchingBracketsColorButton = new ColorFieldEditor("matchingBracketsVhdlColor", "", (Composite)this.fCodeHighlighting);
        this.fMatchingBracketsColorButton.setPreferenceStore(EditorsUI.getPreferenceStore());
        this.addField((FieldEditor)this.fMatchingBracketsColorButton);
        this.fActivateCodeFolding = new Button((Composite)this.fCodeFolding, 32);
        this.fActivateCodeFolding.setFont(this.fCodeFolding.getFont());
        this.fActivateCodeFolding.setText("Enable code folding");
        GridData caEnableButtonGridData = new GridData(1, 0x1000000, false, false);
        this.fActivateCodeFolding.setLayoutData((Object)caEnableButtonGridData);
        this.fActivateCodeFolding.setSelection(PrefConst.isCodeFoldingEnabled());
        this.fActivateCodeFolding.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = EditorPage.this.fActivateCodeFolding.getSelection();
                VhdlPlugin.getDefault().getPreferenceStore().setValue("editor.codeFolding", value);
                EditorPage.this.fCodeFoldingNofLinesField.setEnabled(value, (Composite)EditorPage.this.fCodeFolding);
                EditorPage.this.fActivateManualCodeFolding.setEnabled(value);
                if (value && System.getProperty("ro.amiq.dvt.ui.editor.disableFolding") != null) {
                    EditorPage.this.setErrorMessage("The \"ro.amiq.dvt.ui.editor.disableFolding\" preference is set in the eclipse.ini. It overrides the \"Enable code folding\" preference set here.");
                } else {
                    EditorPage.this.setErrorMessage(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Label label = new Label((Composite)this.fCodeFolding, 0);
        label.setText("");
        this.fActivateManualCodeFolding = new Button((Composite)this.fCodeFolding, 32);
        this.fActivateManualCodeFolding.setFont(this.fCodeFolding.getFont());
        this.fActivateManualCodeFolding.setText("Enable manual code folding using -- {{{, -- }}} or -- #region, -- #endregion pragmas");
        this.fActivateManualCodeFolding.setLayoutData((Object)caEnableButtonGridData);
        this.fActivateManualCodeFolding.setSelection(PrefConst.isManualCodeFoldingEnabled());
        this.fActivateManualCodeFolding.setEnabled(this.fActivateCodeFolding.getSelection());
        this.fActivateManualCodeFolding.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VhdlPlugin.getDefault().getPreferenceStore().setValue("editor.manualCodeFolding", EditorPage.this.fActivateManualCodeFolding.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        label = new Label((Composite)this.fCodeFolding, 0);
        label.setText("");
        Composite codeFoldingNofLinesContainer = new Composite((Composite)this.fCodeFolding, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)codeFoldingNofLinesContainer);
        this.fCodeFoldingNofLinesField = new IntegerFieldEditor("editor.numberOfLines", "Maximum number of lines in file", 8, codeFoldingNofLinesContainer);
        this.fCodeFoldingNofLinesField.setEmptyStringAllowed(false);
        this.fCodeFoldingNofLinesField.setTextLimit(8);
        this.fCodeFoldingNofLinesField.setEnabled(this.fActivateCodeFolding.getSelection(), codeFoldingNofLinesContainer);
        this.addField((FieldEditor)this.fCodeFoldingNofLinesField);
        Composite compareViewerContainer = new Composite((Composite)this.fCompareViewer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)compareViewerContainer);
        this.fCompareViewerMaxLinesField = new IntegerFieldEditor("disable.compareviewer", "Disable compare viewer lines threshold", 8, compareViewerContainer);
        this.fCompareViewerMaxLinesField.setEmptyStringAllowed(false);
        this.fCompareViewerMaxLinesField.setTextLimit(8);
        this.addField((FieldEditor)this.fCompareViewerMaxLinesField);
        this.updateLayout();
    }

    private void createHeader(Composite contents) {
        this.initializeDialogUnits((Control)contents);
        Label label = new Label(contents, 0);
        label.setText("");
        this.fGeneralVhdlLanguageEditor = new Group(contents, 16);
        GridLayout layout = new GridLayout(2, false);
        GridData data = new GridData(4, 4, true, false);
        this.fGeneralVhdlLanguageEditor.setLayout((Layout)layout);
        this.fGeneralVhdlLanguageEditor.setLayoutData((Object)data);
        this.fGeneralVhdlLanguageEditor.setText("Editing");
        final Link link = new Link((Composite)this.fGeneralVhdlLanguageEditor, 64);
        link.setText("Default colors and font can be configured on the <a href=\"org.eclipse.ui.preferencePages.GeneralTextEditor\">Text Editors</a> and on the <a href=\"org.eclipse.ui.preferencePages.ColorsAndFonts\">Colors and Fonts</a> preference pages.");
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, null);
            }
        });
        String linktooltip = "Go To Target Preference Page";
        link.setToolTipText(linktooltip);
        data = new GridData(4, 0, true, false);
        data.widthHint = 275;
        data.horizontalSpan = 2;
        link.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)this.fGeneralVhdlLanguageEditor);
        label = new Label(contents, 0);
        label.setText("");
        this.fCodeHighlighting = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        this.fCodeHighlighting.setLayout((Layout)layout);
        this.fCodeHighlighting.setLayoutData((Object)data);
        this.fCodeHighlighting.setText("Code highlighting color");
        Dialog.applyDialogFont((Control)this.fCodeHighlighting);
        label = new Label(contents, 0);
        label.setText("");
        this.fCodeFolding = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        data.widthHint = 275;
        data.horizontalSpan = 1;
        this.fCodeFolding.setLayout((Layout)layout);
        this.fCodeFolding.setLayoutData((Object)data);
        this.fCodeFolding.setText("Code folding");
        Dialog.applyDialogFont((Control)this.fCodeFolding);
        label = new Label(contents, 0);
        label.setText("");
        this.fCompareViewer = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        this.fCompareViewer.setLayout((Layout)layout);
        this.fCompareViewer.setLayoutData((Object)data);
        this.fCompareViewer.setText("Compare Viewer");
    }

    private void updateLayout() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        this.fGeneralVhdlLanguageEditor.setLayout((Layout)layout);
        this.fCodeFolding.setLayout((Layout)layout);
        this.fCompareViewer.setLayout((Layout)layout);
        GridLayout colorFieldLayout = new GridLayout();
        colorFieldLayout.numColumns = 5;
        colorFieldLayout.marginWidth = 5;
        colorFieldLayout.marginHeight = 5;
        colorFieldLayout.horizontalSpacing = 5;
        colorFieldLayout.verticalSpacing = 5;
        this.fCodeHighlighting.setLayout((Layout)colorFieldLayout);
        this.getFieldEditorParent().layout(true);
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public void dispose() {
        if (this.fMatchingBracketsEnableButton != null) {
            this.fMatchingBracketsEnableButton.dispose();
        }
        if (this.fMatchingBracketsColorButton != null) {
            this.fMatchingBracketsColorButton.dispose();
        }
        if (this.fActivateCodeFolding != null) {
            this.fActivateCodeFolding.dispose();
        }
        if (this.fActivateManualCodeFolding != null) {
            this.fActivateManualCodeFolding.dispose();
        }
        if (this.fCodeFoldingNofLinesField != null) {
            this.fCodeFoldingNofLinesField.dispose();
        }
        if (this.fCompareViewerMaxLinesField != null) {
            this.fCompareViewerMaxLinesField.dispose();
        }
        this.fMatchingBracketsEnableButton = null;
        this.fMatchingBracketsColorButton = null;
        this.fActivateCodeFolding = null;
        this.fActivateManualCodeFolding = null;
        this.fCodeFoldingNofLinesField = null;
        this.fCompareViewerMaxLinesField = null;
        super.dispose();
    }

    protected void initialize() {
        super.initialize();
        this.fMatchingBracketsEnableButton.setPreferenceStore(EditorsUI.getPreferenceStore());
        this.fMatchingBracketsEnableButton.load();
        this.fMatchingBracketsColorButton.setPreferenceStore(EditorsUI.getPreferenceStore());
        this.fMatchingBracketsColorButton.load();
    }
}

