/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.TaskTagDictionary;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellDictionary;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = VhdlPlugin.getDefault().getPreferenceStore();
        this.initializeMarkOccurences(store);
        this.initializeSyntaxPreferences(store);
        this.initializeOutlinePreferences(store);
        this.initializeContentAssistPreferences(store);
        this.initializeTypingPreferences(store);
        this.initializeAutoindentPreferences(store);
        this.initializeLanguageElements();
        this.initializeEditorPreferences(store);
    }

    private void initializeMarkOccurences(IPreferenceStore store) {
        store.setDefault("markOccurrences", true);
    }

    void initializeSyntaxPreferences(IPreferenceStore store) {
        store.setDefault("highlight.semantic.value", true);
        store.setDefault("highlight.x_template_id.value", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.default.color", (RGB)PrefConst.DEFAULT_COLOR);
        store.setDefault("highlight.default.bold", false);
        store.setDefault("highlight.default.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment.color", (RGB)PrefConst.COMMENT_COLOR);
        store.setDefault("highlight.comment.bold", false);
        store.setDefault("highlight.comment.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_task.color", (RGB)PrefConst.COMMENT_TASK_COLOR);
        store.setDefault("highlight.comment_task.bold", true);
        store.setDefault("highlight.comment_task.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_pragma.color", (RGB)PrefConst.COMMENT_PRAGMA_COLOR);
        store.setDefault("highlight.comment_pragma.bold", true);
        store.setDefault("highlight.comment_pragma.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.javadoc_tags.color", (RGB)PrefConst.JAVADOC_TAGS_COLOR);
        store.setDefault("highlight.javadoc_tags.bold", true);
        store.setDefault("highlight.javadoc_tags.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.keyword.color", (RGB)PrefConst.KEYWORD_COLOR);
        store.setDefault("highlight.keyword.bold", true);
        store.setDefault("highlight.keyword.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.template_id.color", (RGB)PrefConst.PREFIX_COLOR);
        store.setDefault("highlight.template_id.bold", false);
        store.setDefault("highlight.template_id.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.attributes.color", (RGB)PrefConst.ATTRIBUTES_COLOR);
        store.setDefault("highlight.attributes.bold", false);
        store.setDefault("highlight.attributes.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.types.color", (RGB)PrefConst.TYPES_COLOR);
        store.setDefault("highlight.types.bold", true);
        store.setDefault("highlight.types.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.number.color", (RGB)PrefConst.NUMBER_COLOR);
        store.setDefault("highlight.number.bold", false);
        store.setDefault("highlight.number.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.string.color", (RGB)PrefConst.STRING_COLOR);
        store.setDefault("highlight.string.bold", false);
        store.setDefault("highlight.string.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.preproc.color", (RGB)PrefConst.PREPROC_COLOR);
        store.setDefault("highlight.preproc.bold", true);
        store.setDefault("highlight.preproc.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.comment_hyperlink.color", (RGB)PrefConst.COMMENT_HYPERLINK_COLOR);
        store.setDefault("highlight.comment_hyperlink.bold", false);
        store.setDefault("highlight.comment_hyperlink.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_method.color", (RGB)PrefConst.SEMANTIC_METHOD_COLOR);
        store.setDefault("highlight.semantic_method.bold", false);
        store.setDefault("highlight.semantic_method.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_variable.color", (RGB)PrefConst.SEMANTIC_VARIABLE_COLOR);
        store.setDefault("highlight.semantic_variable.bold", false);
        store.setDefault("highlight.semantic_variable.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_port.color", (RGB)PrefConst.SEMANTIC_PORT_COLOR);
        store.setDefault("highlight.semantic_port.bold", false);
        store.setDefault("highlight.semantic_port.italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_out_port.color", (RGB)PrefConst.SEMANTIC_OUT_PORT_COLOR);
        store.setDefault("highlight.semantic_out_port.bold", false);
        store.setDefault("highlight.semantic_out_port.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_enum_item.color", (RGB)PrefConst.SEMANTIC_ENUM_ITEM_COLOR);
        store.setDefault("highlight.semantic_enum_item.bold", true);
        store.setDefault("highlight.semantic_enum_item.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_constant.color", (RGB)PrefConst.SEMANTIC_CONSTANT_COLOR);
        store.setDefault("highlight.semantic_constant.bold", true);
        store.setDefault("highlight.semantic_constant.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_signal.color", (RGB)PrefConst.SEMANTIC_SIGNAL_COLOR);
        store.setDefault("highlight.semantic_signal.bold", false);
        store.setDefault("highlight.semantic_signal.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_record_element.color", (RGB)PrefConst.SEMANTIC_RECORD_ELEMENT_COLOR);
        store.setDefault("highlight.semantic_record_element.bold", false);
        store.setDefault("highlight.semantic_record_element.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.semantic_argument.color", (RGB)PrefConst.SEMANTIC_ARGUMENT_COLOR);
        store.setDefault("highlight.semantic_argument.bold", false);
        store.setDefault("highlight.semantic_argument.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.label.color", (RGB)PrefConst.LABEL_COLOR);
        store.setDefault("highlight.label.bold", true);
        store.setDefault("highlight.label.italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"highlight.end_label.color", (RGB)PrefConst.END_LABEL_COLOR);
        store.setDefault("highlight.end_label.bold", false);
        store.setDefault("highlight.end_label.italic", true);
    }

    void initializeLanguageElements() {
        IPreferenceStore store = VhdlPlugin.getDefault().getPreferenceStore();
        store.setDefault("vhdl.language.attributes", "'across;'above;'active;'ascending;'base;'behavior;'contribution;'delayed;'dot;'driving;'driving_value;'element;'event;'foreign;'high;'image;'instance_name;'integ;'last_active;'last_event;'ltf;'last_value;'left;'leftof;'length;'low;'path_name;'pos;'pred;'quiet;'ramp;'range;'reference;'reverse_range;'right;'rightof;'simple_name;'slew;'stable;'subtype;'succ;'tolerance;'transaction;'through;'val;'value;'values;'zoh;'ztf;");
        store.setDefault("vhdl.language.keywords", "abs;access;across;after;alias;all;and;architecture;array;assert;assume;assume_guarantee;attribute;begin;block;body;break;buffer;bus;case;component;configuration;constant;context;cover;default;disconnect;downto;else;elsif;end;entity;exit;fairness;file;for;force;function;generate;generic;group;guarded;if;impure;in;inertial;inout;is;label;library;limit;linkage;literal;loop;map;mod;nand;nature;new;next;noise;nor;not;null;of;on;open;or;others;out;package;parameter;port;postponed;procedural;procedure;process;property;protected;pure;quantity;range;record;reference;register;reject;release;rem;report;restrict;restrict_guarantee;return;rol;ror;select;sequence;severity;signal;shared;sla;sll;spectrum;sra;srl;strong;subnature;subtype;terminal;then;through;to;tolerance;transport;type;unaffected;units;until;use;variable;vmode;vprop;vunit;wait;when;while;with;xnor;xor");
        store.setDefault("vhdl.language.keywords2008", "abs;access;after;alias;all;and;architecture;array;assert;assume;assume_guarantee;attribute;begin;block;body;buffer;bus;case;component;configuration;constant;context;cover;default;disconnect;downto;else;elsif;end;entity;exit;fairness;file;for;force;function;generate;generic;group;guarded;if;impure;in;inertial;inout;is;label;library;linkage;literal;map;mod;loop;nand;new;next;nor;not;null;of;on;open;or;out;others;package;parameter;port;postponed;procedure;process;property;protected;pure;range;record;register;reject;release;rem;report;restrict;restrict_guarantee;return;rol;ror;select;sequence;severity;signal;shared;sla;sll;sra;srl;strong;subtype;then;to;transport;type;unaffected;units;until;use;variable;vmode;vprop;vunit;wait;when;while;with;xnor;xor");
        store.setDefault("vhdl.language.types", "bit;bit_vector;boolean;boolean_vector;character;complex;complex_vector;complex_polar;delay_length;domain;domain_type;enumerated;file;file_open_kind;file_open_status;floating_point;integer;integer_vector;line;natural;physical;positive;real;real_vector;records;severity_level;side;signed;small_int;std_logic;std_logic_vector;std_ulogic;std_ulogic_vector;string;tbl_type;text;time;time_vector;unsigned;ux01;ux01z;width;x01;x01z;");
    }

    void initializeOutlinePreferences(IPreferenceStore store) {
        store.setDefault("outline.prefs_changed", false);
        store.setDefault("outline.show_types", true);
        store.setDefault("outline.show_type_bodies", true);
        store.setDefault("outline.show_signals", true);
        store.setDefault("outline.show_functions", true);
        store.setDefault("outline.show_components", true);
        store.setDefault("outline.show_instances", true);
        store.setDefault("outline.show_architectures", true);
        store.setDefault("outline.show_ports", true);
        store.setDefault("outline.show_processes", true);
        store.setDefault("outline.show_blocks", true);
        store.setDefault("outline.show_configurations", true);
        store.setDefault("outline.show_entities", true);
        store.setDefault("outline.show_package_bodies", true);
        store.setDefault("outline.show_packages", true);
        store.setDefault("outline.show_sequences", true);
        store.setDefault("outline.show_variables", true);
        store.setDefault("outline.show_vunits", true);
        store.setDefault("outline.show_aliases", true);
        store.setDefault("outline.show_package_instances", true);
        store.setDefault("outline.show_subprogram_instances", true);
        DVTPredefinedGUIFilters.putOutlinePredefinedGUIFilter((LanguageKind)LanguageKind.VHDL, (IPreferenceStore)store);
    }

    void initializeContentAssistPreferences(IPreferenceStore store) {
        store.setDefault("ca.ignore_case", true);
        store.setDefault("ca.camel_case", true);
        store.setDefault("ca.prefix_match", true);
        store.setDefault("ca.chars_trigger", ".,= ,: ");
        store.setDefault("ca.auto_insert_single", false);
        store.setDefault("ca.insert_optional_arguments", true);
        store.setDefault("ca.multi_line_named_arguments", true);
        store.setDefault("ca.multi_line_ordered_arguments", false);
        store.setDefault("contentAssist.autoRange.preservePortOrderAndComments", true);
        store.setDefault("contentAssist.module_autoinstance_prefix", "u_");
        store.setDefault("contentAssist.generateSignals", true);
    }

    void initializeTypingPreferences(IPreferenceStore store) {
        store.setDefault("typing.quote_case", true);
        store.setDefault("typing.paran_case", true);
        store.setDefault("typing.brack_case", true);
        store.setDefault("typing.curly_case", true);
        store.setDefault("typing.comments_case", true);
        store.setDefault("typing.enclose.brack_case", true);
        store.setDefault("typing.enclose.curly_case", true);
        store.setDefault("typing.enclose.paran_case", true);
        store.setDefault("typing.enclose.quote_case", true);
        store.setDefault("typing.transform_dot_dot_to_assign", true);
        store.setDefault("typing.transform_comma_comma_to_assign", true);
        store.setDefault("typing.transform_semicolon_to_assign", true);
        store.setDefault("typing.transform_whitespace", false);
    }

    void initializeAutoindentPreferences(IPreferenceStore store) {
        store.setDefault("autoindent.disabled", false);
    }

    void initializeEditorPreferences(IPreferenceStore store) {
        SpellCheckEngine.getInstance().registerDictionary((ISpellDictionary)new TaskTagDictionary(store));
        store.setDefault("editor.disable_tool_tips", false);
        store.setDefault("disable.compareviewer", 100000);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inactiveGenerateBranchHighlightColor", (RGB)PrefConst.INACTIVE_GENERATE_BRANCH_HIGHLIGHT_COLOR_VAL);
        store.setDefault("inactiveGenerateBranchHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)EditorsUI.getPreferenceStore(), (String)"matchingBracketsVhdlColor", (RGB)PrefConst.MATCHING_BRACKETS_HIGHLIGHT_COLOR_VAL);
        EditorsUI.getPreferenceStore().setDefault("matchingBracketsVhdlEnable", true);
        store.setDefault("editor.codeFolding", true);
        store.setDefault("editor.manualCodeFolding", true);
        store.setDefault("editor.numberOfLines", 10000);
        store.setDefault("inactiveCodeHighlightEnable", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"inactiveCodeHighlightColor", (RGB)PrefConst.INACTIVE_CODE_HIGHLIGHT_COLOR_VAL);
        store.setDefault("format.capitalization.keywords", 1);
        store.setDefault("format.capitalization.data_types", 1);
        store.setDefault("format.capitalization.attributes", 1);
        store.setDefault("format.whitespace.trim_end_of_line", true);
        store.setDefault("format.whitespace.trim_whitespace_line", true);
        store.setDefault("format.whitespace.compact", false);
        store.setDefault("format.whitespace.compact_consecutive_empty_lines", false);
        store.setDefault("format.whitespace.maximum_nof_consecutive_empty_lines", 1);
        store.setDefault("format.whitespace.add_after", "");
        store.setDefault("format.whitespace.add_before", "");
        store.setDefault("format.indent.begin", 1);
        store.setDefault("format.indent.else", 1);
        store.setDefault("format.indent.params", 1);
        store.setDefault("format.indent.more_per_line_if_less_than_enable", false);
        store.setDefault("format.indent.more_per_line_if_less_than_threshold", 5);
        store.setDefault("format.indent.preproc", 1);
        store.setDefault("format.indent.preserve_sl_comment_column_zero", true);
        store.setDefault("format.indent.multiline_comments", true);
        store.setDefault("format.indent.no_indent_keywords", "");
        store.setDefault("format.indent.ignore_lines", "");
        store.setDefault("format.line_wrap", false);
        store.setDefault("format.line_wrap.threshold", 80);
        store.setDefault("format.line_wrap.sl_comments", false);
        store.setDefault("format.line_wrap.ml_comments", false);
        store.setDefault("format.vertical_align", false);
        store.setDefault("format.vertical_align.tokens", ":=,<=,=>");
        store.setDefault("format.vertical_align.sl_comments", false);
        store.setDefault("format.vertical_align.paren", false);
        store.setDefault("format.vertical_align.curly", false);
        store.setDefault("format.vertical_align.vregex", "");
        store.setDefault("format.indent.no_indent_keywords", "");
        store.setDefault("format.pre_external", false);
        store.setDefault("format.pre_external.command", "pre_format_code %f");
        store.setDefault("format.post_external", false);
        store.setDefault("format.post_external.command", "post_format_code %f");
        store.setDefault("format.external", false);
        store.setDefault("format.external.command", "format_code %f");
        store.setDefault("format.preview.show_invisible_characters", false);
        store.setDefault("format.preview.line_wrap_threshold", 50);
        store.setDefault("format.format_on_paste", "Disabled");
    }
}

