/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.utils.IntegerFieldEditor;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class VhdlContentAssistPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Group fActivationGroup;
    private Group fSortingFilteringGroup;
    private Group fAutoinstantationGroup;
    protected StringFieldEditor fInstancePrefix;
    private BooleanFieldEditor fPreservePortOrder;
    private BooleanFieldEditor fGenerateWiresAbove;
    private BooleanFieldEditor fIgnoreCase;
    private BooleanFieldEditor fCamelCase;
    private Button fActivationEnableField;
    private IntegerFieldEditor fActivationDelayField;
    private StringFieldEditor fActivationCharsField;
    private BooleanFieldEditor fAutoInsertSingle;
    private Button fInsertNamedArguments;
    private BooleanFieldEditor fInsertMultiLineNamedArguments;
    private BooleanFieldEditor fInsertMultiLineOrderedArguments;
    private BooleanFieldEditor fInsertOptionalArguments;
    private Group fInsertionGroup;

    public VhdlContentAssistPreferencePage() {
        super(1);
        this.setPreferenceStore(VhdlPlugin.getDefault().getPreferenceStore());
        this.setDescription(null);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.createHeader(parent);
        Control result = super.createContents(parent);
        result.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                VhdlContentAssistPreferencePage.this.fAutoInsertSingle.load();
                VhdlContentAssistPreferencePage.this.fActivationDelayField.load();
                VhdlContentAssistPreferencePage.this.fActivationEnableField.setSelection(!DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_auto_complete"));
                VhdlContentAssistPreferencePage.this.fActivationDelayField.setEnabled(VhdlContentAssistPreferencePage.this.fActivationEnableField.getSelection(), (Composite)VhdlContentAssistPreferencePage.this.fActivationGroup);
                VhdlContentAssistPreferencePage.this.fActivationCharsField.setEnabled(VhdlContentAssistPreferencePage.this.fActivationEnableField.getSelection(), (Composite)VhdlContentAssistPreferencePage.this.fActivationGroup);
            }
        });
        return result;
    }

    protected void createFieldEditors() {
        this.fInsertOptionalArguments = new BooleanFieldEditor("ca.insert_optional_arguments", "Insert optional arguments for function and procedure calls", (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fInsertOptionalArguments);
        this.fIgnoreCase = new BooleanFieldEditor("ca.ignore_case", "Ignore case for content assist proposals", (Composite)this.fSortingFilteringGroup);
        this.addField((FieldEditor)this.fIgnoreCase);
        this.fCamelCase = new BooleanFieldEditor("ca.camel_case", "Show camel case like matches", (Composite)this.fSortingFilteringGroup);
        this.addField((FieldEditor)this.fCamelCase);
        this.fActivationDelayField = new IntegerFieldEditor("ca.delay_trigger", " Auto-activation delay (milliseconds):", 5, (Composite)this.fActivationGroup);
        this.fActivationDelayField.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.fActivationDelayField.setEnabled(this.fActivationEnableField.getSelection(), (Composite)this.fActivationGroup);
        this.addField((FieldEditor)this.fActivationDelayField);
        this.fActivationCharsField = new StringFieldEditor("ca.chars_trigger", " Auto-activation prefixes:", (Composite)this.fActivationGroup);
        this.fActivationCharsField.setEnabled(this.fActivationEnableField.getSelection(), (Composite)this.fActivationGroup);
        this.addField((FieldEditor)this.fActivationCharsField);
    }

    private void createHeader(Composite contents) {
        this.initializeDialogUnits((Control)contents);
        this.fInsertionGroup = new Group(contents, 16);
        GridLayout layout = new GridLayout(2, false);
        GridData data = new GridData(4, 4, true, false);
        this.fInsertionGroup.setLayout((Layout)layout);
        this.fInsertionGroup.setLayoutData((Object)data);
        this.fInsertionGroup.setText("Insertion");
        this.fAutoInsertSingle = new BooleanFieldEditor("ca.auto_insert_single", "Insert single proposals automatically", (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fAutoInsertSingle);
        this.fInsertNamedArguments = new Button((Composite)this.fInsertionGroup, 32);
        this.fInsertNamedArguments.setFont(this.fInsertionGroup.getFont());
        this.fInsertNamedArguments.setText("Insert named arguments for function and procedures calls");
        this.fInsertNamedArguments.setSelection(PrefConst.isInsertNamedArgumentsEnabled(DVTPlugin.getDefault().getPreferenceStore()));
        this.fInsertNamedArguments.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTPlugin.getDefault().getPreferenceStore().setValue("ca.insert_named_arguments", VhdlContentAssistPreferencePage.this.fInsertNamedArguments.getSelection());
                VhdlContentAssistPreferencePage.this.fInsertMultiLineNamedArguments.setEnabled(VhdlContentAssistPreferencePage.this.fInsertNamedArguments.getSelection(), (Composite)VhdlContentAssistPreferencePage.this.fInsertionGroup);
                VhdlContentAssistPreferencePage.this.fInsertMultiLineOrderedArguments.setEnabled(!VhdlContentAssistPreferencePage.this.fInsertNamedArguments.getSelection(), (Composite)VhdlContentAssistPreferencePage.this.fInsertionGroup);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fInsertMultiLineNamedArguments = new BooleanFieldEditor("ca.multi_line_named_arguments", "Insert named arguments as multi-line", (Composite)this.fInsertionGroup);
        this.fInsertMultiLineNamedArguments.setEnabled(this.fInsertNamedArguments.getSelection(), (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fInsertMultiLineNamedArguments);
        this.fInsertMultiLineOrderedArguments = new BooleanFieldEditor("ca.multi_line_ordered_arguments", "Insert ordered arguments as multi-line", (Composite)this.fInsertionGroup);
        this.fInsertMultiLineOrderedArguments.setEnabled(!this.fInsertNamedArguments.getSelection(), (Composite)this.fInsertionGroup);
        this.addField((FieldEditor)this.fInsertMultiLineOrderedArguments);
        Dialog.applyDialogFont((Control)this.fInsertionGroup);
        this.fSortingFilteringGroup = new Group(contents, 16);
        layout = new GridLayout(2, false);
        data = new GridData(4, 4, true, false);
        this.fSortingFilteringGroup.setLayout((Layout)layout);
        this.fSortingFilteringGroup.setLayoutData((Object)data);
        this.fSortingFilteringGroup.setText("Sorting and Filtering");
        Dialog.applyDialogFont((Control)this.fSortingFilteringGroup);
        this.fActivationGroup = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.fActivationGroup.setLayout((Layout)layout);
        this.fActivationGroup.setLayoutData((Object)data);
        this.fActivationGroup.setText("Auto-activation");
        Dialog.applyDialogFont((Control)this.fActivationGroup);
        this.fActivationEnableField = new Button((Composite)this.fActivationGroup, 32);
        this.fActivationEnableField.setFont(this.fActivationGroup.getFont());
        this.fActivationEnableField.setText("Enable auto-activation");
        GridData caEnableButtonGridData = new GridData(1, 0x1000000, false, false);
        this.fActivationEnableField.setLayoutData((Object)caEnableButtonGridData);
        this.fActivationEnableField.setSelection(!DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_auto_complete"));
        this.fActivationEnableField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTPlugin.getDefault().getPreferenceStore().setValue("editor.disable_auto_complete", !VhdlContentAssistPreferencePage.this.fActivationEnableField.getSelection());
                VhdlContentAssistPreferencePage.this.fActivationDelayField.setEnabled(VhdlContentAssistPreferencePage.this.fActivationEnableField.getSelection(), (Composite)VhdlContentAssistPreferencePage.this.fActivationGroup);
                VhdlContentAssistPreferencePage.this.fActivationCharsField.setEnabled(VhdlContentAssistPreferencePage.this.fActivationEnableField.getSelection(), (Composite)VhdlContentAssistPreferencePage.this.fActivationGroup);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label((Composite)this.fActivationGroup, 0);
        label.setText("");
        this.fAutoinstantationGroup = new Group(contents, 16);
        layout = new GridLayout();
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.fAutoinstantationGroup.setLayout((Layout)layout);
        this.fAutoinstantationGroup.setLayoutData((Object)data);
        this.fAutoinstantationGroup.setText("Auto-instantiation");
        Dialog.applyDialogFont((Control)this.fAutoinstantationGroup);
        this.fPreservePortOrder = new BooleanFieldEditor("contentAssist.autoRange.preservePortOrderAndComments", "Preserve port order and comments", (Composite)this.fAutoinstantationGroup);
        this.addField((FieldEditor)this.fPreservePortOrder);
        this.fGenerateWiresAbove = new BooleanFieldEditor("contentAssist.generateSignals", "Generate signals above", (Composite)this.fAutoinstantationGroup);
        this.addField((FieldEditor)this.fGenerateWiresAbove);
        this.fInstancePrefix = new StringFieldEditor("contentAssist.module_autoinstance_prefix", "Instance prefix", 5, (Composite)this.fAutoinstantationGroup);
        this.addField((FieldEditor)this.fInstancePrefix);
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        preferenceStore.setToDefault("editor.disable_auto_complete");
        this.fActivationEnableField.setSelection(!preferenceStore.getBoolean("editor.disable_auto_complete"));
        this.fActivationDelayField.setEnabled(this.fActivationEnableField.getSelection(), (Composite)this.fActivationGroup);
        this.fActivationCharsField.setEnabled(this.fActivationEnableField.getSelection(), (Composite)this.fActivationGroup);
        preferenceStore.setToDefault("ca.insert_named_arguments");
        this.fInsertNamedArguments.setSelection(PrefConst.isInsertNamedArgumentsEnabled(preferenceStore));
        this.fInsertMultiLineNamedArguments.setEnabled(PrefConst.isInsertNamedArgumentsEnabled(preferenceStore), (Composite)this.fInsertionGroup);
        this.fInsertMultiLineOrderedArguments.setEnabled(!PrefConst.isInsertNamedArgumentsEnabled(preferenceStore), (Composite)this.fInsertionGroup);
    }

    public void dispose() {
        super.dispose();
        this.fActivationEnableField.dispose();
    }

    protected void initialize() {
        super.initialize();
        this.fActivationDelayField.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.fActivationDelayField.load();
    }
}

