/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.addgeneric;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.vhdldt.ui.refactor.addgeneric.VhdlRefactorAddGenericAlgorithm;

public abstract class VhdlRefactorAddGenericProcessorCommon
extends DVTRefactoringProcessor {
    protected VhdlRefactorAddGenericAlgorithm algorithm;

    protected VhdlRefactorAddGenericProcessorCommon(VhdlRefactorAddGenericAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Object[] getElements() {
        return new Object[0];
    }

    public String getIdentifier() {
        return "VhdlRefactorAddGenericProcessor";
    }

    public String getProcessorName() {
        return "VHDL Refactor Add Generic";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Set<RefactorInputWrapper> treeChgs;
        CompositeChange allChanges;
        block7: {
            allChanges = new CompositeChange("All changes");
            treeChgs = this.algorithm.computeChangeWrappers();
            if (treeChgs != null) break block7;
            return null;
        }
        try {
            Set<TextChange> textChgs = this.algorithm.computeChangesFromWrappers(treeChgs, pm);
            HashMap<IFile, ArrayList<TextChange>> textChgsPerFile = new HashMap<IFile, ArrayList<TextChange>>();
            for (TextChange textChange : textChgs) {
                IFile key = textChange.file;
                ArrayList<TextChange> listChgs = (ArrayList<TextChange>)textChgsPerFile.get(key);
                if (listChgs == null) {
                    listChgs = new ArrayList<TextChange>();
                    textChgsPerFile.put(key, listChgs);
                }
                listChgs.add(textChange);
            }
            for (Map.Entry entry : textChgsPerFile.entrySet()) {
                IFile file = (IFile)entry.getKey();
                TextFileChange txc = this.getTextFileChange(file);
                txc.setEdit((TextEdit)new MultiTextEdit());
                for (TextChange textChg : (List)entry.getValue()) {
                    txc.getEdit().addChild((TextEdit)new ReplaceEdit(textChg.offset, textChg.length, textChg.text));
                }
                allChanges.add((Change)txc);
            }
            return allChanges;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected abstract TextFileChange getTextFileChange(IFile var1);
}

