/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.addgeneric;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.ui.refactor.connect.CustomTextContentAdapter;
import ro.amiq.dvt.ui.refactor.connect.ViewerContentProposalProvider;
import ro.amiq.dvt.ui.widget.utils.DVTWidgetContentAssistProposalProvider;
import ro.amiq.vhdldt.ui.refactor.addgeneric.VhdlRefactorAddGenericAlgorithm;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorAddWizardInput;

public class VhdlRefactorAddGenericWizardPage
extends UserInputWizardPage {
    private VhdlRefactorAddWizardInput wizardInput;
    private Text genericNameText;
    private Text genericTypeText;
    private Text genericWidthText;
    private Text genericDefaultValueText;
    private boolean isTriggeredFromQF;

    public VhdlRefactorAddGenericWizardPage(String name, VhdlRefactorAddWizardInput userInput, boolean isTriggeredFromQF) {
        super(name);
        this.wizardInput = userInput;
        this.isTriggeredFromQF = isTriggeredFromQF;
    }

    public void createControl(Composite parent) {
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VhdlRefactorAddGenericWizardPage.this.updateAndValidate();
            }
        };
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText("Generic name:");
        this.genericNameText = new Text(result, 2048);
        this.genericNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.genericNameText.setText(this.wizardInput.getNewElementName());
        this.genericNameText.addModifyListener(ml);
        if (this.isTriggeredFromQF) {
            this.genericNameText.setEnabled(false);
        }
        label = new Label(result, 0);
        label.setText("Generic type:");
        this.genericTypeText = new Text(result, 2048);
        this.genericTypeText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.genericTypeText.setText(this.wizardInput.getType());
        this.genericTypeText.addModifyListener(ml);
        CustomTextContentAdapter contentAdapter = new CustomTextContentAdapter();
        VhdlRefactorAddGenericAlgorithm addGenericAlgorithm = new VhdlRefactorAddGenericAlgorithm(this.wizardInput, DVTPlugin.getSelectionManager().getLastSelectedProject());
        ViewerContentProposalProvider findProposer = new ViewerContentProposalProvider(addGenericAlgorithm.getSignalTypeContentAssistSuggestions(DVTPlugin.getSelectionManager().getLastSelectedProject()));
        new ContentAssistCommandAdapter((Control)this.genericTypeText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", this.getAutoactivationChars(), true);
        label = new Label(result, 0);
        label.setText("Generic width:");
        this.genericWidthText = new Text(result, 2048);
        this.genericWidthText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.genericWidthText.setText(this.wizardInput.getWidth());
        this.genericWidthText.setMessage("e.g. 7 downto 0");
        this.genericWidthText.addModifyListener(ml);
        TextContentAdapter widthAdapter = new TextContentAdapter();
        String[] widthProposals = new String[]{"to", "downto"};
        DVTWidgetContentAssistProposalProvider widthProposer = new DVTWidgetContentAssistProposalProvider(widthProposals);
        new ContentAssistCommandAdapter((Control)this.genericWidthText, (IControlContentAdapter)widthAdapter, (IContentProposalProvider)widthProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", this.getAutoactivationChars(), true);
        label = new Label(result, 0);
        label.setText("Generic default value:");
        this.genericDefaultValueText = new Text(result, 2048);
        this.genericDefaultValueText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.genericDefaultValueText.setText("");
        this.genericDefaultValueText.addModifyListener(ml);
        this.updateAndValidate();
    }

    protected char[] getAutoactivationChars() {
        String lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
        String uppercaseLetters = lowercaseLetters.toUpperCase();
        String numbers = "0123456789";
        String delete = new String(new char[]{'\b'});
        String allChars = String.valueOf(lowercaseLetters) + uppercaseLetters + numbers + delete;
        return allChars.toCharArray();
    }

    private void updateAndValidate() {
        String portName = this.genericNameText.getText();
        if (!portName.isEmpty() && portName.charAt(0) == '\\') {
            portName = String.valueOf(portName) + " ";
        }
        this.wizardInput.setNewElementName(portName);
        this.wizardInput.setType(this.genericTypeText.getText());
        this.wizardInput.setWidth(this.genericWidthText.getText());
        this.wizardInput.setGenericDefaultValue(this.genericDefaultValueText.getText());
        this.checkValid();
    }

    private boolean validateField(String field, String warning) {
        if (RfReferencesUtils.isValidIndentifierName((String)field)) {
            return true;
        }
        this.setWarning(warning);
        RefactoringWizard wizard = (RefactoringWizard)this.getWizard();
        wizard.setForcePreviewReview(true);
        return false;
    }

    private void checkValid() {
        String genericName = this.wizardInput.getNewElementName();
        String genericType = this.wizardInput.getType();
        IRfDesignElement element = this.wizardInput.getTargetElement();
        if (genericName.isEmpty()) {
            this.setError("You must provide a name for the new generic");
            return;
        }
        String genericNameWarning = "Generic name is not a valid identifier, prefix with '\\' to escape it. It is mandatory to preview the changes.";
        if (!this.validateField(genericName, genericNameWarning)) {
            return;
        }
        String genericTypeWarning = "Generic type is not a valid identifier, prefix with '\\' to escape it. It is mandatory to preview the changes.";
        if (!this.validateField(genericType, genericTypeWarning)) {
            return;
        }
        IRfNamedElement existingField = element.getSignalWithPrefix(genericName, 1);
        if (existingField != null) {
            String message = "There is already a " + existingField.getKindName() + " with the same name in this " + element.getKindName() + "." + "\nThe original declaration will not be removed!";
            this.setWarning(message);
            return;
        }
        this.resetErrorMessage();
        ((RefactoringWizard)this.getWizard()).setForcePreviewReview(false);
    }

    private void resetErrorMessage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void setWarning(String warning) {
        this.resetErrorMessage();
        this.setMessage(warning, 2);
        this.setPageComplete(true);
    }

    private void setError(String error) {
        this.resetErrorMessage();
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }
}

