/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.addport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.refactor.add.IRefactorAddAlgorithm;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorAddWizardInput;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorDesignElementAlgorithm;

public class VhdlRefactorAddPortAlgorithm
extends VhdlRefactorDesignElementAlgorithm
implements IRefactorAddAlgorithm {
    public static final List<String> predefined = Arrays.asList("bit", "bit_vector", "boolean", "boolean_vector", "character", "integer", "integer_vector", "natural", "positive", "real", "real_vector", "signed", "std_logic", "std_logic_vector", "std_ulogic", "std_ulogic_vector", "string", "small_int", "time", "time_vector", "unsigned");
    private VhdlRefactorAddWizardInput wizardInput;

    public VhdlRefactorAddPortAlgorithm(VhdlRefactorAddWizardInput wizardInput, IProject project) {
        this.wizardInput = wizardInput;
        this.setProject(project);
    }

    public Set<RefactorInputWrapper> computeChangeWrappers() {
        if (!this.isSupportedProject()) {
            return Collections.emptySet();
        }
        HashSet<RefactorInputWrapper> allChangeWrappers = new HashSet<RefactorInputWrapper>();
        RefactorInputWrapper entityChangeWrapper = this.wrappersFactory.makeDesignElementPortChangeWrapper(null, false, false, (IRfNamedElement)this.wizardInput.getTargetElement(), this.wizardInput.getNewElementName(), this.wizardInput.getDirection(), this.wizardInput.getType(), this.wizardInput.getWidth());
        if (entityChangeWrapper != null) {
            allChangeWrappers.add(entityChangeWrapper);
        }
        List<RefactorInputWrapper> instancesChangeWrappers = this.wrappersFactory.makeInstancesChangeWrappers(RefactorDesignElementOperation.ADD_PORT, this.wizardInput, this.rfProject);
        allChangeWrappers.addAll(instancesChangeWrappers);
        List<RefactorInputWrapper> componentChangeWrapper = this.wrappersFactory.makeComponentChangeWrappers(instancesChangeWrappers, null, false);
        allChangeWrappers.addAll(componentChangeWrapper);
        return allChangeWrappers;
    }

    public Set<TextChange> computeChangesFromWrappers(Set<RefactorInputWrapper> treeChanges, IProgressMonitor pm) {
        HashSet<TextChange> allTextChanges = new HashSet<TextChange>();
        ArrayList<RefactorInputWrapper> instances = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper treeCh : treeChanges) {
            IRfNamedElement targetElement = treeCh.getTargetElement();
            if (targetElement instanceof IRfInstanceElement) {
                if (!this.excludedInstances.isEmpty() && this.excludedInstances.contains(targetElement)) continue;
                instances.add(treeCh);
                continue;
            }
            TextChange textCh = this.changeFactory.makeDesignElementTextChange(treeCh);
            if (textCh == null) continue;
            allTextChanges.add(textCh);
        }
        List<TextChange> textInstances = this.changeFactory.makeAllInstancesTextChanges(instances, pm);
        for (TextChange textInst : textInstances) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (textInst == null) continue;
            allTextChanges.add(textInst);
        }
        return allTextChanges;
    }

    public String validateWrappers(Set<RefactorInputWrapper> makeTreeChanges) {
        return this.wrappersFactory.validTreeChanges(makeTreeChanges);
    }

    public String[] getSignalTypeContentAssistSuggestions(IProject project) {
        return predefined.toArray(new String[predefined.size()]);
    }
}

