/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.addport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.vhdldt.ui.refactor.addport.VhdlRefactorAddPortAlgorithm;

public abstract class VhdlRefactorAddPortProcessorCommon
extends DVTRefactoringProcessor {
    protected VhdlRefactorAddPortAlgorithm algorithm;

    protected VhdlRefactorAddPortProcessorCommon(VhdlRefactorAddPortAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Object[] getElements() {
        return new Object[0];
    }

    public String getIdentifier() {
        return "VhdlRefactorAddPortProcessor";
    }

    public String getProcessorName() {
        return "VHDL Refactor Add Port";
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Set<RefactorInputWrapper> treeChgs;
        CompositeChange allChanges;
        block8: {
            allChanges = new CompositeChange("All changes");
            treeChgs = this.algorithm.computeChangeWrappers();
            if (treeChgs != null) break block8;
            return null;
        }
        try {
            Set<TextChange> textChgs = this.algorithm.computeChangesFromWrappers(treeChgs, pm);
            HashMap<IFile, ArrayList<TextChange>> textChgsPerFile = new HashMap<IFile, ArrayList<TextChange>>();
            for (TextChange textChange : textChgs) {
                IFile key = textChange.file;
                ArrayList<TextChange> listChgs = (ArrayList<TextChange>)textChgsPerFile.get(key);
                if (listChgs == null) {
                    listChgs = new ArrayList<TextChange>();
                    textChgsPerFile.put(key, listChgs);
                }
                listChgs.add(textChange);
            }
            for (Map.Entry entry : textChgsPerFile.entrySet()) {
                IFile file = (IFile)entry.getKey();
                TextFileChange txc = this.getTextFileChange(file);
                txc.setEdit((TextEdit)new MultiTextEdit());
                for (TextChange textChg : (List)entry.getValue()) {
                    txc.getEdit().addChild((TextEdit)new ReplaceEdit(textChg.offset, textChg.length, textChg.text));
                }
                allChanges.add((Change)txc);
            }
            return allChanges;
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    protected abstract TextFileChange getTextFileChange(IFile var1);
}

