/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.addport;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.ui.refactor.connect.CustomTextContentAdapter;
import ro.amiq.dvt.ui.refactor.connect.ViewerContentProposalProvider;
import ro.amiq.dvt.ui.widget.utils.DVTWidgetContentAssistProposalProvider;
import ro.amiq.vhdldt.ui.refactor.addport.VhdlRefactorAddPortAlgorithm;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorAddWizardInput;

public class VhdlRefactorAddPortWizardPage
extends UserInputWizardPage {
    private VhdlRefactorAddWizardInput wizardInput;
    private Text portNameText;
    private Text portTypeText;
    private Text portWidthText;
    private boolean isTriggeredFromQF;

    public VhdlRefactorAddPortWizardPage(String name, VhdlRefactorAddWizardInput userInput, boolean isTriggeredFromQF) {
        super(name);
        this.wizardInput = userInput;
        this.isTriggeredFromQF = isTriggeredFromQF;
    }

    public void createControl(Composite parent) {
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VhdlRefactorAddPortWizardPage.this.updateAndValidate();
            }
        };
        String direction = this.wizardInput.getDirection();
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText("Port name:");
        this.portNameText = new Text(result, 2048);
        this.portNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.portNameText.setText(this.wizardInput.getNewElementName());
        this.portNameText.addModifyListener(ml);
        if (this.isTriggeredFromQF) {
            this.portNameText.setEnabled(false);
        }
        label = new Label(result, 0);
        label.setText("Port direction:");
        Composite composite = new Composite(result, 0);
        composite.setLayout((Layout)new GridLayout(5, true));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        Button inputBtn = new Button(composite, 16);
        inputBtn.setLayoutData((Object)new GridData(4, 0, true, false));
        inputBtn.setText("in");
        inputBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VhdlRefactorAddPortWizardPage.this.wizardInput.setDirection("in");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setButtonSelection(direction, "in", inputBtn);
        Button outputBtn = new Button(composite, 16);
        outputBtn.setLayoutData((Object)new GridData(4, 0, true, false));
        outputBtn.setText("out");
        outputBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VhdlRefactorAddPortWizardPage.this.wizardInput.setDirection("out");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setButtonSelection(direction, "out", outputBtn);
        Button inoutBtn = new Button(composite, 16);
        inoutBtn.setLayoutData((Object)new GridData(4, 0, true, false));
        inoutBtn.setText("inout");
        inoutBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VhdlRefactorAddPortWizardPage.this.wizardInput.setDirection("inout");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setButtonSelection(direction, "inout", inoutBtn);
        Button noneBtn = new Button(composite, 16);
        noneBtn.setLayoutData((Object)new GridData(4, 0, true, false));
        noneBtn.setText("none");
        noneBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VhdlRefactorAddPortWizardPage.this.wizardInput.setDirection("");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setButtonSelection(direction, "none", noneBtn);
        label = new Label(result, 0);
        label.setText("Port type:");
        this.portTypeText = new Text(result, 2048);
        this.portTypeText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.portTypeText.setText(this.wizardInput.getType());
        this.portTypeText.addModifyListener(ml);
        CustomTextContentAdapter contentAdapter = new CustomTextContentAdapter();
        VhdlRefactorAddPortAlgorithm addPortAlgorithm = new VhdlRefactorAddPortAlgorithm(this.wizardInput, DVTPlugin.getSelectionManager().getLastSelectedProject());
        ViewerContentProposalProvider findProposer = new ViewerContentProposalProvider(addPortAlgorithm.getSignalTypeContentAssistSuggestions(DVTPlugin.getSelectionManager().getLastSelectedProject()));
        new ContentAssistCommandAdapter((Control)this.portTypeText, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", this.getAutoactivationChars(), true);
        label = new Label(result, 0);
        label.setText("Port width:");
        this.portWidthText = new Text(result, 2048);
        this.portWidthText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.portWidthText.setText(this.wizardInput.getWidth());
        this.portWidthText.setMessage("e.g. 7 downto 0");
        this.portWidthText.addModifyListener(ml);
        TextContentAdapter widthAdapter = new TextContentAdapter();
        String[] widthProposals = new String[]{"to", "downto"};
        DVTWidgetContentAssistProposalProvider widthProposer = new DVTWidgetContentAssistProposalProvider(widthProposals);
        new ContentAssistCommandAdapter((Control)this.portWidthText, (IControlContentAdapter)widthAdapter, (IContentProposalProvider)widthProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", this.getAutoactivationChars(), true);
        this.updateAndValidate();
    }

    private void setButtonSelection(String givenDirection, String buttonDirection, Button button) {
        if (buttonDirection.equals(givenDirection)) {
            button.setSelection(true);
            this.wizardInput.setDirection(buttonDirection);
        } else if (givenDirection.equals("") && "none".equals(buttonDirection)) {
            button.setSelection(true);
            this.wizardInput.setDirection("");
        }
    }

    protected char[] getAutoactivationChars() {
        String lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
        String uppercaseLetters = lowercaseLetters.toUpperCase();
        String numbers = "0123456789";
        String delete = new String(new char[]{'\b'});
        String allChars = String.valueOf(lowercaseLetters) + uppercaseLetters + numbers + delete;
        return allChars.toCharArray();
    }

    private void updateAndValidate() {
        String portName = this.portNameText.getText();
        if (!portName.isEmpty() && portName.charAt(0) == '\\') {
            portName = String.valueOf(portName) + " ";
        }
        this.wizardInput.setNewElementName(portName);
        this.wizardInput.setType(this.portTypeText.getText());
        this.wizardInput.setWidth(this.portWidthText.getText());
        this.checkValid();
    }

    private boolean validateField(String field, String warning) {
        if (RfReferencesUtils.isValidIndentifierName((String)field)) {
            return true;
        }
        this.setWarning(warning);
        RefactoringWizard wizard = (RefactoringWizard)this.getWizard();
        wizard.setForcePreviewReview(true);
        return false;
    }

    private void checkValid() {
        String portName = this.wizardInput.getNewElementName();
        String portType = this.wizardInput.getType();
        IRfDesignElement element = this.wizardInput.getTargetElement();
        if (portName.isEmpty()) {
            this.setError("You must provide a name for the new port");
            return;
        }
        String portNameWarning = "Port name is not a valid identifier, prefix with '\\' to escape it. It is mandatory to preview the changes.";
        if (!this.validateField(portName, portNameWarning)) {
            return;
        }
        String portTypeWarning = "Port type is not a valid identifier, prefix with '\\' to escape it. It is mandatory to preview the changes.";
        if (!this.validateField(portType, portTypeWarning)) {
            return;
        }
        IRfNamedElement existingField = element.getSignalWithPrefix(portName, 1);
        if (existingField != null) {
            String message = "There is already a " + existingField.getKindName() + " with the same name in this " + element.getKindName() + "." + "\nThe original declaration will not be removed!";
            this.setWarning(message);
            return;
        }
        this.resetErrorMessage();
        ((RefactoringWizard)this.getWizard()).setForcePreviewReview(false);
    }

    private void resetErrorMessage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private void setWarning(String warning) {
        this.resetErrorMessage();
        this.setMessage(warning, 2);
        this.setPageComplete(true);
    }

    private void setError(String error) {
        this.resetErrorMessage();
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }
}

