/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.connect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.ui.refactor.connect.DVTNode;
import ro.amiq.dvt.ui.refactor.connect.IRefactorConnectAlgorithm;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorDesignElementAlgorithm;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorDesignElementUtils;

public class VhdlRefactorConnectAlgorithm
extends VhdlRefactorDesignElementAlgorithm
implements IRefactorConnectAlgorithm {
    private DVTRefactorConnectWizardInput user;
    public static final List<String> predefined = Arrays.asList("bit", "bit_vector", "boolean", "boolean_vector", "character", "integer", "integer_vector", "natural", "positive", "real", "real_vector", "signed", "std_logic", "std_logic_vector", "std_ulogic", "std_ulogic_vector", "string", "small_int", "time", "time_vector", "unsigned");

    public void setRefactorInput(DVTRefactorConnectWizardInput user) {
        this.user = user;
    }

    public Set<RefactorInputWrapper> computeChangeWrappers(DVTNode srcNode, IRfPortElement srcPort, DVTNode dstNode, IRfPortElement dstPort) {
        HashSet<RefactorInputWrapper> allTreeChanges = new HashSet<RefactorInputWrapper>();
        DVTNode rootNode = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((DVTNode)DVTRefactorDesignElementUtils.computeCommonAncestor((DVTNode)srcNode, (DVTNode)dstNode));
        RefactorInputWrapper signalChg = this.wrappersFactory.makeSignalChangeWrapper(rootNode, this.user.getVhdlParentSignal(), this.user.getVhdlSignalType(), this.user.getVhdlSignalWidth());
        if (signalChg != null) {
            allTreeChanges.add(signalChg);
        }
        List<RefactorInputWrapper> instanceChgs = this.wrappersFactory.makeSelectedInstancesConnectChangeWrappers(rootNode, srcNode, dstNode, this.user);
        allTreeChanges.addAll(instanceChgs);
        List<RefactorInputWrapper> componentsChg = this.wrappersFactory.makeComponentChangeWrappers(instanceChgs, null, false);
        allTreeChanges.addAll(componentsChg);
        List<RefactorInputWrapper> entitiesChg = this.wrappersFactory.makeConnectedEntitiesChangeWrappers(rootNode, srcNode, dstNode, this.user, instanceChgs);
        allTreeChanges.addAll(entitiesChg);
        List allDirectInstanceChgs = DVTRefactorDesignElementUtils.getAllDirectConnectedInstances((DVTNode)rootNode, (DVTNode)srcNode, (DVTNode)dstNode);
        List<RefactorInputWrapper> allDirectModuleOrEntityDesigns = this.wrappersFactory.allDirectModuleOrEntityDesigns(rootNode, srcNode, dstNode, this.user);
        List<RefactorInputWrapper> otherInstancesChg = this.wrappersFactory.makeIndirectConnectInstanceChangeWrappers(this.rfProject, allDirectInstanceChgs, allDirectModuleOrEntityDesigns);
        allTreeChanges.addAll(otherInstancesChg);
        List<RefactorInputWrapper> otherComponentsChg = this.wrappersFactory.makeComponentChangeWrappers(otherInstancesChg, componentsChg, true);
        allTreeChanges.addAll(otherComponentsChg);
        return allTreeChanges;
    }

    public String validateWrappers(DVTNode srcNode, IRfPortElement srcPort, DVTNode dstNode, IRfPortElement dstPort, DVTRefactorConnectWizardInput input) {
        String fail1 = VhdlRefactorDesignElementUtils.validNoInternalLoops(srcNode, dstNode);
        if (fail1 != null) {
            return fail1;
        }
        Set<RefactorInputWrapper> changes = this.computeChangeWrappers(srcNode, srcPort, dstNode, dstPort);
        String fail2 = this.wrappersFactory.validTreeChanges(changes);
        if (fail2 != null) {
            return fail2;
        }
        String fail3 = VhdlRefactorDesignElementUtils.validAssociatedComponent(changes);
        if (fail3 != null) {
            return fail3;
        }
        return null;
    }

    public Set<TextChange> computeChangesFromWrappers(Set<RefactorInputWrapper> treeChanges, IProgressMonitor pm) {
        HashSet<TextChange> allTextChanges = new HashSet<TextChange>();
        ArrayList<RefactorInputWrapper> instances = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper treeCh : treeChanges) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (treeCh.getTargetElement() instanceof RfInstance) {
                instances.add(treeCh);
                continue;
            }
            TextChange textCh = this.changeFactory.makeDesignElementTextChange(treeCh);
            if (textCh == null) continue;
            allTextChanges.add(textCh);
        }
        List<TextChange> textInstances = this.changeFactory.makeAllInstancesTextChanges(instances, pm);
        for (TextChange textInst : textInstances) {
            if (textInst == null) continue;
            allTextChanges.add(textInst);
        }
        return allTextChanges;
    }

    public String[] getSignalTypeContentAssistSuggestions(IProject project) {
        return predefined.toArray(new String[predefined.size()]);
    }

    public String validateWrappers(String[] fSrcPath, IRfPortElement fSrcPort, String[] fDstPath, IRfPortElement fDstPort, IProject project, DVTRefactorConnectWizardInput input, IProgressMonitor monitor) {
        String fail1 = VhdlRefactorDesignElementUtils.validNoInternalLoops(fSrcPath, fDstPath, project);
        if (fail1 != null) {
            return fail1;
        }
        Set<RefactorInputWrapper> changes = this.computeChangeWrappers(fSrcPath, fSrcPort, fDstPath, fDstPort, project, monitor);
        String fail2 = this.wrappersFactory.validTreeChanges(changes);
        if (fail2 != null) {
            return fail2;
        }
        String fail3 = VhdlRefactorDesignElementUtils.validAssociatedComponent(changes);
        if (fail3 != null) {
            return fail3;
        }
        return null;
    }

    public Set<RefactorInputWrapper> computeChangeWrappers(String[] srcNode, IRfPortElement srcPort, String[] dstNode, IRfPortElement dstPort, IProject project, IProgressMonitor monitor) {
        HashSet<RefactorInputWrapper> allTreeChanges = new HashSet<RefactorInputWrapper>();
        String[] rootNode = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])DVTRefactorDesignElementUtils.computeCommonAncestor((String[])srcNode, (String[])dstNode), (IProject)project);
        RefactorInputWrapper signalChg = this.wrappersFactory.makeSignalChangeWrapper(rootNode, srcNode, dstNode, this.user.getVhdlParentSignal(), this.user.getVhdlSignalType(), this.user.getVhdlSignalWidth(), project);
        if (signalChg != null) {
            allTreeChanges.add(signalChg);
        }
        List<RefactorInputWrapper> instanceChgs = this.wrappersFactory.makeSelectedInstancesConnectChangeWrappers(rootNode, srcNode, dstNode, this.user, project);
        allTreeChanges.addAll(instanceChgs);
        List<RefactorInputWrapper> componentsChg = this.wrappersFactory.makeComponentChangeWrappers(instanceChgs, null, false);
        allTreeChanges.addAll(componentsChg);
        List<RefactorInputWrapper> entitiesChg = this.wrappersFactory.makeConnectedEntitiesChangeWrappers(rootNode, srcNode, dstNode, this.user, instanceChgs, project);
        allTreeChanges.addAll(entitiesChg);
        List allDirectInstanceChgs = DVTRefactorDesignElementUtils.getAllDirectConnectedInstances((String[])rootNode, (String[])srcNode, (String[])dstNode, (IProject)project, (IProgressMonitor)monitor);
        List<RefactorInputWrapper> allDirectModuleOrEntityDesigns = this.wrappersFactory.allDirectModuleOrEntityDesigns(rootNode, srcNode, dstNode, this.user, project);
        List<RefactorInputWrapper> otherInstancesChg = this.wrappersFactory.makeIndirectConnectInstanceChangeWrappers(this.rfProject, allDirectInstanceChgs, allDirectModuleOrEntityDesigns);
        allTreeChanges.addAll(otherInstancesChg);
        List<RefactorInputWrapper> otherComponentsChg = this.wrappersFactory.makeComponentChangeWrappers(otherInstancesChg, componentsChg, true);
        allTreeChanges.addAll(otherComponentsChg);
        return allTreeChanges;
    }

    public Set<RefactorInputWrapper> computeDirectChangeWrappers(String[] srcNode, IRfPortElement srcPort, String[] dstNode, IRfPortElement dstPort, IProject project, IProgressMonitor monitor) {
        HashSet<RefactorInputWrapper> allTreeChanges = new HashSet<RefactorInputWrapper>();
        String[] rootNode = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])DVTRefactorDesignElementUtils.computeCommonAncestor((String[])srcNode, (String[])dstNode), (IProject)project);
        RefactorInputWrapper signalChg = this.wrappersFactory.makeSignalChangeWrapper(rootNode, srcNode, dstNode, this.user.getVhdlParentSignal(), this.user.getVhdlSignalType(), this.user.getVhdlSignalWidth(), project);
        if (signalChg != null) {
            allTreeChanges.add(signalChg);
        }
        List<RefactorInputWrapper> instanceChgs = this.wrappersFactory.makeSelectedInstancesConnectChangeWrappers(rootNode, srcNode, dstNode, this.user, project);
        allTreeChanges.addAll(instanceChgs);
        return allTreeChanges;
    }

    public Set<RefactorInputWrapper> computeIndirectChangeWrappers(String[] srcNode, IRfPortElement srcPort, String[] dstNode, IRfPortElement dstPort, IProject project, IProgressMonitor monitor) {
        HashSet<RefactorInputWrapper> allTreeChanges = new HashSet<RefactorInputWrapper>();
        String[] rootNode = DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])DVTRefactorDesignElementUtils.computeCommonAncestor((String[])srcNode, (String[])dstNode), (IProject)project);
        List<RefactorInputWrapper> instanceChgs = this.wrappersFactory.makeSelectedInstancesConnectChangeWrappers(rootNode, srcNode, dstNode, this.user, project);
        List<RefactorInputWrapper> componentsChg = this.wrappersFactory.makeComponentChangeWrappers(instanceChgs, null, false);
        allTreeChanges.addAll(componentsChg);
        List<RefactorInputWrapper> entitiesChg = this.wrappersFactory.makeConnectedEntitiesChangeWrappers(rootNode, srcNode, dstNode, this.user, instanceChgs, project);
        allTreeChanges.addAll(entitiesChg);
        List allDirectInstanceChgs = DVTRefactorDesignElementUtils.getAllDirectConnectedInstances((String[])rootNode, (String[])srcNode, (String[])dstNode, (IProject)project, (IProgressMonitor)monitor);
        List<RefactorInputWrapper> allDirectModuleOrEntityDesigns = this.wrappersFactory.allDirectModuleOrEntityDesigns(rootNode, srcNode, dstNode, this.user, project);
        List<RefactorInputWrapper> otherInstancesChg = this.wrappersFactory.makeIndirectConnectInstanceChangeWrappers(this.rfProject, allDirectInstanceChgs, allDirectModuleOrEntityDesigns);
        allTreeChanges.addAll(otherInstancesChg);
        List<RefactorInputWrapper> otherComponentsChg = this.wrappersFactory.makeComponentChangeWrappers(otherInstancesChg, componentsChg, true);
        allTreeChanges.addAll(otherComponentsChg);
        return allTreeChanges;
    }
}

