/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.designelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.refactor.connect.AssociatedElements;
import ro.amiq.dvt.ui.refactor.connect.DVTDesignHierarchyHook;
import ro.amiq.dvt.ui.refactor.connect.DVTNode;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;

public class VhdlRefactorDesignElementUtils
extends DVTRefactorDesignElementUtils {
    public static List<RfInstance> computeAllInstancesInProject(RfProject rfProject) {
        List<RfNamedElement> allArchs = rfProject.getAllArchitectures();
        ArrayList<RfInstance> allInstances = new ArrayList<RfInstance>();
        for (RfNamedElement arch : allArchs) {
            List<RfInstance> inst = arch.getLocalMembers(RfInstance.class);
            if (inst == null) continue;
            allInstances.addAll(inst);
        }
        return allInstances;
    }

    public static boolean supports(Object namedElement) {
        return namedElement instanceof RfInstance || namedElement instanceof RfArchitecture || namedElement instanceof RfEntity;
    }

    public static RfEntity getEntity(RfNamedElement instOrArch, IRfNamedElement resolved) {
        if (instOrArch instanceof RfArchitecture) {
            return ((RfArchitecture)instOrArch).getEntity();
        }
        if (instOrArch instanceof RfInstance) {
            IRfDesignElement resolvedElement;
            if (resolved != null) {
                if (resolved instanceof RfArchitecture) {
                    RfArchitecture arch = (RfArchitecture)resolved;
                    return arch.getEntity();
                }
                if (resolved instanceof RfEntity) {
                    return (RfEntity)resolved;
                }
                return null;
            }
            RfInstance inst = (RfInstance)instOrArch;
            IRfNamedElement design = inst.getGenericDesign(null);
            if (design == null) {
                return null;
            }
            if (!VhdlRefactorDesignElementUtils.supports(design)) {
                return null;
            }
            if (design instanceof RfEntity) {
                return (RfEntity)design;
            }
            if (design instanceof RfComponent && (resolvedElement = ((RfComponent)design).getResolvedElement()) instanceof RfEntity) {
                return (RfEntity)resolvedElement;
            }
        }
        return null;
    }

    public static List<RfInstance> allInstancesOfDesign(List<RfInstance> allInstances, IRfNamedElement design) {
        ArrayList<RfInstance> result = new ArrayList<RfInstance>();
        for (RfInstance instance : allInstances) {
            IRfDesignElement instanceDesignElement = DesignUtils.getDesign((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instance, (boolean)true));
            if (instanceDesignElement == null) continue;
            if (DesignUtils.getDesignKind((Object)instanceDesignElement) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                instanceDesignElement = ((RfArchitecture)instanceDesignElement).getEntity();
            }
            if (!instanceDesignElement.equals(design)) continue;
            result.add(instance);
        }
        return result;
    }

    public static List<RfInstance> collectInstancesOfDesign(RfProject rfProject, IRfNamedElement design) {
        ArrayList<RfInstance> allInstancesOfDesign = new ArrayList<RfInstance>();
        List<RfNamedElement> allArchs = rfProject.getAllArchitectures();
        for (RfNamedElement arch : allArchs) {
            List<RfInstance> allInstancesInArch = arch.getLocalMembers(RfInstance.class);
            if (allInstancesInArch == null || allInstancesInArch.isEmpty()) continue;
            for (RfInstance instance : allInstancesInArch) {
                IRfDesignElement instanceDesignElement = DesignUtils.getDesign((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instance, (boolean)true));
                if (instanceDesignElement == null) continue;
                if (DesignUtils.getDesignKind((Object)instanceDesignElement) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                    instanceDesignElement = ((RfArchitecture)instanceDesignElement).getEntity();
                }
                if (!instanceDesignElement.equals(design)) continue;
                allInstancesOfDesign.add(instance);
            }
        }
        return allInstancesOfDesign;
    }

    public static String validNoInternalLoops(DVTNode srcNode, DVTNode dstNode) {
        if (srcNode == dstNode) {
            return "Can not connect to self";
        }
        DVTNode rootNode = DVTRefactorDesignElementUtils.computeCommonAncestor((DVTNode)srcNode, (DVTNode)dstNode);
        ArrayList<DVTNode> allpath = new ArrayList<DVTNode>();
        DVTNode p = srcNode;
        while (true) {
            allpath.add(p);
            if (p == rootNode) break;
            p = p.fParent;
        }
        p = dstNode;
        while (p != rootNode) {
            allpath.add(p);
            p = p.fParent;
        }
        int i = 0;
        while (i < allpath.size() - 1) {
            DVTNode p2 = (DVTNode)allpath.get(i);
            if (VhdlRefactorDesignElementUtils.supports(p2.element)) {
                RfEntity pEntity = VhdlRefactorDesignElementUtils.getEntity((RfNamedElement)p2.element, p2.instanceType);
                int j = i + 1;
                while (j < allpath.size()) {
                    DVTNode q = (DVTNode)allpath.get(j);
                    if (VhdlRefactorDesignElementUtils.supports(q.element)) {
                        RfEntity qEntity = VhdlRefactorDesignElementUtils.getEntity((RfNamedElement)q.element, q.instanceType);
                        if (pEntity != null && qEntity != null && pEntity.getName().equals(qEntity.getName())) {
                            return "There is a reference to self for Entity " + pEntity.getName();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static String validNoInternalLoops(String[] srcNode, String[] dstNode, IProject project) {
        Object[] rootNode;
        if (Arrays.equals(srcNode, dstNode)) {
            return "Can not connect to self";
        }
        try {
            rootNode = DVTRefactorDesignElementUtils.computeCommonAncestor((String[])srcNode, (String[])dstNode);
        }
        catch (RuntimeException e) {
            return e.getMessage();
        }
        ArrayList<Object[]> allpath = new ArrayList<Object[]>();
        Object[] p = srcNode;
        while (true) {
            allpath.add(p);
            if (Arrays.equals(p, rootNode)) break;
            p = VhdlRefactorDesignElementUtils.subList((String[])p);
        }
        p = dstNode;
        while (!Arrays.equals(p, rootNode)) {
            allpath.add(p);
            p = VhdlRefactorDesignElementUtils.subList((String[])p);
        }
        int i = 0;
        while (i < allpath.size() - 1) {
            String[] p2 = (String[])allpath.get(i);
            IRfNamedElement elementFromSegments = VhdlRefactorDesignElementUtils.getElementFromSegments((String[])p2, (IProject)project);
            if (VhdlRefactorDesignElementUtils.supports(elementFromSegments)) {
                IRfNamedElement instanceType = null;
                instanceType = elementFromSegments instanceof IRfInstanceElement ? ((IRfInstanceElement)elementFromSegments).getAssociatedType() : elementFromSegments;
                RfEntity pEntity = VhdlRefactorDesignElementUtils.getEntity((RfNamedElement)elementFromSegments, instanceType);
                int j = i + 1;
                while (j < allpath.size()) {
                    String[] q = (String[])allpath.get(j);
                    IRfNamedElement anotherElementFromSegments = VhdlRefactorDesignElementUtils.getElementFromSegments((String[])q, (IProject)project);
                    if (VhdlRefactorDesignElementUtils.supports(anotherElementFromSegments)) {
                        IRfNamedElement anotherInstanceType = null;
                        anotherInstanceType = anotherElementFromSegments instanceof IRfInstanceElement ? ((IRfInstanceElement)anotherElementFromSegments).getAssociatedType() : anotherElementFromSegments;
                        RfEntity qEntity = VhdlRefactorDesignElementUtils.getEntity((RfNamedElement)anotherElementFromSegments, anotherInstanceType);
                        if (pEntity != null && qEntity != null && pEntity.getName().equals(qEntity.getName())) {
                            return "There is a reference to self for Entity " + pEntity.getName();
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static String validAssociatedComponent(Set<RefactorInputWrapper> changes) {
        String reason = "";
        HashMap<RfComponent, ArrayList<AssociatedElements>> associations = new HashMap<RfComponent, ArrayList<AssociatedElements>>();
        for (AssociatedElements association : DVTDesignHierarchyHook.relations.values()) {
            ArrayList<AssociatedElements> list = (ArrayList<AssociatedElements>)associations.get(association.fConnectComponent);
            if (list == null) {
                list = new ArrayList<AssociatedElements>();
                associations.put((RfComponent)association.fConnectComponent, list);
            }
            list.add(association);
        }
        ArrayList<RefactorInputWrapper> componentChgs = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper change : changes) {
            if (!(change.getTargetElement() instanceof RfComponent)) continue;
            componentChgs.add(change);
        }
        for (RefactorInputWrapper componentChg : componentChgs) {
            String r;
            RfComponent comp = (RfComponent)componentChg.getTargetElement();
            ArrayList list = (ArrayList)associations.get(comp);
            if (list == null || (r = VhdlRefactorDesignElementUtils.checkMultipleDesignsForComponent(list)) == null) continue;
            reason = String.valueOf(reason) + "Component " + comp.getName() + " in " + comp.getEnclosingScope() + " is used in both " + r + " design elements";
            return reason;
        }
        return null;
    }

    public static String checkMultipleDesignsForComponent(ArrayList<AssociatedElements> list) {
        String reason = "";
        int i = 0;
        while (i < list.size() - 1) {
            AssociatedElements p = list.get(i);
            int j = i + 1;
            while (j < list.size()) {
                AssociatedElements q = list.get(j);
                if (p.fConnectDesign != q.fConnectDesign) {
                    reason = String.valueOf(reason) + p.fConnectDesign.getName() + " and " + q.fConnectDesign.getName();
                    return reason;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

