/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.designelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.refactor.connect.AssociatedElements;
import ro.amiq.dvt.ui.refactor.connect.DVTDesignHierarchyHook;
import ro.amiq.dvt.ui.refactor.connect.DVTNode;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorInputWrapperFactory;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorAddWizardInput;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorDesignElementUtils;

public class VhdlRefactorInputWrapperFactory
extends DVTRefactorInputWrapperFactory {
    public List<RefactorInputWrapper> makeInstancesChangeWrappers(RefactorDesignElementOperation refactorOperation, VhdlRefactorAddWizardInput wizardInput, RfProject rfProject) {
        ArrayList<RefactorInputWrapper> instanceChgs = new ArrayList<RefactorInputWrapper>();
        IRfDesignElement element = wizardInput.getTargetElement();
        String newElementName = wizardInput.getNewElementName();
        String direction = wizardInput.getDirection();
        String connectionValue = "open -- FIXME: not connected" + System.lineSeparator();
        String type = wizardInput.getType();
        String width = wizardInput.getWidth();
        String genericDefaultValue = wizardInput.getGenericDefaultValue();
        List<RfInstance> allInstancesInProject = VhdlRefactorDesignElementUtils.computeAllInstancesInProject(rfProject);
        if (allInstancesInProject == null || allInstancesInProject.isEmpty()) {
            return instanceChgs;
        }
        List<RfInstance> targetModuleInstances = VhdlRefactorDesignElementUtils.allInstancesOfDesign(allInstancesInProject, (IRfNamedElement)element);
        for (RfInstance instance : targetModuleInstances) {
            RefactorInputWrapper instanceChangeWrapper;
            if (refactorOperation == RefactorDesignElementOperation.ADD_PORT) {
                if (this.isDuplicatedPort(newElementName, instance)) continue;
                instanceChangeWrapper = this.makeInstancePortConnectionChangeWrapper(null, false, false, instance, newElementName, connectionValue, direction, type, width, false);
                instanceChgs.add(instanceChangeWrapper);
                continue;
            }
            if (refactorOperation != RefactorDesignElementOperation.ADD_GENERIC || this.isDuplicatedGeneric(newElementName, instance)) continue;
            instanceChangeWrapper = this.makeInstanceParameterConnectionChangeWrapper(null, false, false, instance, newElementName, type, width, connectionValue, genericDefaultValue, false);
            instanceChgs.add(instanceChangeWrapper);
        }
        return instanceChgs;
    }

    private boolean isDuplicatedPort(String newElementName, IRfInstanceElement modInst) {
        if (newElementName == null) {
            return false;
        }
        List instancePCs = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)modInst);
        if (instancePCs == null) {
            return false;
        }
        for (IHidOperator portConnection : instancePCs) {
            if (!newElementName.equals(PortConnectionUtils.getPortName((IHidOperator)portConnection))) continue;
            return true;
        }
        return false;
    }

    private boolean isDuplicatedGeneric(String newElementName, IRfInstanceElement instance) {
        if (newElementName == null) {
            return false;
        }
        List instanceGenericOperators = instance.getHidOperators(ELConstants.GENERIC_VALUES_QUALIFIERS_ARRAY, true);
        if (instanceGenericOperators == null) {
            return false;
        }
        for (IHidOperator op : instanceGenericOperators) {
            IHidObject hid = op.getLHValue();
            if (hid == null || !(hid instanceof RfHid) || !newElementName.equals(((RfHid)hid).getName())) continue;
            return true;
        }
        return false;
    }

    public RefactorInputWrapper makeSignalChangeWrapper(DVTNode rootNode, String parentSignalName, String signalType, String signalWidth) {
        IRfNamedElement element = ((DVTNode)rootNode.fChildren.get((int)0)).element;
        if (!VhdlRefactorDesignElementUtils.supports(element)) {
            return null;
        }
        RfArchitecture arch = (RfArchitecture)DVTRefactorDesignElementUtils.getFirstSupportedScopeT((IRfScopeElement)((DVTNode)rootNode.fChildren.get((int)0)).element, RfArchitecture.class);
        if (arch == null) {
            return null;
        }
        return new RefactorInputWrapper(RefactorDesignElementOperation.ADD_WIRE, (IRfNamedElement)arch, null, false, parentSignalName, "", signalType, parentSignalName, signalWidth, "", false, false);
    }

    public RefactorInputWrapper makeSignalChangeWrapper(String[] rootNode, String[] srcNode, String[] dstNode, String parentSignalName, String signalType, String signalWidth, IProject project) {
        String[] computeCommonAncestorChild = DVTRefactorDesignElementUtils.computeCommonAncestorChild((String[])rootNode, (String[])srcNode, (String[])dstNode);
        IRfNamedElement element = DVTRefactorDesignElementUtils.getElementFromSegments((String[])computeCommonAncestorChild, (IProject)project);
        if (element instanceof DummyInstance) {
            element = ((DummyInstance)element).design;
        }
        if (!VhdlRefactorDesignElementUtils.supports(element)) {
            return null;
        }
        RfArchitecture arch = (RfArchitecture)DVTRefactorDesignElementUtils.getFirstSupportedScopeT((IRfScopeElement)element, RfArchitecture.class);
        if (arch == null) {
            return null;
        }
        return new RefactorInputWrapper(RefactorDesignElementOperation.ADD_WIRE, (IRfNamedElement)arch, rootNode, false, parentSignalName, "", signalType, parentSignalName, signalWidth, "", false, false);
    }

    public List<RefactorInputWrapper> makeIndirectConnectInstanceChangeWrappers(RfProject rfProject, List<IRfInstanceElement> allDirectInstanceChgs, List<RefactorInputWrapper> allDirectModuleOrEntityDesigns) {
        ArrayList<RefactorInputWrapper> result = new ArrayList<RefactorInputWrapper>();
        List<RfInstance> allInstancesInProject = VhdlRefactorDesignElementUtils.computeAllInstancesInProject(rfProject);
        for (RefactorInputWrapper moduleOrEntityDesign : allDirectModuleOrEntityDesigns) {
            List<RfInstance> instancesOfModOrEnt = VhdlRefactorDesignElementUtils.allInstancesOfDesign(allInstancesInProject, moduleOrEntityDesign.getTargetElement());
            for (IRfInstanceElement iRfInstanceElement : instancesOfModOrEnt) {
                if (!VhdlRefactorDesignElementUtils.supports(iRfInstanceElement) || allDirectInstanceChgs.contains(iRfInstanceElement)) continue;
                result.add(this.makeInstancePortConnectionChangeWrapper(moduleOrEntityDesign.getPath(), moduleOrEntityDesign.isOutput(), moduleOrEntityDesign.isInitialGate(), (IRfNamedElement)iRfInstanceElement, moduleOrEntityDesign.getNewElementName(), "open -- FIXME: not connected" + System.lineSeparator(), moduleOrEntityDesign.getDirection(), moduleOrEntityDesign.getType(), moduleOrEntityDesign.getWidth(), false));
            }
        }
        return result;
    }

    public List<RefactorInputWrapper> makeSelectedInstancesConnectChangeWrappers(DVTNode rootNode, DVTNode srcNode, DVTNode dstNode, DVTRefactorConnectWizardInput userInput) {
        ArrayList<RefactorInputWrapper> instanceChgs = new ArrayList<RefactorInputWrapper>();
        String signalName = userInput.getVhdlParentSignal();
        String signalType = userInput.getVhdlSignalType();
        String signalWidth = userInput.getVhdlSignalWidth();
        String[] dirNames = new String[]{"out", "in"};
        String[] signalNames = new String[]{userInput.getVhdlOutputPortName(), userInput.getVhdlInputPortName()};
        String[] portNames = new String[]{userInput.getVhdlOutputPortName(), userInput.getVhdlInputPortName()};
        int dir = 0;
        while (dir < 2) {
            DVTNode fromNode;
            DVTNode p = fromNode = dir == 0 ? srcNode : dstNode;
            while (p != rootNode) {
                if (DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((DVTNode)p.fParent) == rootNode) {
                    if (VhdlRefactorDesignElementUtils.supports(p.element)) {
                        instanceChgs.add(this.makeInstancePortConnectionChangeWrapper(null, false, false, p.element, portNames[dir], signalName, dirNames[dir], signalType, signalWidth, p.insideGenBlock));
                    }
                } else if (VhdlRefactorDesignElementUtils.supports(p.element)) {
                    instanceChgs.add(this.makeInstancePortConnectionChangeWrapper(null, false, false, p.element, portNames[dir], signalNames[dir], dirNames[dir], signalType, signalWidth, p.insideGenBlock));
                }
                p = p.fParent;
            }
            ++dir;
        }
        return instanceChgs;
    }

    public List<RefactorInputWrapper> makeSelectedInstancesConnectChangeWrappers(String[] rootNode, String[] srcNode, String[] dstNode, DVTRefactorConnectWizardInput userInput, IProject project) {
        ArrayList<RefactorInputWrapper> instanceChgs = new ArrayList<RefactorInputWrapper>();
        String signalName = userInput.getVhdlParentSignal();
        String signalType = userInput.getVhdlSignalType();
        String signalWidth = userInput.getVhdlSignalWidth();
        String[] dirNames = new String[]{"out", "in"};
        String[] signalNames = new String[]{userInput.getVhdlOutputPortName(), userInput.getVhdlInputPortName()};
        String[] portNames = new String[]{userInput.getVhdlOutputPortName(), userInput.getVhdlInputPortName()};
        int dir = 0;
        while (dir < 2) {
            Object[] fromNode;
            Object[] p = fromNode = dir == 0 ? srcNode : dstNode;
            while (!Arrays.equals(p, rootNode)) {
                IRfNamedElement elementFromSegments = DVTRefactorDesignElementUtils.getElementFromSegments((String[])p, (IProject)project);
                if (elementFromSegments != null) {
                    boolean isInsideGenerate = DVTRefactorDesignElementUtils.isGenerate((IRfNamedElement)((IRfNamedElement)elementFromSegments.getEnclosingScope()));
                    if (Arrays.equals(DVTRefactorDesignElementUtils.getParentNodeIgnoringBlocks((String[])DVTRefactorDesignElementUtils.subList((String[])p), (IProject)project), rootNode)) {
                        if (VhdlRefactorDesignElementUtils.supports(elementFromSegments)) {
                            instanceChgs.add(this.makeInstancePortConnectionChangeWrapper((String[])p, DVTRefactorDesignElementUtils.isOutput((String[])p, (String[])srcNode, (String[])dstNode), Arrays.equals(p, srcNode) || Arrays.equals(p, dstNode), elementFromSegments, portNames[dir], signalName, dirNames[dir], signalType, signalWidth, isInsideGenerate));
                        }
                    } else if (VhdlRefactorDesignElementUtils.supports(elementFromSegments)) {
                        instanceChgs.add(this.makeInstancePortConnectionChangeWrapper((String[])p, DVTRefactorDesignElementUtils.isOutput((String[])p, (String[])srcNode, (String[])dstNode), Arrays.equals(p, srcNode) || Arrays.equals(p, dstNode), elementFromSegments, portNames[dir], signalNames[dir], dirNames[dir], signalType, signalWidth, isInsideGenerate));
                    }
                }
                p = DVTRefactorDesignElementUtils.subList((String[])p);
            }
            ++dir;
        }
        return instanceChgs;
    }

    public List<RefactorInputWrapper> makeConnectedEntitiesChangeWrappers(DVTNode rootNode, DVTNode srcNode, DVTNode dstNode, DVTRefactorConnectWizardInput userInput, List<RefactorInputWrapper> instanceChgs) {
        ArrayList<RefactorInputWrapper> entitiesChg = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper instanceChg : instanceChgs) {
            AssociatedElements trio = (AssociatedElements)DVTDesignHierarchyHook.relations.get(instanceChg.getTargetElement());
            if (!VhdlRefactorDesignElementUtils.supports(trio.fConnectDesign)) continue;
            RfEntity entity = null;
            if (trio.fConnectDesign instanceof RfArchitecture) {
                entity = ((RfArchitecture)trio.fConnectDesign).getEntity();
            } else if (trio.fConnectDesign instanceof RfEntity) {
                entity = (RfEntity)trio.fConnectDesign;
            }
            if (entity == null) continue;
            entitiesChg.add(this.makeDesignElementPortChangeWrapper(null, false, false, entity, instanceChg.getNewElementName(), instanceChg.getDirection(), userInput.getVhdlSignalType(), userInput.getVhdlSignalWidth()));
        }
        String[] dirNames = new String[]{"out", "in"};
        String[] portNames = new String[]{userInput.getVhdlOutputPortName(), userInput.getVhdlInputPortName()};
        int dir = 0;
        while (dir < 2) {
            DVTNode fromNode;
            DVTNode p = fromNode = dir == 0 ? srcNode : dstNode;
            while (p != rootNode) {
                RefactorInputWrapper ch;
                IRfDesignElement design = null;
                if (VhdlRefactorDesignElementUtils.supports(p.instanceType)) {
                    design = (IRfDesignElement)p.instanceType;
                }
                if (design != null && !entitiesChg.contains(ch = this.makeDesignElementPortChangeWrapper(null, false, false, (IRfNamedElement)design, portNames[dir], dirNames[dir], userInput.getVhdlSignalType(), userInput.getVhdlSignalWidth()))) {
                    entitiesChg.add(ch);
                }
                p = p.fParent;
            }
            ++dir;
        }
        return entitiesChg;
    }

    public List<RefactorInputWrapper> makeConnectedEntitiesChangeWrappers(String[] rootNode, String[] srcNode, String[] dstNode, DVTRefactorConnectWizardInput userInput, List<RefactorInputWrapper> instanceChgs, IProject project) {
        ArrayList<RefactorInputWrapper> entitiesChg = new ArrayList<RefactorInputWrapper>();
        IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(project);
        if (elMemory == null) {
            return null;
        }
        for (RefactorInputWrapper instanceChg : instanceChgs) {
            IRfNamedElement binding;
            List instancesFor;
            IRfNamedElement targetElement = instanceChg.getTargetElement();
            if (!(targetElement instanceof IRfInstanceElement) || (instancesFor = elMemory.getInstancesFor((IRfInstanceElement)targetElement, 1)) == null || instancesFor.isEmpty() || !VhdlRefactorDesignElementUtils.supports(binding = ((ELInstance)instancesFor.get(0)).getBinding(true))) continue;
            RfEntity entity = null;
            if (binding instanceof RfArchitecture) {
                entity = ((RfArchitecture)binding).getEntity();
            } else if (binding instanceof RfEntity) {
                entity = (RfEntity)binding;
            }
            if (entity == null) continue;
            entitiesChg.add(this.makeDesignElementPortChangeWrapper(instanceChg.getPath(), instanceChg.isOutput(), instanceChg.isInitialGate(), entity, instanceChg.getNewElementName(), instanceChg.getDirection(), userInput.getVhdlSignalType(), userInput.getVhdlSignalWidth()));
        }
        String[] dirNames = new String[]{"out", "in"};
        String[] portNames = new String[]{userInput.getVhdlOutputPortName(), userInput.getVhdlInputPortName()};
        int dir = 0;
        while (dir < 2) {
            Object[] fromNode;
            Object[] p = fromNode = dir == 0 ? srcNode : dstNode;
            while (!Arrays.equals(p, rootNode)) {
                RefactorInputWrapper ch;
                IRfDesignElement design = null;
                IRfNamedElement elementFromSegments = DVTRefactorDesignElementUtils.getElementFromSegments((String[])p, (IProject)project);
                IRfNamedElement instanceType = null;
                if (elementFromSegments instanceof IRfInstanceElement) {
                    List instancesFor = elMemory.getInstancesFor((IRfInstanceElement)elementFromSegments, 1);
                    if (instancesFor != null && !instancesFor.isEmpty()) {
                        instanceType = ((ELInstance)instancesFor.get(0)).getBinding(true);
                    }
                } else {
                    instanceType = elementFromSegments;
                }
                if (VhdlRefactorDesignElementUtils.supports(instanceType)) {
                    design = (IRfDesignElement)instanceType;
                }
                if (design != null && !entitiesChg.contains(ch = this.makeDesignElementPortChangeWrapper((String[])p, false, false, (IRfNamedElement)design, portNames[dir], dirNames[dir], userInput.getVhdlSignalType(), userInput.getVhdlSignalWidth()))) {
                    entitiesChg.add(ch);
                }
                p = DVTRefactorDesignElementUtils.subList((String[])p);
            }
            ++dir;
        }
        return entitiesChg;
    }

    public List<RefactorInputWrapper> makeComponentChangeWrappers(List<RefactorInputWrapper> instanceChgs, List<RefactorInputWrapper> componentsChg, boolean indirectChanges) {
        ArrayList<RefactorInputWrapper> result = new ArrayList<RefactorInputWrapper>();
        for (RefactorInputWrapper instanceChg : instanceChgs) {
            IRfNamedElement genericDesign;
            IRfNamedElement targetElement = instanceChg.getTargetElement();
            if (!(targetElement instanceof RfInstance) || !((genericDesign = ((RfInstance)targetElement).getGenericDesign(null)) instanceof RfComponent) || genericDesign instanceof RfEntity) continue;
            if (indirectChanges) {
                if (componentsChg == null || this.getChangeWithTarget(componentsChg, targetElement) != null) continue;
                if (instanceChg.getRefactorOperation() == RefactorDesignElementOperation.ADD_PORT) {
                    result.add(this.makeDesignElementPortChangeWrapper(instanceChg.getPath(), instanceChg.isOutput(), instanceChg.isInitialGate(), genericDesign, instanceChg.getNewElementName(), instanceChg.getDirection(), instanceChg.getType(), instanceChg.getWidth()));
                    continue;
                }
                if (instanceChg.getRefactorOperation() != RefactorDesignElementOperation.ADD_GENERIC) continue;
                result.add(this.makeDesignElementGenericChangeWrapper(instanceChg.getPath(), instanceChg.isOutput(), genericDesign, instanceChg.getNewElementName(), instanceChg.getType(), instanceChg.getWidth(), instanceChg.getGenericDefaultValue()));
                continue;
            }
            if (instanceChg.getRefactorOperation() == RefactorDesignElementOperation.ADD_PORT) {
                result.add(this.makeDesignElementPortChangeWrapper(instanceChg.getPath(), instanceChg.isOutput(), instanceChg.isInitialGate(), genericDesign, instanceChg.getNewElementName(), instanceChg.getDirection(), instanceChg.getType(), instanceChg.getWidth()));
                continue;
            }
            if (instanceChg.getRefactorOperation() != RefactorDesignElementOperation.ADD_GENERIC) continue;
            result.add(this.makeDesignElementGenericChangeWrapper(instanceChg.getPath(), instanceChg.isOutput(), genericDesign, instanceChg.getNewElementName(), instanceChg.getType(), instanceChg.getWidth(), instanceChg.getGenericDefaultValue()));
        }
        return result;
    }

    public String validTreeChanges(Set<RefactorInputWrapper> changes) {
        for (RefactorInputWrapper change : changes) {
            if (change.getRefactorOperation() == RefactorDesignElementOperation.ADD_WIRE) {
                if (change.getTargetElement() instanceof RfArchitecture) continue;
                return "An internal error has occurred(add signal): target element is not an architecture";
            }
            if (change.getRefactorOperation() == RefactorDesignElementOperation.ADD_PORT || change.getRefactorOperation() == RefactorDesignElementOperation.ADD_GENERIC) {
                if (change.getTargetElement() instanceof IRfDesignElement || change.getTargetElement() instanceof IRfInstanceElement) continue;
                return "An internal error has occurred(add port/generic): target element is not a component/instance";
            }
            return "An internal error has occurred: unknown refactoring operation";
        }
        return null;
    }

    public List<RefactorInputWrapper> allDirectModuleOrEntityDesigns(DVTNode rootNode, DVTNode srcNode, DVTNode dstNode, DVTRefactorConnectWizardInput userInput) {
        ArrayList<RefactorInputWrapper> result = new ArrayList<RefactorInputWrapper>();
        String inName = userInput.getVhdlInputPortName();
        String outName = userInput.getVhdlOutputPortName();
        String[] dirNames = new String[]{"out", "in"};
        String[] portNames = new String[]{outName, inName};
        int dir = 0;
        while (dir < 2) {
            DVTNode fromNode;
            DVTNode p = fromNode = dir == 0 ? srcNode : dstNode;
            while (p != rootNode) {
                if (p.instanceType != null) {
                    RefactorInputWrapper ch = this.makeDesignElementPortChangeWrapper(null, false, false, p.instanceType, portNames[dir], dirNames[dir], userInput.getVhdlSignalType(), userInput.getVhdlSignalWidth());
                    result.add(ch);
                }
                p = p.fParent;
            }
            ++dir;
        }
        return result;
    }

    public List<RefactorInputWrapper> allDirectModuleOrEntityDesigns(String[] rootNode, String[] srcNode, String[] dstNode, DVTRefactorConnectWizardInput userInput, IProject project) {
        ArrayList<RefactorInputWrapper> result = new ArrayList<RefactorInputWrapper>();
        String inName = userInput.getVhdlInputPortName();
        String outName = userInput.getVhdlOutputPortName();
        String[] dirNames = new String[]{"out", "in"};
        String[] portNames = new String[]{outName, inName};
        int dir = 0;
        while (dir < 2) {
            Object[] fromNode;
            Object[] p = fromNode = dir == 0 ? srcNode : dstNode;
            while (!Arrays.equals(p, rootNode)) {
                List instancesFor;
                IELMemory elMemory;
                IRfNamedElement element = DVTRefactorDesignElementUtils.getElementFromSegments((String[])p, (IProject)project);
                IRfNamedElement instanceType = null;
                if (element instanceof IRfInstanceElement && (elMemory = RfMixedLangManager.getInstance().getELMemory(project)) != null && (instancesFor = elMemory.getInstancesFor((IRfInstanceElement)element, 1)) != null && !instancesFor.isEmpty()) {
                    instanceType = ((ELInstance)instancesFor.get(0)).getBinding(true);
                }
                if (instanceType != null) {
                    RefactorInputWrapper ch = this.makeDesignElementPortChangeWrapper((String[])p, DVTRefactorDesignElementUtils.isOutput((String[])p, (String[])srcNode, (String[])dstNode), Arrays.equals(p, srcNode) || Arrays.equals(p, dstNode), instanceType, portNames[dir], dirNames[dir], userInput.getVhdlSignalType(), userInput.getVhdlSignalWidth());
                    result.add(ch);
                }
                p = DVTRefactorDesignElementUtils.subList((String[])p);
            }
            ++dir;
        }
        return result;
    }
}

