/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.designelement;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.PortConnectionOperatorVisitor;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlPositionalTooltipUtils;
import ro.amiq.vhdldt.ui.refactor.designelement.ParametersInfo;

public class VhdlRefactorRfInstanceWrapper {
    private RfInstance instance;
    private Map<IRfPortElement, Set<TCConnSignal>> portMap;
    private List<IHidOperator> portConnectionOperators;
    private boolean hasOrderedPortConnections;
    private List<IHidOperator> genericConnectionOperators;
    private boolean hasOrderedGenericConnections;
    private boolean hasGenericConnections;

    public VhdlRefactorRfInstanceWrapper(RfInstance instance) {
        this.instance = instance;
        DesignUtils.DesignRequest request = DesignUtils.DesignRequest.of((IRfNamedElement)instance, (boolean)true);
        IdentityHashMap dummyPortCache = new IdentityHashMap();
        this.portMap = DesignUtils.mapInstancePortConnections((DesignUtils.DesignRequest)request, dummyPortCache, (Set)DesignUtils.PORT_CONNECTION_HID_FLATTENING);
        this.portConnectionOperators = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)instance);
        this.hasOrderedPortConnections = this.checkOrderedPortConnections();
        ParametersInfo paramInfo = VhdlPositionalTooltipUtils.getOrderedGenericConnectionsInfo(instance, this.hasGenericConnections);
        this.hasGenericConnections = paramInfo.hasGenericConnections();
        this.hasOrderedGenericConnections = paramInfo.hasOrderedGenericConnections();
        this.genericConnectionOperators = paramInfo.getGenericConnectionOperators();
    }

    private boolean checkOrderedPortConnections() {
        List portConnectionsOperators = PortConnectionOperatorVisitor.getPortConnections((IRfNamedElement)this.instance);
        if (portConnectionsOperators == null || portConnectionsOperators.isEmpty()) {
            return false;
        }
        for (IHidOperator operator : portConnectionsOperators) {
            if (!PortConnectionUtils.isOrderedConnected((IHidOperator)operator) && !PortConnectionUtils.isOrderedUnconnected((IHidOperator)operator)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPortConnections() {
        return this.portMap != null && !this.portMap.isEmpty() || this.portConnectionOperators != null && !this.portConnectionOperators.isEmpty();
    }

    public boolean hasNamedPortConnections() {
        return !this.hasOrderedPortConnections;
    }

    public boolean hasNamedGenericConnections() {
        return !this.hasOrderedGenericConnections;
    }

    public IRfPortElement getLastPort() {
        if (this.portMap == null || this.portMap.isEmpty()) {
            return null;
        }
        Set<IRfPortElement> ports = this.portMap.keySet();
        Iterator<IRfPortElement> iterator = ports.iterator();
        IRfPortElement lastPort = null;
        while (iterator.hasNext()) {
            lastPort = iterator.next();
        }
        return lastPort;
    }

    public int getLastPortConnectionOffset() {
        if (this.portConnectionOperators == null || this.portConnectionOperators.isEmpty()) {
            return -1;
        }
        return Utils.getOperatorFirstOffset(this.portConnectionOperators, (int)(this.portConnectionOperators.size() - 1));
    }

    public int getLastGenericConnectionOffset() {
        if (this.genericConnectionOperators == null || this.genericConnectionOperators.isEmpty()) {
            return -1;
        }
        return Utils.getOperatorFirstOffset(this.genericConnectionOperators, (int)(this.genericConnectionOperators.size() - 1));
    }

    public Set<TCConnSignal> getConnectionsByPort(IRfPortElement port) {
        if (this.portMap == null || this.portMap.isEmpty()) {
            return Collections.emptySet();
        }
        return this.portMap.get(port);
    }

    public Map<IRfPortElement, Set<TCConnSignal>> getPortMap() {
        return this.portMap;
    }

    public RfInstance getInstance() {
        return this.instance;
    }

    public boolean hasOrderedGenericConnections() {
        return this.hasOrderedGenericConnections;
    }

    public void setHasOrderedGenericConnections(boolean hasOrderedGenericConnections) {
        this.hasOrderedGenericConnections = hasOrderedGenericConnections;
    }

    public boolean hasGenericConnections() {
        return this.hasGenericConnections;
    }

    public void setHasGenericConnections(boolean hasGenericConnections) {
        this.hasGenericConnections = hasGenericConnections;
    }
}

