/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.designelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.connect.DocManager;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorDesignElementUtils;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorRfInstanceWrapper;

public class VhdlRefactorTextChangeFactory {
    private DocManager fDocManager = new DocManager();

    public TextChange makeDesignElementTextChange(RefactorInputWrapper changeWrapper) {
        TextChange result = null;
        RefactorDesignElementOperation refactorOperation = changeWrapper.getRefactorOperation();
        if (changeWrapper.getTargetElement() instanceof RfComponent) {
            if (refactorOperation == RefactorDesignElementOperation.ADD_PORT) {
                result = this.makePortDesignElementTextChange((RfNamedElement)changeWrapper.getTargetElement(), changeWrapper);
            } else if (refactorOperation == RefactorDesignElementOperation.ADD_GENERIC) {
                result = this.makeGenericDesignElementTextChange(changeWrapper);
            }
        } else if (changeWrapper.getTargetElement() instanceof RfArchitecture) {
            if (refactorOperation == RefactorDesignElementOperation.ADD_WIRE) {
                result = this.addSignalToArchitectureTextChange((RfNamedElement)changeWrapper.getTargetElement(), "signal " + changeWrapper.getConnectionExpression() + " : " + changeWrapper.getType() + " " + VhdlRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"(", (String)")") + ";");
            }
        } else {
            throw new RuntimeException("Unknown tree change");
        }
        return result;
    }

    public List<TextChange> makeAllInstancesTextChanges(List<RefactorInputWrapper> changes, IProgressMonitor pm) {
        IFile file;
        ArrayList<TextChange> textChanges = new ArrayList<TextChange>();
        HashMap<IFile, ArrayList<RfNamedElement>> instancesPerFile = new HashMap<IFile, ArrayList<RfNamedElement>>();
        for (RefactorInputWrapper refactorInputWrapper : changes) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            file = (IFile)refactorInputWrapper.getTargetElement().getFileAdapter();
            ArrayList<RfNamedElement> val = (ArrayList<RfNamedElement>)instancesPerFile.get(refactorInputWrapper.getTargetElement().getFileAdapter());
            if (val == null) {
                val = new ArrayList<RfNamedElement>();
                instancesPerFile.put(file, val);
            }
            val.add((RfNamedElement)refactorInputWrapper.getTargetElement());
        }
        for (Map.Entry entry : instancesPerFile.entrySet()) {
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            file = (IFile)entry.getKey();
            List instances = (List)entry.getValue();
            List<VhdlRefactorRfInstanceWrapper> refactorInstaces = this.makeInstacesWrappersFromRfInstances(instances);
            for (VhdlRefactorRfInstanceWrapper refInst : refactorInstaces) {
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                RefactorInputWrapper change = this.getChangeWithTarget(changes, refInst.getInstance());
                if (change == null) continue;
                TextChange textChg = null;
                if (change.getRefactorOperation() == RefactorDesignElementOperation.ADD_PORT) {
                    textChg = this.makePortInstanceTextChangeInternal(file, refInst, change, change.isInsideBlock() ? " --FIXME: inside block\n" : "");
                } else if (change.getRefactorOperation() == RefactorDesignElementOperation.ADD_GENERIC) {
                    textChg = this.makeGenericInstanceTextChangeInternal(file, refInst, change, change.isInsideBlock() ? " --FIXME: inside block\n" : "");
                }
                if (textChg == null) continue;
                textChanges.add(textChg);
            }
        }
        return textChanges;
    }

    private TextChange addSignalToArchitectureTextChange(RfNamedElement architecture, String blockText) {
        try {
            TextChange ch;
            IDocument document = this.fDocManager.getDoc((IFile)architecture.getFileAdapter());
            if (document == null) {
                return null;
            }
            int architecturestartOffset = architecture.getStartOffset();
            if (architecturestartOffset < 0 || architecturestartOffset > document.getLength()) {
                return null;
            }
            int insertionOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "is", architecturestartOffset, architecturestartOffset + 100, false);
            if (insertionOffset < 0 || insertionOffset > document.getLength()) {
                return null;
            }
            String newLine = System.lineSeparator();
            String indent = DVTDocumentUtils.getIndent((int)architecturestartOffset, (IDocument)document);
            String text = String.valueOf(newLine) + indent + blockText + newLine + indent;
            TextChange textChange = ch = new TextChange((IFile)architecture.getFileAdapter(), insertionOffset, 0, text);
            return textChange;
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
    }

    private TextChange makePortDesignElementTextChange(RfNamedElement element, RefactorInputWrapper changeWrapper) {
        try {
            TextChange ch;
            int insertionOffset;
            if (element == null) {
                return null;
            }
            IDocument document = this.fDocManager.getDoc((IFile)element.getFileAdapter());
            if (document == null) {
                return null;
            }
            String width = VhdlRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"(", (String)")");
            String direction = changeWrapper.getDirection().isEmpty() ? "" : String.valueOf(changeWrapper.getDirection()) + " ";
            direction = VhdlQuickFixUtil.getInstance().getCorrectCase(direction, false);
            String type = VhdlQuickFixUtil.getInstance().getCorrectCase(changeWrapper.getType(), true);
            String text = String.valueOf(changeWrapper.getNewElementName()) + " : " + direction + type + width;
            RfDefElement elementDeclaration = element.getDeclaration();
            if (elementDeclaration == null) {
                return null;
            }
            int elementStartOffset = elementDeclaration.getStartOffset();
            int elementEndOffset = elementDeclaration.getEndOffset();
            if (elementStartOffset < 0 || elementEndOffset < 0) {
                return null;
            }
            List<RfPort> componentPorts = element.getPortsWithPrefix("", 2, true);
            boolean hasPorts = !componentPorts.isEmpty();
            List<? extends RfNamedElement> elementGenerics = null;
            if (element instanceof RfComponent) {
                elementGenerics = ((RfComponent)element).getLocalParameters();
            }
            boolean hasGenerics = elementGenerics != null && !elementGenerics.isEmpty();
            String indent = "";
            if (hasPorts) {
                RfDefElement portDeclaration = componentPorts.get(componentPorts.size() - 1).getDeclaration();
                if (portDeclaration == null) {
                    return null;
                }
                int lastPortOffset = portDeclaration.getEndOffset();
                if (lastPortOffset < 0) {
                    return null;
                }
                int bufferSize = elementDeclaration.getEndOffset() - lastPortOffset;
                int semicolonOffset = DVTDocumentUtils.getCharOffset((char)';', (int)lastPortOffset, (boolean)true, (int)bufferSize, (IDocument)document, (String)"__vhdl_partitioning");
                if (semicolonOffset < 0) {
                    return null;
                }
                insertionOffset = DVTDocumentUtils.getCharOffset((char)')', (int)semicolonOffset, (boolean)false, (int)bufferSize, (IDocument)document, (String)"__vhdl_partitioning") - 1;
                if (insertionOffset < 0) {
                    return null;
                }
                indent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)(lastPortOffset - 1), (int)elementStartOffset, (String)"__vhdl_partitioning");
                String insertionOffsetIndent = VhdlRefactorDesignElementUtils.getBracketIndent((int)(insertionOffset - 1), (IDocument)document);
                indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
                text = String.valueOf(indent) + "; " + text + insertionOffsetIndent;
            } else {
                int isWordOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "is", elementStartOffset, elementEndOffset, false);
                if (isWordOffset == 0 || isWordOffset == elementEndOffset) {
                    isWordOffset = elementStartOffset + element.getName().length();
                }
                String portKeyword = " port ";
                int portMapWordOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, portKeyword, isWordOffset, elementEndOffset, false);
                if (portMapWordOffset == 0 || portMapWordOffset == elementEndOffset) {
                    if (hasGenerics) {
                        int lastGenericOffset = this.getLastGenericOffset(elementGenerics);
                        if (lastGenericOffset < 0 || lastGenericOffset > document.getLength()) {
                            return null;
                        }
                        int genericBlockEndOffset = this.getGenericBlockEndOffset(lastGenericOffset, document);
                        if (genericBlockEndOffset < 0) {
                            return null;
                        }
                        insertionOffset = DVTDocumentUtils.getCharOffset((char)';', (int)genericBlockEndOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vhdl_partitioning") + 1;
                    } else {
                        insertionOffset = isWordOffset;
                    }
                    text = String.valueOf(VhdlQuickFixUtil.getInstance().getCorrectCase(portKeyword, false)) + "(" + text + ");";
                } else {
                    insertionOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)portMapWordOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vhdl_partitioning");
                }
            }
            if (insertionOffset < 0) {
                return null;
            }
            TextChange textChange = ch = new TextChange((IFile)element.getFileAdapter(), insertionOffset, 0, text);
            return textChange;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
    }

    private TextChange makeGenericDesignElementTextChange(RefactorInputWrapper changeWrapper) {
        try {
            TextChange ch;
            int insertionOffset;
            RfNamedElement element = (RfNamedElement)changeWrapper.getTargetElement();
            if (element == null) {
                return null;
            }
            IDocument document = this.fDocManager.getDoc((IFile)element.getFileAdapter());
            if (document == null) {
                return null;
            }
            String width = VhdlRefactorDesignElementUtils.wrapInBrackets((String)changeWrapper.getWidth(), (String)"(", (String)")");
            String genericValue = changeWrapper.getGenericDefaultValue().isEmpty() ? "" : " := " + changeWrapper.getGenericDefaultValue();
            String type = VhdlQuickFixUtil.getInstance().getCorrectCase(changeWrapper.getType(), true);
            String text = String.valueOf(changeWrapper.getNewElementName()) + " : " + type + width + genericValue;
            int elementStartOffset = element.getDeclaration().getStartOffset();
            int elementEndOffset = element.getDeclaration().getEndOffset();
            if (elementStartOffset < 0 || elementEndOffset < 0) {
                return null;
            }
            List<? extends RfNamedElement> elementGenerics = null;
            if (element instanceof RfComponent) {
                elementGenerics = ((RfComponent)element).getLocalParameters();
            }
            boolean hasGenerics = elementGenerics != null && !elementGenerics.isEmpty();
            String indent = "";
            if (elementGenerics != null && hasGenerics) {
                int lastGenericOffset = this.getLastGenericOffset(elementGenerics);
                if (lastGenericOffset < 0 || lastGenericOffset > document.getLength()) {
                    return null;
                }
                insertionOffset = this.getGenericBlockEndOffset(lastGenericOffset, document);
                if (insertionOffset < 0) {
                    return null;
                }
                indent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)lastGenericOffset, (int)elementStartOffset, (String)"__vhdl_partitioning");
                String insertionOffsetIndent = VhdlRefactorDesignElementUtils.getBracketIndent((int)(insertionOffset - 1), (IDocument)document);
                indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
                text = String.valueOf(indent) + "; " + text + insertionOffsetIndent;
            } else {
                String genericKeyword = " generic ";
                int genericMapWordOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, genericKeyword, elementStartOffset, elementEndOffset, false);
                indent = DVTDocumentUtils.getIndent((int)elementStartOffset, (IDocument)document);
                if (genericMapWordOffset == 0 || genericMapWordOffset == elementEndOffset) {
                    int maxOffsetLimit = elementStartOffset + 100;
                    insertionOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "is", elementStartOffset, maxOffsetLimit, false);
                    if (maxOffsetLimit == insertionOffset) {
                        insertionOffset = elementStartOffset + element.getName().length();
                    }
                    text = String.valueOf(VhdlQuickFixUtil.getInstance().getCorrectCase(genericKeyword, false)) + "(" + text + ");";
                } else {
                    insertionOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)genericMapWordOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vhdl_partitioning");
                }
            }
            if (insertionOffset < 0) {
                return null;
            }
            TextChange textChange = ch = new TextChange((IFile)element.getFileAdapter(), insertionOffset, 0, text);
            return textChange;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
    }

    private int getLastGenericOffset(Collection<? extends IRfNamedElement> elementGenerics) {
        Iterator<? extends IRfNamedElement> iterator = elementGenerics.iterator();
        IRfNamedElement lastGeneric = null;
        while (iterator.hasNext()) {
            lastGeneric = iterator.next();
        }
        if (lastGeneric == null) {
            return -1;
        }
        IRfDefElement declaration = lastGeneric.getDeclaration();
        if (declaration == null) {
            return -1;
        }
        return declaration.getEndOffset();
    }

    private int getGenericBlockEndOffset(int lastGenericOffset, IDocument document) throws BadLocationException, BadPartitioningException {
        if (lastGenericOffset < 0) {
            return -1;
        }
        int semicolonOffset = DVTDocumentUtils.getCharOffset((char)';', (int)(lastGenericOffset + 1), (boolean)true, (int)100, (IDocument)document, (String)"__vhdl_partitioning");
        if (semicolonOffset < 0) {
            return -1;
        }
        return DVTDocumentUtils.getCharOffset((char)')', (int)semicolonOffset, (boolean)false, (int)100, (IDocument)document, (String)"__vhdl_partitioning") - 1;
    }

    private TextChange makePortInstanceTextChangeInternal(IFile file, VhdlRefactorRfInstanceWrapper instanceWrapper, RefactorInputWrapper change, String fixme) {
        try {
            TextChange ch;
            String text = String.valueOf(change.getNewElementName()) + " => " + change.getConnectionExpression();
            RfInstance instance = instanceWrapper.getInstance();
            if (instance == null) {
                return null;
            }
            IDocument document = this.fDocManager.getDoc((IFile)instance.getFileAdapter());
            if (document == null) {
                return null;
            }
            int insertionOffset = -1;
            boolean hasPorts = instanceWrapper.hasPortConnections();
            String indent = "";
            if (hasPorts) {
                int lastPortOffset = instanceWrapper.getLastPortConnectionOffset();
                if (lastPortOffset < 0 || lastPortOffset > document.getLength()) {
                    return null;
                }
                insertionOffset = DVTDocumentUtils.getCharOffset((char)')', (int)lastPortOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vhdl_partitioning");
                if (insertionOffset < 0) {
                    return null;
                }
                indent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)lastPortOffset, (int)instance.getDeclaration().getStartOffset(), (String)"__vhdl_partitioning");
                String insertionOffsetIndent = VhdlRefactorDesignElementUtils.getBracketIndent((int)(insertionOffset - 1), (IDocument)document);
                indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
                text = String.valueOf(indent) + ", " + text + fixme + insertionOffsetIndent;
            } else {
                int instanceEndOffset = instance.getDeclaration().getEndOffset();
                int instanceStartOffset = instance.getDeclaration().getStartOffset();
                String portMapKeyword = "port map";
                int portMapOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, portMapKeyword, instanceStartOffset, instanceEndOffset, false);
                indent = DVTDocumentUtils.getIndent((int)instanceStartOffset, (IDocument)document);
                if (portMapOffset <= 0 || portMapOffset >= instanceEndOffset) {
                    insertionOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, ";", instanceStartOffset, instanceEndOffset, false);
                    text = String.valueOf(indent) + " " + VhdlQuickFixUtil.getInstance().getCorrectCase(portMapKeyword, false) + " (" + text + ")";
                } else {
                    insertionOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)portMapOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vhdl_partitioning") + 1;
                }
            }
            TextChange textChange = ch = new TextChange(file, insertionOffset, 0, text);
            return textChange;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
    }

    private TextChange makeGenericInstanceTextChangeInternal(IFile file, VhdlRefactorRfInstanceWrapper instanceWrapper, RefactorInputWrapper change, String fixme) {
        try {
            TextChange ch;
            String text = String.valueOf(change.getNewElementName()) + " => " + change.getConnectionExpression();
            RfInstance instance = instanceWrapper.getInstance();
            if (instance == null) {
                return null;
            }
            IDocument document = this.fDocManager.getDoc((IFile)instance.getFileAdapter());
            if (document == null) {
                return null;
            }
            int insertionOffset = -1;
            boolean hasGenerics = instanceWrapper.hasGenericConnections();
            boolean hasPorts = instanceWrapper.hasPortConnections();
            String indent = "";
            if (hasGenerics) {
                int lastGenericOffset = instanceWrapper.getLastGenericConnectionOffset();
                if (lastGenericOffset < 0) {
                    return null;
                }
                insertionOffset = DVTDocumentUtils.getCharOffset((char)')', (int)lastGenericOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vhdl_partitioning");
                if (insertionOffset < 0) {
                    return null;
                }
                indent = DVTRefactorDesignElementUtils.getPreviousElementIndent((IDocument)document, (int)lastGenericOffset, (int)instance.getDeclaration().getStartOffset(), (String)"__vhdl_partitioning");
                String insertionOffsetIndent = VhdlRefactorDesignElementUtils.getBracketIndent((int)(insertionOffset - 1), (IDocument)document);
                indent = DVTStringUtil.trimNumberOfWhitespacesFromBeginningOfString((String)indent, (int)insertionOffsetIndent.length());
                text = String.valueOf(indent) + ", " + text + fixme + insertionOffsetIndent;
            } else {
                int instanceEndOffset = instance.getDeclaration().getEndOffset();
                int instanceStartOffset = instance.getDeclaration().getStartOffset();
                if (instanceStartOffset < 0 || instanceEndOffset < 0) {
                    return null;
                }
                String genericMapKeyword = "generic map";
                int genericMapOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, genericMapKeyword, instanceStartOffset, instanceEndOffset, false);
                indent = DVTDocumentUtils.getIndent((int)instanceStartOffset, (IDocument)document);
                if (genericMapOffset <= 0 || genericMapOffset >= instanceEndOffset) {
                    int portMapOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "port map", instanceStartOffset, instanceEndOffset, false);
                    insertionOffset = hasPorts ? portMapOffset - "port map".length() : (portMapOffset >= 0 && portMapOffset < instanceEndOffset ? portMapOffset - "port map".length() : VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, ";", instanceStartOffset, instanceEndOffset, false));
                    text = String.valueOf(indent) + " " + VhdlQuickFixUtil.getInstance().getCorrectCase(genericMapKeyword, false) + " (" + text + ") " + fixme;
                } else {
                    insertionOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)genericMapOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vhdl_partitioning") + 1;
                }
            }
            if (insertionOffset < 0) {
                return null;
            }
            TextChange textChange = ch = new TextChange(file, insertionOffset, 0, text);
            return textChange;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
        finally {
            this.fDocManager.disconnectDocs();
        }
    }

    private RefactorInputWrapper getChangeWithTarget(List<RefactorInputWrapper> changes, RfNamedElement target) {
        for (RefactorInputWrapper change : changes) {
            if (change.getTargetElement() != target) continue;
            return change;
        }
        return null;
    }

    private List<VhdlRefactorRfInstanceWrapper> makeInstacesWrappersFromRfInstances(List<RfNamedElement> instances) {
        ArrayList<VhdlRefactorRfInstanceWrapper> instancesWrappers = new ArrayList<VhdlRefactorRfInstanceWrapper>();
        for (RfNamedElement instance : instances) {
            instancesWrappers.add(new VhdlRefactorRfInstanceWrapper((RfInstance)instance));
        }
        return instancesWrappers;
    }
}

