/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.rename;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.PortSignalEnum;
import ro.amiq.vhdldt.ui.refactor.rename.VhdlRenameRefactorInfo;

public class VhdlRenameADHRefactorInfo
extends VhdlRenameRefactorInfo {
    private boolean shouldGrayOutRenameInParentInstancesButton;
    private RenameAcrossHierarchyInfo renameADHinfo;

    public VhdlRenameADHRefactorInfo(IProject project, IRfNamedElementAndScope namedElementAndScope, ITextEditor editor) {
        super(project, namedElementAndScope, editor);
        this.shouldGrayOutRenameInParentInstancesButton = RfSearchUtils.getPortOrSignalEnum((IRfNamedElement)namedElementAndScope.getIRfNamedElement(), (IProject)project) == PortSignalEnum.SIGNAL_MATCH;
    }

    public boolean shouldGrayOutRenameInParentInstancesButton() {
        return this.shouldGrayOutRenameInParentInstancesButton;
    }

    public RenameAcrossHierarchyInfo getRenameADHInfo() {
        return this.renameADHinfo;
    }

    public void setRenameADHInfo(RenameAcrossHierarchyInfo renameADHinfo) {
        this.renameADHinfo = renameADHinfo;
    }

    public void setUserInput(int renameDepth, boolean matchingNames, boolean renameInParentInstances, boolean renameInSubInstances) {
        if (this.renameADHinfo == null) {
            return;
        }
        this.renameADHinfo.setUserInput(renameDepth, matchingNames, renameInParentInstances, renameInSubInstances);
    }

    public boolean validate() {
        IRfNamedElement startingElement = this.renameADHinfo.getStartingElement();
        if (startingElement == null) {
            return false;
        }
        IRfDefElement declaration = startingElement.getDeclaration();
        if (declaration == null || declaration.getName() == null) {
            return false;
        }
        List designInstances = this.renameADHinfo.getDesignInstances();
        if (designInstances == null || designInstances.isEmpty()) {
            return false;
        }
        for (IRfNamedElement designInstance : designInstances) {
            if (designInstance == null) {
                return false;
            }
            Collection declarations = designInstance.getDeclarations();
            if (declarations == null || declarations.isEmpty()) {
                return false;
            }
            for (IRfDefElement declr : declarations) {
                if (declr != null && declr.getName() != null) continue;
                return false;
            }
        }
        return true;
    }
}

