/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.rename;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.NameConflictStatus;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfGUIReferencesUtils;
import ro.amiq.vhdldt.ui.preferences.PrefConst;
import ro.amiq.vhdldt.ui.refactor.rename.VhdlRenameDelegate;
import ro.amiq.vhdldt.ui.search.text.FileMatch;

public class VhdlRenameAcrossDesignHierarchyDelegate
extends VhdlRenameDelegate {
    public VhdlRenameAcrossDesignHierarchyDelegate(DVTRenameRefactorInfo info) {
        super(info, false);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        return new RefactoringStatus();
    }

    @Override
    public void createChangesFor(IFile file, Match[] matches, CompositeChange rootChange, DVTTextFileChange textFileChange, boolean inComments) {
        DVTRenameRefactorInfo renameInfo = this.getRefactorInfo();
        String newName = renameInfo.getNewName();
        Map matchesPerInstance = RfReferencesUtils.getDotStarImplicitMatches((Match[])matches);
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            BaseFileMatch fileMatch;
            LineElement lineElement;
            Match match = matchArray[n2];
            if (match instanceof BaseFileMatch && (lineElement = (fileMatch = (BaseFileMatch)match).getLineElement()) != null && !newName.equals(lineElement.getSearchedElement())) {
                String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                IRfInstanceElement instance = fileMatch.getInstance();
                if (instance != null && fileMatch.isDotStarPortConnection() || fileMatch.isImplicitPortConnection()) {
                    List matchesOfInstance = (List)matchesPerInstance.get(instance);
                    if (matchesOfInstance != null) {
                        this.renameDotStarImplicitInstanceConnection(renameInfo, matchesOfInstance, textFileChange, matchString, instance);
                        matchesPerInstance.remove(instance);
                    }
                } else if (fileMatch.isInsideMacroCall()) {
                    InsertEdit insertEdit = RfReferencesUtils.createCommentForMacroHit((BaseFileMatch)fileMatch, (DVTRenameRefactorInfo)renameInfo, (IRfNamedElement)lineElement.getNamedElement());
                    VHDLRfGUIReferencesUtils.handleHitInsideMacroCall((DVTTextFileChange)textFileChange, (InsertEdit)insertEdit, (String)matchString);
                } else if (fileMatch.isRenamed()) {
                    ReplaceEdit replaceEdit = new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), newName);
                    textFileChange.addEdit((TextEdit)replaceEdit);
                    boolean sideEffectMatch = VHDLRfGUIReferencesUtils.isSideEffectMatch((RenameAcrossHierarchyInfo)renameInfo.getRenameADHInfo(), (BaseFileMatch)fileMatch);
                    GroupCategorySet gcs = sideEffectMatch ? SIDE_EFFECT_MATCH : (fileMatch.isPossibleMatch() ? POTENTIAL_MATCH : (inComments ? CHANGES_IN_COMMENTS : SEMANTIC_CHANGES));
                    TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(matchString, (TextEdit)replaceEdit, gcs));
                    textFileChange.addTextEditChangeGroup(textEditChangeGroup);
                }
            }
            ++n2;
        }
    }

    @Override
    public void addEdit(DVTTextFileChange textFileChange, BaseFileMatch fileMatch, String newConnection, String matchString, IRegion track) {
        ReplaceEdit replaceEdit = new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), newConnection);
        textFileChange.addEdit((TextEdit)replaceEdit, track);
        boolean insideBreadCrumb = VHDLRfGUIReferencesUtils.isSideEffectMatch((RenameAcrossHierarchyInfo)this.getRefactorInfo().getRenameADHInfo(), (BaseFileMatch)fileMatch);
        GroupCategorySet gcs = insideBreadCrumb ? SIDE_EFFECT_MATCH : (fileMatch.isPossibleMatch() ? POTENTIAL_MATCH : GroupCategorySet.NONE);
        TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)textFileChange, (TextEditGroup)new CategorizedTextEditGroup(matchString, (TextEdit)replaceEdit, gcs));
        textFileChange.addTextEditChangeGroup(textEditChangeGroup);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext ctxt) {
        Collection renamedMatches;
        pm.setTaskName("Computing matches...");
        RefactoringStatus result = new RefactoringStatus();
        final IProject project = this.getRefactorInfo().getProject();
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        String[] fileExtensions = null;
        try {
            fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        FileTextSearchScope.newSearchScope((IResource[])new IResource[]{this.getRefactorInfo().getResourceSearchScope()}, (String[])fileExtensions, (boolean)false);
        IRfNamedElement namedElement = this.getRefactorInfo().getElement();
        final HashSet allMatches = new HashSet();
        final HashMap renameMatches = new HashMap();
        IReportHitsListener<SearchHit> renameAcrossHierarchyHitsListener = new IReportHitsListener<SearchHit>(){

            public void addMatch(SearchHit match) {
                try {
                    ParserPath parserPath = match.getParserPath();
                    IFile file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
                    LineElement element = new LineElement((IResource)file, match.getLine(), match.getOffset(), match.getContents(), match.getNamedElement());
                    element.setExtraInfo(match.getExtraInfo());
                    element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                    element.setWriteAccess(match.getAccess());
                    int matchLength = match.getMatchLength();
                    FileMatch fileMatch = new FileMatch(file, match.getOffset(), matchLength, match.isPossibleMatch(), element, match.isInsideMacroCall(), match.isRenamed());
                    fileMatch.setHitType(match.getHitType());
                    IRfInstanceElement instance = match.getInstance();
                    fileMatch.setInstance(instance);
                    fileMatch.setConnectedElement(match.getConnectedElement());
                    fileMatch.setLeftRightHandSideOfConnection(match.getLeftRightHandSideOfConnection());
                    if (instance != null) {
                        fileMatch.setScopeDef(instance.getDeclaration());
                    } else {
                        fileMatch.setScopeDef(RfSearchUtils.getScope((IProject)project, (ParserPath)parserPath, (int)match.getLine(), (int)match.getOffset()));
                    }
                    if (allMatches.contains(match)) {
                        return;
                    }
                    allMatches.add(match);
                    RfSearchUtils.addMatchesForRename((Map)renameMatches, (BaseFileMatch)fileMatch, (IFile)file);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public Set<SearchHit> getMatches() {
                return allMatches;
            }
        };
        RenameAcrossHierarchyInfo renameADHInfo = this.getRefactorInfo().getRenameADHInfo();
        RfSearchUtils.searchAcrossDesignHierarchy((IRfNamedElement)namedElement, (RenameAcrossHierarchyInfo)renameADHInfo, (IReportHitsListener)renameAcrossHierarchyHitsListener, (IProject)project, (IProgressMonitor)(pm == null ? new NullProgressMonitor() : pm), (boolean)true, (boolean)true, (boolean)true);
        HashMap<IResource, Match[]> matches = new HashMap<IResource, Match[]>();
        for (Map.Entry entry : renameMatches.entrySet()) {
            matches.put((IResource)entry.getKey(), (Match[])((List)entry.getValue()).toArray(new BaseFileMatch[0]));
        }
        this.getRefactorInfo().setMatches(matches);
        if (!TestHelper.isTestMode()) {
            VHDLRfGUIReferencesUtils.computeAmbiguityWarnings((RenameAcrossHierarchyInfo)renameADHInfo, (RefactoringStatus)result, (IProject)project);
            VHDLRfGUIReferencesUtils.computeConflictingWarnings((RenameAcrossHierarchyInfo)renameADHInfo, (RefactoringStatus)result, (IProject)project);
        }
        if ((renamedMatches = matches.values()) == null || renamedMatches.isEmpty()) {
            return result;
        }
        String newName = this.getRefactorInfo().getNewName();
        HashSet<String> existingDuplicateMatches = new HashSet<String>();
        Collection ambiguousElements = renameADHInfo.getAmbiguityCases().values();
        for (Match[] matchs : renamedMatches) {
            if (matchs == null || matchs.length == 0) continue;
            Match[] matchArray = matchs;
            int n = matchs.length;
            int n2 = 0;
            while (n2 < n) {
                IRfNamedElement namedElementMatch;
                BaseFileMatch baseFileMatch;
                LineElement lineElement;
                Match match = matchArray[n2];
                if (match instanceof BaseFileMatch && (lineElement = (baseFileMatch = (BaseFileMatch)match).getLineElement()) != null && (namedElementMatch = lineElement.getNamedElement()) != null && !newName.equals(lineElement.getSearchedElement())) {
                    List candidates;
                    IStatus checkOtherElements = RfSearchUtils.getConflictingStatus((String)newName, (IProject)this.getRefactorInfo().getProject(), (IRfNamedElement)namedElementMatch, (IRfScopeElement)namedElementMatch.getEnclosingScope());
                    if (checkOtherElements instanceof NameConflictStatus && (candidates = ((NameConflictStatus)checkOtherElements).getCandidates()) != null && !candidates.contains(namedElementMatch)) {
                        String duplicateMessage = RfSearchUtils.getDuplicateElementsMessage((IRfNamedElement)namedElementMatch, (IProject)this.getRefactorInfo().getProject(), (List)candidates);
                        if (duplicateMessage == null || existingDuplicateMatches.contains(duplicateMessage)) {
                            baseFileMatch.setIsRenamed(false);
                        } else {
                            existingDuplicateMatches.add(duplicateMessage);
                            RefactoringStatusContext nameConflictContext = VHDLRfGUIReferencesUtils.computeContext((NameConflictStatus)((NameConflictStatus)checkOtherElements));
                            if (!TestHelper.isTestMode()) {
                                result.addWarning(duplicateMessage, nameConflictContext);
                            }
                            baseFileMatch.setIsRenamed(false);
                        }
                    } else if (baseFileMatch.isRenamed()) {
                        VHDLRfGUIReferencesUtils.checkAmbiguousMatch(ambiguousElements, (BaseFileMatch)baseFileMatch);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public IStatus checkNewNameInternal(DVTRenameRefactorInfo refactorInfo) {
        String newName = refactorInfo.getNewName();
        if (newName == null) {
            return Status.OK_STATUS;
        }
        IRfNamedElement element = refactorInfo.getElement();
        if (element == null) {
            return Status.OK_STATUS;
        }
        newName = newName.toLowerCase();
        IRfDefElement defElement = element.getDeclaration();
        if (!(defElement instanceof RfDefElement)) {
            return Status.OK_STATUS;
        }
        if (((RfDefElement)defElement).getLanguageSyntax() != IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008) {
            return Status.OK_STATUS;
        }
        String[] words = PrefConst.getVhdlKeywords2008();
        int i = 0;
        while (i < words.length) {
            if (words[i].equals(newName)) {
                return new Status(4, "ro.amiq.vhdldt", "New name is a VHDL 2008 keyword.");
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

