/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.rename;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.search.ui.text.Match;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfReferencesUtils;
import ro.amiq.vhdldt.ui.preferences.PrefConst;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;
import ro.amiq.vhdldt.ui.refactor.rename.VhdlRenameRefactorInfo;
import ro.amiq.vhdldt.ui.search.text.FileMatch;

public abstract class VhdlRenameDelegateCommon
extends DVTRenameDelegate {
    protected VhdlRenameDelegateCommon(DVTRenameRefactorInfo info, boolean useScopeInfo) {
        super(info, useScopeInfo);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) {
        RefactoringStatus result = new RefactoringStatus();
        final IProject project = this.getRefactorInfo().getProject();
        IRfNamedElement namedElement = this.getRefactorInfo().getElement();
        final HashSet allMatches = new HashSet();
        final HashMap renameMatches = new HashMap();
        IReportHitsListener<SearchHit> renameAcrossHierarchyHitsListener = new IReportHitsListener<SearchHit>(){

            public void addMatch(SearchHit match) {
                try {
                    ParserPath parserPath = match.getParserPath();
                    IFile file = DVTFileUtils.getInstance().findProjectFile(match.getProject(), parserPath.path);
                    if (file == null) {
                        return;
                    }
                    LineElement element = new LineElement((IResource)file, match.getLine(), match.getOffset(), match.getContents(), match.getNamedElement());
                    element.setExtraInfo(match.getExtraInfo());
                    element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                    element.setWriteAccess(match.getAccess());
                    int matchLength = match.getMatchLength();
                    FileMatch fileMatch = new FileMatch(file, match.getOffset(), matchLength, match.isPossibleMatch(), element, match.isInsideMacroCall(), match.isRenamed());
                    fileMatch.setHitType(match.getHitType());
                    fileMatch.setInstance(match.getInstance());
                    fileMatch.setConnectedElement(match.getConnectedElement());
                    fileMatch.setLeftRightHandSideOfConnection(match.getLeftRightHandSideOfConnection());
                    fileMatch.setIsElaborationHit(match.isElaborationHit());
                    if (match.getInstance() != null) {
                        fileMatch.setScopeDef(match.getInstance().getDeclaration());
                    } else {
                        fileMatch.setScopeDef(RfSearchUtils.getScope((IProject)project, (ParserPath)parserPath, (int)match.getLine(), (int)match.getOffset()));
                    }
                    if (allMatches.contains(match)) {
                        return;
                    }
                    allMatches.add(match);
                    RfSearchUtils.addMatchesForRename((Map)renameMatches, (BaseFileMatch)fileMatch, (IFile)file);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public Set<SearchHit> getMatches() {
                return allMatches;
            }
        };
        HashMap hashMap = new HashMap();
        IProgressMonitor monitor = pm == null ? new NullProgressMonitor() : pm;
        FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles(hashMap), monitor);
        RfSearchUtils.computeReferences((IReportHitsListener)renameAcrossHierarchyHitsListener, (IProject)project, (IRfNamedElement)namedElement, null, (String)namedElement.getName(), (IProgressMonitor)monitor, hashMap, (FileSynchedAndAvailableManager)fileManager, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)false);
        DVTRenameRefactorInfo refactorInfo = this.getRefactorInfo();
        if (refactorInfo instanceof VhdlRenameRefactorInfo && RfSearchUtils.isPortOrParameterElement((IRfNamedElement)namedElement)) {
            IRfNamedElement elabElement;
            ITextEditor editor = ((VhdlRenameRefactorInfo)refactorInfo).getEditor();
            int offset = ((VhdlRenameRefactorInfo)refactorInfo).getOffset();
            if (editor instanceof DVTEditor && !namedElement.checkEquals((Object)(elabElement = RfSearchUtils.getElementToSearch((IRfNamedElement)namedElement, (IRfScopeElement)refactorInfo.getScope(), (DVTEditor)((DVTEditor)editor), (int)offset)))) {
                RfSearchUtils.computeReferences((IReportHitsListener)renameAcrossHierarchyHitsListener, (IProject)project, (IRfNamedElement)elabElement, null, (String)elabElement.getName(), (IProgressMonitor)monitor, hashMap, (FileSynchedAndAvailableManager)fileManager, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
            }
        }
        HashMap<IResource, Match[]> matches = new HashMap<IResource, Match[]>();
        for (Map.Entry entry : renameMatches.entrySet()) {
            matches.put((IResource)entry.getKey(), (Match[])((List)entry.getValue()).toArray(new BaseFileMatch[0]));
        }
        this.getRefactorInfo().setMatches(matches);
        return result;
    }

    public void createChangesFor(IFile file, Match[] matches, CompositeChange rootChange, DVTTextFileChange textFileChange, boolean inComments) {
        DVTRenameRefactorInfo renameInfo = this.getRefactorInfo();
        Map matchesPerInstance = VHDLRfReferencesUtils.getDotStarImplicitMatches((Match[])matches);
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            BaseFileMatch fileMatch;
            Match match = matchArray[n2];
            if (match instanceof BaseFileMatch && !(fileMatch = (BaseFileMatch)match).isElaborationHit()) {
                String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                IRfInstanceElement instance = fileMatch.getInstance();
                if (instance != null && fileMatch.isDotStarPortConnection() || fileMatch.isImplicitPortConnection()) {
                    List matchesOfInstance = (List)matchesPerInstance.get(instance);
                    if (matchesOfInstance != null) {
                        this.renameDotStarImplicitInstanceConnection(renameInfo, matchesOfInstance, textFileChange, matchString, instance);
                        matchesPerInstance.remove(instance);
                    }
                } else if (fileMatch.isInsideMacroCall()) {
                    InsertEdit insertEdit = VHDLRfReferencesUtils.createCommentForMacroHit((BaseFileMatch)fileMatch, (DVTRenameRefactorInfo)renameInfo, (IRfNamedElement)this.getRefactorInfo().getElement());
                    RfGUIReferencesUtils.handleHitInsideMacroCall((DVTTextFileChange)textFileChange, (InsertEdit)insertEdit, (String)matchString);
                } else if (!fileMatch.isElaborationHit()) {
                    this.addEdit(textFileChange, fileMatch, this.getRefactorInfo().getNewName(fileMatch.isEscaped()), matchString, (IRegion)new Region(0, fileMatch.getLength()), inComments);
                }
            }
            ++n2;
        }
    }

    protected DVTTextFileChange getTextFileChange(IFile file) {
        return new VhdlTextFileChange(file.getName(), file);
    }

    public IStatus checkNewNameInternal(DVTRenameRefactorInfo refactorInfo) {
        String newName = refactorInfo.getNewName();
        if (newName == null) {
            return Status.OK_STATUS;
        }
        IRfNamedElement element = refactorInfo.getElement();
        if (element == null) {
            return Status.OK_STATUS;
        }
        newName = newName.toLowerCase();
        IRfDefElement defElement = element.getDeclaration();
        if (!(defElement instanceof RfDefElement)) {
            return Status.OK_STATUS;
        }
        if (((RfDefElement)defElement).getLanguageSyntax() != IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008) {
            return Status.OK_STATUS;
        }
        String[] words = PrefConst.getVhdlKeywords2008();
        int i = 0;
        while (i < words.length) {
            if (words[i].equals(newName)) {
                return new Status(4, "ro.amiq.vhdldt", "New name is a VHDL 2008 keyword.");
            }
            ++i;
        }
        IRfScopeElement enclosingScope = element.getEnclosingScope();
        if (!(enclosingScope instanceof IRfNamedElement)) {
            return Status.OK_STATUS;
        }
        return VHDLRfReferencesUtils.checkOtherElements(newName, element, (IRfNamedElement)enclosingScope);
    }

    protected abstract void addEdit(DVTTextFileChange var1, BaseFileMatch var2, String var3, String var4, IRegion var5, boolean var6);
}

