/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.refactor.rename;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.ui.search.text.FileMatch;

public class VhdlRenameRefactorInfoCommon
extends DVTRenameRefactorInfo {
    protected IRfNamedElementAndScope fNamedElementAndScope;
    protected ITextEditor fEditor;
    protected int fOffset = -1;

    public VhdlRenameRefactorInfoCommon(IProject project, IRfNamedElementAndScope namedElementAndScope, ITextEditor editor) {
        super(project);
        this.fNamedElementAndScope = namedElementAndScope;
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fOffset = ((DVTEditor)this.fEditor).getCursor();
        }
    }

    public String getOldName() {
        IRfNamedElement namedElement = this.getElement();
        if (namedElement == null) {
            return "";
        }
        return namedElement.getName();
    }

    public String getOldSignature() {
        IRfNamedElement namedElement = this.getElement();
        if (namedElement == null) {
            return "";
        }
        return DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)namedElement.getSignature(), (String)" ");
    }

    public boolean hasPotentialMatches() {
        if (this.getMatches() == null) {
            return false;
        }
        Iterator iterator = this.getMatches().values().iterator();
        while (iterator.hasNext()) {
            Match[] fileMatches;
            Match[] matchArray = fileMatches = (Match[])iterator.next();
            int n = fileMatches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (match instanceof FileMatch && ((FileMatch)match).isPossibleMatch()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IRfScopeElement getScope() {
        return this.fNamedElementAndScope == null ? null : this.fNamedElementAndScope.getScope();
    }

    public IRfNamedElement getElement() {
        return this.fNamedElementAndScope == null ? null : this.fNamedElementAndScope.getIRfNamedElement();
    }

    public ITextEditor getEditor() {
        return this.fEditor;
    }

    public int getOffset() {
        return this.fOffset;
    }
}

