/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class MultipleSearchTextFileBufferManager {
    private static boolean fActive;
    private static Collection<IPath> fManagedFiles;

    static {
        fManagedFiles = new ArrayList<IPath>();
    }

    public static void activate() {
        if (fActive) {
            throw new IllegalStateException("MultipleSearchTextFileBufferManager already activated!");
        }
        fActive = true;
    }

    public static void deactivate() throws CoreException {
        if (!fActive) {
            throw new IllegalStateException("MultipleSearchTextFileBufferManager already de-activated!");
        }
        fActive = false;
        ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
        if (textFileBufferManager == null) {
            throw new IllegalStateException("FileBuffers plugin not active!");
        }
        for (IPath path : fManagedFiles) {
            textFileBufferManager.disconnect(path, LocationKind.NORMALIZE, null);
        }
        fManagedFiles.clear();
    }

    public static boolean manage(IPath fullPath) {
        if (fActive) {
            fManagedFiles.add(fullPath);
        }
        return fActive;
    }
}

