/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search;

import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.ISearchQueryElement;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;

public class RfSearchQueryElement
extends RfNamedElement
implements ISearchQueryElement {
    private static final long serialVersionUID = 1L;
    private int fType;

    public RfSearchQueryElement(int type, String name) {
        super(name);
        this.fType = type;
    }

    public String getSignature() {
        return null;
    }

    protected boolean isFunction() {
        return this.fType == 1;
    }

    protected boolean isProcedure() {
        return this.fType == 5;
    }

    protected boolean isSignal() {
        return this.fType == 2;
    }

    protected boolean isConstant() {
        return this.fType == 7;
    }

    protected boolean isComponent() {
        return this.fType == 3;
    }

    protected boolean isType() {
        return this.fType == 0;
    }

    protected boolean isPort() {
        return this.fType == 4;
    }

    public boolean isEntity() {
        return this.fType == 6;
    }

    public boolean isSubtype() {
        return this.fType == 9;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.vhdldt.templates.contextType.unknown";
    }

    public int getType() {
        return this.fType;
    }

    public String getStringType() {
        if (this.isFunction()) {
            return "function";
        }
        if (this.isProcedure()) {
            return "procedure";
        }
        if (this.isComponent()) {
            return "component";
        }
        if (this.isConstant()) {
            return "constant";
        }
        if (this.isType()) {
            return "type";
        }
        if (this.isPort()) {
            return "port";
        }
        if (this.isEntity()) {
            return "entity";
        }
        return "";
    }

    @Override
    public RfProject getRfProject() {
        try {
            Assert.isTrue((boolean)false, (String)"This call returns null, should not use.");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    @Override
    public String getFullNameLabel() {
        return this.getName() + (this.fType == 5 || this.fType == 1 ? "()" : "");
    }
}

