/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.search.BaseSearchQueryProvider;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.SearchManager;
import ro.amiq.dvt.ui.search.TextSearchPageInput;
import ro.amiq.vhdldt.ui.search.DeclarationsSearchQuery;
import ro.amiq.vhdldt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vhdldt.ui.search.new_engine.ReferenceHidSearchQuery;
import ro.amiq.vhdldt.ui.search.text.FileSearchQuery;

public class SearchQueryProvider
extends BaseSearchQueryProvider {
    private int fLimitTo;
    private int fSearchFor;
    private boolean fIncludeDeclarations;
    private boolean fOnlyCompiled;
    private RWSearchTypeEnum fSearchRWType;

    public SearchQueryProvider(int limitTo, int searchFor, boolean includeDeclarations, boolean isOnlyCompiled, RWSearchTypeEnum searchRWType) {
        this.fLimitTo = limitTo;
        this.fSearchFor = searchFor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fOnlyCompiled = isOnlyCompiled;
        SearchManager.getInstance().getPositionTracker();
        this.fSearchRWType = searchRWType;
    }

    public ISearchQuery createQuery(TextSearchQueryProvider.TextSearchInput input) {
        boolean wholeWord;
        FileTextSearchScope scope = input.getScope();
        String text = input.getSearchText();
        boolean regEx = input.isRegExSearch();
        boolean caseSensitive = input.isCaseSensitiveSearch();
        boolean bl = wholeWord = regEx ? false : ((TextSearchPageInput)input).isWholeWordSearch();
        if (input instanceof ReferenceSearchPageInput) {
            IRfNamedElement element = ((ReferenceSearchPageInput)input).getRfElement();
            IProject project = this.getProject(element, input);
            String searchLabel = element.getFullNameLabel();
            return new ReferenceHidSearchQuery(project, this.getSearchType(element), element, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fSearchFor, this.fSearchRWType, ((ReferenceSearchPageInput)input).getEditor(), ((ReferenceSearchPageInput)input).getfOffset(), ((ReferenceSearchPageInput)input).getScopeElement());
        }
        String searchLabel = text;
        if (this.fSearchFor == 5 || this.fSearchFor == 1) {
            searchLabel = String.valueOf(searchLabel) + "()";
        }
        if (this.fLimitTo == 0) {
            return new DeclarationsSearchQuery(this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fOnlyCompiled, this.fSearchFor);
        }
        return new FileSearchQuery(this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fOnlyCompiled, this.fSearchFor);
    }

    protected String getSearchType() {
        switch (this.fSearchFor) {
            case 0: {
                return "Type";
            }
            case 3: {
                return "Component";
            }
            case 2: {
                return "Signal";
            }
            case 7: {
                return "Constant";
            }
            case 1: {
                return "Function";
            }
            case 5: {
                return "Procedure";
            }
            case 4: {
                return "Port";
            }
            case 6: {
                return "Entity";
            }
        }
        return "Text";
    }
}

