/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.search.DocumentCharSequence;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;

public class TextSearchVisitor {
    public static final int BUFFER_SIZE = 524288;
    private final TextSearchRequestor fCollector;
    private final Matcher fMatcher;
    private Map<IFile, IDocument> fDocumentsInEditors;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private final MultiStatus fStatus;
    private final ReusableMatchAccess fMatchAccess;
    private boolean fRemoveComments;
    private boolean fOnlyCompiled;

    public TextSearchVisitor(TextSearchRequestor collector, Pattern searchPattern, boolean removeComments, boolean onlyCompiled) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher("");
        this.fRemoveComments = removeComments;
        this.fMatchAccess = new ReusableMatchAccess();
        this.fOnlyCompiled = onlyCompiled;
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles;
            {
                this.fLastNumberOfScannedFiles = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = TextSearchVisitor.this.fCurrentFile;
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, TextSearchVisitor.this.fNumberOfScannedFiles, TextSearchVisitor.this.fNumberOfFilesToScan};
                        TextSearchVisitor.this.fProgressMonitor.subTask(MessageFormat.format(SearchMessages.TextSearchVisitor_scanning, args));
                        int steps = TextSearchVisitor.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        TextSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            MultiStatus multiStatus;
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : MessageFormat.format(SearchMessages.TextSearchVisitor_textsearch_task_label, this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processFiles(files);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private void processFiles(IFile[] files) {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
        int i = 0;
        while (i < files.length) {
            boolean res;
            RfFileDef file;
            RfProject rfProject;
            IProject project;
            this.fCurrentFile = files[i];
            if (this.fCurrentFile != null && this.fCurrentFile.getLocation() != null && (project = this.fCurrentFile.getProject()) != null && (!this.fOnlyCompiled || (rfProject = RfManager.getInstance().getRfProject(project)) != null && (file = rfProject.getFile((IResource)this.fCurrentFile)) != null) && !(res = this.processFile(this.fCurrentFile))) break;
            ++i;
        }
        this.fDocumentsInEditors = null;
    }

    private Map<IFile, IDocument> evalNonFileBufferDocuments() {
        HashMap<IFile, IDocument> result = new HashMap<IFile, IDocument>();
        IWorkbench workbench = VhdlPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map<IFile, IDocument> result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            LocationKind locationKind;
            TextFileBufferInfo textFileBufferInfo;
            IPath path;
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean processFile(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBinaryContent(CharSequence seq, IFile file) throws CoreException {
        IContentType contentType;
        if (!DVTFileUtils.getInstance().ensureFileInSyncWithUserAccept((IResource)file, this.fProgressMonitor)) {
            return true;
        }
        IContentDescription desc = file.getContentDescription();
        if (desc != null && (contentType = desc.getContentType()) != null && contentType.isKindOf(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) {
            return false;
        }
        try {
            int limit = 524288;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    private void locateMatches(IFile file, DocumentCharSequence searchInput) throws CoreException {
        try {
            if (!DVTFileUtils.getInstance().ensureFileInSyncWithUserAccept((IResource)file, this.fProgressMonitor)) {
                return;
            }
            this.fMatcher.reset((CharSequence)searchInput);
            int k = 0;
            while (this.fMatcher.find()) {
                int start = this.fMatcher.start();
                int end = this.fMatcher.end();
                RfMixedLangManager.getInstance().installPartitionerForFile(file, searchInput.getDocument());
                if (end != start && searchInput.notInComment(start)) {
                    this.fMatchAccess.initialize(file, start, end - start, (CharSequence)searchInput);
                    boolean res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                    if (!res) {
                        return;
                    }
                }
                if (k++ != 20) continue;
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
                }
                k = 0;
            }
        }
        finally {
            this.fMatchAccess.initialize(null, 0, 0, "");
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        LocationKind locationKind;
        TextFileBufferInfo textFileBufferInfo;
        IPath path;
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public int getMatchOffset() {
            return this.fOffset;
        }

        public int getMatchLength() {
            return this.fLength;
        }

        public int getFileContentLength() {
            return this.fContent.length();
        }

        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }
}

