/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search;

import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentCharSequence;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.ui.search.TextSearchVisitor;

public class TypeSearchVisitor {
    private final TextSearchRequestor fCollector;
    private Matcher fMatcher;
    private IProgressMonitor fProgressMonitor;
    private Map<IFile, IDocument> fDocumentsInEditors;
    private int fNumberOfScannedProjects;
    private int fNumberOfProjectsToScan;
    private IProject fCurrentProject;
    private int fCheckForQueryInterruptionCounter = 0;
    private final MultiStatus fStatus;
    private int fSearchFor;
    private boolean fIncludeDeclarations;
    private TextSearchVisitor.ReusableMatchAccess fMatchAccess;
    private String fSearchPackage = null;
    private String fSearchType;
    private String[] fSearchStructs = null;

    public TypeSearchVisitor(TextSearchRequestor collector, Pattern searchPattern, String searchType, int searchFor, boolean includeDeclarations) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher("");
        this.fSearchFor = searchFor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fMatchAccess = new TextSearchVisitor.ReusableMatchAccess();
        this.fSearchType = searchType;
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedProjects = 0;
        HashMap<String, IProject> projectsList = new HashMap<String, IProject>();
        int i = 0;
        while (i < files.length) {
            IProject project = files[i].getProject();
            if (!projectsList.containsKey(project.getName())) {
                projectsList.put(project.getName(), project);
            }
            ++i;
        }
        this.fNumberOfProjectsToScan = projectsList.size();
        this.fCurrentProject = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedProjects;
            {
                this.fLastNumberOfScannedProjects = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IProject project = TypeSearchVisitor.this.fCurrentProject;
                    if (project != null) {
                        String projectName = project.getName();
                        Object[] args = new Object[]{projectName, TypeSearchVisitor.this.fNumberOfScannedProjects, TypeSearchVisitor.this.fNumberOfProjectsToScan};
                        TypeSearchVisitor.this.fProgressMonitor.subTask(MessageFormat.format(SearchMessages.TextSearchVisitor_scanning, args));
                        int steps = TypeSearchVisitor.this.fNumberOfScannedProjects - this.fLastNumberOfScannedProjects;
                        TypeSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedProjects += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.fSearchPackage = null;
        this.fSearchStructs = null;
        String[] tempMatchPatterns = DVTStringUtil.split((Pattern)DVTStringUtil.BACKSLASH_DOT, (String)this.fMatcher.pattern().pattern());
        if (tempMatchPatterns.length == 1) {
            if ((tempMatchPatterns = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)tempMatchPatterns[0])).length == 2) {
                this.fSearchPackage = tempMatchPatterns[0];
                this.fMatcher = Pattern.compile(tempMatchPatterns[1], 2).matcher("");
            }
        } else if (tempMatchPatterns.length > 1) {
            int index = tempMatchPatterns[0].indexOf("::");
            if (tempMatchPatterns.length > 0 && index > 0) {
                this.fSearchPackage = tempMatchPatterns[0].substring(0, index);
                tempMatchPatterns[0] = tempMatchPatterns[0].substring(index + 2);
            }
            this.fSearchStructs = new String[tempMatchPatterns.length - 1];
            int i2 = 0;
            while (i2 < tempMatchPatterns.length - 1) {
                this.fSearchStructs[i2] = tempMatchPatterns[tempMatchPatterns.length - 2 - i2];
                ++i2;
            }
            this.fMatcher = Pattern.compile(tempMatchPatterns[tempMatchPatterns.length - 1], 2).matcher("");
        }
        try {
            MultiStatus multiStatus;
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : MessageFormat.format(SearchMessages.TextSearchVisitor_hidssearch_task_label, this.fSearchType.toLowerCase(), this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfProjectsToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processProjects(projectsList);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private void processProjects(HashMap<String, IProject> projectsList) {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
        Collection<IProject> projects = projectsList.values();
        for (IProject this.fCurrentProject : projects) {
            boolean res = this.processProject(this.fCurrentProject);
            if (!res) break;
        }
    }

    private boolean processProject(IProject currentProject) {
        try {
            RfProject rfProject = RfManager.getInstance().getRfProject(currentProject);
            if (rfProject == null) {
                return true;
            }
            switch (this.fSearchFor) {
                case 0: {
                    boolean bl = this.locateMatches(rfProject.getAllTypes(false, false), currentProject);
                    return bl;
                }
                case 9: {
                    boolean bl = this.locateMatches(rfProject.getAllTypes(true, false), currentProject);
                    return bl;
                }
                case 1: {
                    boolean bl = this.locateMatches(rfProject.getAllFunctions(false), currentProject);
                    return bl;
                }
                case 5: {
                    boolean bl = this.locateMatches(rfProject.getAllFunctions(true), currentProject);
                    return bl;
                }
                case 2: {
                    boolean bl = this.locateMatches(rfProject.getAllVariables(32768), currentProject);
                    return bl;
                }
                case 7: {
                    boolean bl = this.locateMatches(rfProject.getAllVariables(16384), currentProject);
                    return bl;
                }
                case 3: {
                    boolean bl = this.locateMatches(rfProject.getAllComponents(), currentProject);
                    return bl;
                }
                case 4: {
                    boolean bl = this.locateMatches(rfProject.getAllPorts(), currentProject);
                    return bl;
                }
                case 6: {
                    boolean bl = this.locateMatches(rfProject.getAllEntities(), currentProject);
                    return bl;
                }
            }
        }
        catch (UnsupportedCharsetException e) {
            Object[] args = new Object[]{this.getCharSetName(currentProject), currentProject.getFullPath().makeRelative().toOSString()};
            String message = MessageFormat.format(SearchMessages.TextSearchVisitor_unsupportedcharset, args);
            this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
        }
        catch (IllegalCharsetNameException e) {
            Object[] args = new Object[]{this.getCharSetName(currentProject), currentProject.getFullPath().makeRelative().toOSString()};
            String message = MessageFormat.format(SearchMessages.TextSearchVisitor_illegalcharset, args);
            this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
        }
        catch (CoreException e) {
            Object[] args = new Object[]{this.getExceptionMessage((Exception)((Object)e)), currentProject.getFullPath().makeRelative().toOSString()};
            String message = MessageFormat.format(SearchMessages.TextSearchVisitor_error, args);
            this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 4, message, (Throwable)e));
        }
        catch (StackOverflowError e) {
            String message = SearchMessages.TextSearchVisitor_patterntoocomplex0;
            this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 4, message, (Throwable)e));
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            ++this.fNumberOfScannedProjects;
        }
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
        }
        return true;
    }

    private boolean locateMatches(List<RfNamedElement> namedElements, IProject currentProject) throws CoreException, BadLocationException {
        try {
            int i = 0;
            while (i < namedElements.size()) {
                block22: {
                    RfDefElement elementLayer;
                    IFile layerFile;
                    RfNamedElement element;
                    block23: {
                        String enclosingName;
                        if (this.fCheckForQueryInterruptionCounter++ == 20) {
                            if (this.fProgressMonitor.isCanceled()) {
                                throw new OperationCanceledException("Operation Canceled");
                            }
                            this.fCheckForQueryInterruptionCounter = 0;
                        }
                        if ((element = namedElements.get(i)) == null) break block22;
                        this.fMatcher.reset(element.getName());
                        if (!this.fMatcher.matches()) break block22;
                        if (this.fSearchPackage == null && this.fSearchStructs == null) break block23;
                        RfNamedElement enclosing = element;
                        if (this.fSearchStructs != null) {
                            String[] stringArray = this.fSearchStructs;
                            int n = this.fSearchStructs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String struct = stringArray[n2];
                                if ((enclosing = enclosing.getEnclosingScope()) != null) {
                                    String enclosingName2;
                                    String string = enclosingName2 = enclosing instanceof RfArchitecture ? ((RfArchitecture)enclosing).getEntityName() : enclosing.getName();
                                    if (Pattern.matches(struct, enclosingName2)) {
                                        ++n2;
                                        continue;
                                    }
                                }
                                break block22;
                            }
                        }
                        if (this.fSearchPackage == null) break block23;
                        if ((enclosing = enclosing.getEnclosingScope()) == null) break block22;
                        String string = enclosingName = enclosing instanceof RfArchitecture ? ((RfArchitecture)enclosing).getEntityName() : enclosing.getName();
                        if (!Pattern.matches(this.fSearchPackage, enclosingName)) break block22;
                    }
                    if ((layerFile = this.getFile(elementLayer = element.getDeclaration(), currentProject)) != null && DVTFileUtils.getInstance().ensureFileInSyncWithUserAccept((IResource)layerFile, this.fProgressMonitor) && this.fCollector.acceptFile(layerFile)) {
                        IDocument document = this.getOpenDocument(layerFile);
                        if (document == null) {
                            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                            TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(layerFile);
                            IPath path = textFileBufferInfo.getPath();
                            LocationKind locationKind = textFileBufferInfo.getLocationKind();
                            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                            boolean shouldDisconnect = false;
                            if (textFileBuffer == null) {
                                shouldDisconnect = true;
                                bufferManager.connect(path, locationKind, null);
                            }
                            textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                            document = textFileBuffer.getDocument();
                            if (shouldDisconnect) {
                                bufferManager.disconnect(path, locationKind, null);
                            }
                        }
                        DocumentCharSequence documentCharSequence = new DocumentCharSequence(document, true);
                        int offset = document.getLineOffset(this.getStartLine(elementLayer) - 1);
                        int length = document.getLineLength(this.getStartLine(elementLayer) - 1);
                        String lineContent = document.get(offset, length);
                        int start = 0;
                        Matcher wordMatch = Pattern.compile("\\b" + element.getName() + "\\b", 2).matcher(lineContent);
                        start = wordMatch.find() ? wordMatch.start() : lineContent.indexOf(element.getName());
                        if (start >= 0) {
                            int end = start + element.getName().length();
                            this.fMatchAccess.initialize(layerFile, offset + start, end - start, (CharSequence)documentCharSequence);
                            if (!this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess)) {
                                // empty if block
                            }
                        }
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    int getStartLine(Object layer) {
        if (layer instanceof RfDefElement) {
            return ((RfDefElement)layer).getStartLine();
        }
        return -1;
    }

    private IFile getFile(Object element, IProject project) {
        if (element instanceof RfNamedElement && ((RfNamedElement)element).getDeclaration() != null) {
            return (IFile)((RfNamedElement)element).getDeclaration().getFileAdapter();
        }
        if (element instanceof RfDefElement) {
            return (IFile)((RfDefElement)element).getFileAdapter();
        }
        return null;
    }

    private Map<IFile, IDocument> evalNonFileBufferDocuments() {
        HashMap<IFile, IDocument> result = new HashMap<IFile, IDocument>();
        IWorkbench workbench = VhdlPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map<IFile, IDocument> result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            LocationKind locationKind;
            TextFileBufferInfo textFileBufferInfo;
            IPath path;
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        LocationKind locationKind;
        TextFileBufferInfo textFileBufferInfo;
        IPath path;
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private String getCharSetName(IProject currentProject) {
        try {
            return currentProject.getDefaultCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }
}

