/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.instances;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseInstancesSearchQuery;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.InstanceMatch;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.ui.search.instances.InstancesSearchResult;

public class InstancesSearchQuery
extends BaseInstancesSearchQuery {
    public InstancesSearchQuery(IRfNamedElement element) {
        super(element);
    }

    protected AbstractTextSearchResult makeSearchResult() {
        return new InstancesSearchResult((ISearchQuery)this);
    }

    public void addInstanceMatch(InstanceMatch match, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager) {
        try {
            IFile file;
            ParserPath parserPath = match.getParserPath();
            if (!parserPath.equals((Object)this.fCurrentParserPath)) {
                RfReferencesUtils.flushMatches((Set)this.fCachedMatches, (AbstractTextSearchResult)this.fSearchResult);
            }
            this.fCurrentParserPath = parserPath;
            if (!fileManager.isSynchedFile(parserPath, this.fProject)) {
                return;
            }
            IDocument document = documentManager.getDocument(parserPath, this.fProject);
            if (document == null) {
                return;
            }
            int offset = match.getStartOffset();
            if (offset == -1) {
                return;
            }
            int line = document.getLineOfOffset(offset);
            IRegion lineInformation = document.getLineInformation(line);
            String lineContents = document.get(lineInformation.getOffset(), lineInformation.getLength());
            int lineOffset = lineInformation.getOffset();
            String highlightedElement = match.getHighlightedElement();
            int matchLength = highlightedElement.length();
            if (match.isEscaped()) {
                ++matchLength;
            }
            if ((file = DVTFileUtils.getInstance().findProjectFile(this.fProject, parserPath.path)) == null) {
                return;
            }
            LineElement lineEntry = new LineElement((IResource)file, line + 1, offset, lineContents);
            BaseFileMatch fileMatch = new BaseFileMatch(file, offset, matchLength, false, lineEntry);
            String scopeInfo = RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)lineEntry.getLine(), (int)lineEntry.getOffset(), (boolean)false);
            lineEntry.setExtraInfo(scopeInfo);
            int counter = 0;
            try {
                counter = RfReferencesUtils.countStartWS((String)lineContents);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (counter == -1) {
                return;
            }
            int highlightOffset = offset;
            if (match.isEscaped()) {
                ++highlightOffset;
            }
            lineEntry.setSearchedElement(highlightedElement, highlightOffset - lineOffset - counter, false);
            this.fCachedMatches.add(fileMatch);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

