/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.new_engine;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfNamedElementVisitorException;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.FilesAndProjectsOfScopeCalculator;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfGUIReferencesUtils;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfReferencesUtils;
import ro.amiq.vhdldt.ui.search.text.FileMatch;
import ro.amiq.vhdldt.ui.search.text.FileSearchQuery;

public class NewHidsSearchEngine
extends TextSearchEngine {
    public static final String LOG_NEW_MESSAGE_PREFIX = "[REFERENCES ENGINE BENCHMARK] VHDLDT - NEW SEARCH ENGINE - time for references of ";
    private boolean fIncludeDeclarations;
    private boolean fForRefactor;
    private String fSearchType;
    private IRfNamedElement fRfElement;
    private IProject fProject;
    private AbstractTextSearchResult fResult;
    private HashSet<BaseFileMatch> fCachedMatches;
    private boolean fIsStrictVirtual;
    private IProgressMonitor fProgressMonitor;
    private FilesAndProjectsOfScopeCalculator fCalculator;
    private ParserPath fCurrentParserPath;
    private RWSearchTypeEnum fSearchRWType;
    private FileSearchQuery fQuery;

    public NewHidsSearchEngine(boolean includeDeclarations, String searchType, RWSearchTypeEnum searchRWType, IProject project, FileSearchQuery query) {
        this.fIncludeDeclarations = includeDeclarations;
        this.fCachedMatches = new HashSet();
        this.fCurrentParserPath = null;
        this.fSearchType = searchType;
        this.fSearchRWType = searchRWType;
        this.fProject = project;
        this.fQuery = query;
    }

    public IStatus search(TextSearchScope scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
        return null;
    }

    public IStatus search(IFile[] scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
        return null;
    }

    public IStatus search(IRfNamedElement element, FileTextSearchScope scope, AbstractTextSearchResult textResult, Pattern searchPattern, IProgressMonitor monitor, DVTEditor fTextEditor, int fOffset, IRfScopeElement fScopeElement) {
        try {
            try {
                this.fRfElement = element;
                this.fResult = textResult;
                this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
                this.fCalculator = new FilesAndProjectsOfScopeCalculator((TextSearchScope)scope);
                String patternText = this.fRfElement.getName();
                String type = this.fSearchType.toLowerCase();
                String taskName = MessageFormat.format(SearchMessages.TextSearchVisitor_hidssearch_task_label, type, patternText);
                this.fProgressMonitor.beginTask(taskName, 100);
                long startTime = System.currentTimeMillis();
                HashSet<SearchHit> allMatches = new HashSet<SearchHit>();
                IReportHitsListener<SearchHit> reportMatcheslistener = this.getReportMatchesListener(allMatches);
                FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles((Map)this.fCalculator.getFilesMap()), monitor, false);
                this.computeSearch(reportMatcheslistener, searchPattern, fileManager, fTextEditor, fOffset, fScopeElement);
                VHDLRfReferencesUtils.flushMatches(this.fCachedMatches, (AbstractTextSearchResult)this.fResult);
                VHDLRfGUIReferencesUtils.logComputeReferencesTime(this.fRfElement, startTime);
                this.fQuery.setUnsynchedMatches(fileManager.getUnsynchedFiles());
            }
            catch (RfNamedElementVisitorException e) {
                if (!(e.getCause() instanceof OperationCanceledException)) {
                    DVTLogger.INSTANCE.logError(e.getCause());
                }
                this.fProgressMonitor.done();
                VHDLRfReferencesUtils.flushMatches(this.fCachedMatches, (AbstractTextSearchResult)this.fResult);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fProgressMonitor.done();
                VHDLRfReferencesUtils.flushMatches(this.fCachedMatches, (AbstractTextSearchResult)this.fResult);
            }
        }
        finally {
            this.fProgressMonitor.done();
            VHDLRfReferencesUtils.flushMatches(this.fCachedMatches, (AbstractTextSearchResult)this.fResult);
        }
        return Status.OK_STATUS;
    }

    private IReportHitsListener<SearchHit> getReportMatchesListener(final Set<SearchHit> allMatches) {
        IReportHitsListener<SearchHit> listener = new IReportHitsListener<SearchHit>(){

            public void addMatch(SearchHit match) {
                try {
                    IFile file;
                    if (allMatches.contains(match)) {
                        return;
                    }
                    allMatches.add(match);
                    ParserPath parserPath = match.getParserPath();
                    if (!parserPath.equals((Object)NewHidsSearchEngine.this.fCurrentParserPath)) {
                        NewHidsSearchEngine.this.fCurrentParserPath = parserPath;
                        VHDLRfReferencesUtils.flushMatches(NewHidsSearchEngine.this.fCachedMatches, (AbstractTextSearchResult)NewHidsSearchEngine.this.fResult);
                    }
                    if ((file = DVTFileUtils.getInstance().findProjectFile(match.getProject(), parserPath.path)) == null) {
                        return;
                    }
                    LineElement element = new LineElement((IResource)file, match.getLine(), match.getOffset(), match.getContents());
                    element.setExtraInfo(match.getExtraInfo());
                    element.setWriteAccess(match.getAccess());
                    element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                    element.setElaborationHit(match.isElaborationHit());
                    int matchLength = match.getMatchLength();
                    FileMatch fileMatch = new FileMatch(file, match.getOffset(), matchLength, match.isPossibleMatch(), element, match.isInsideMacroCall(), match.isRenamed());
                    fileMatch.setInstance(match.getInstance());
                    fileMatch.setHitType(match.getHitType());
                    if (VHDLRfReferencesUtils.shouldSkipReadersWritersUsages((RWSearchTypeEnum)NewHidsSearchEngine.this.fSearchRWType, (RWKind)match.getAccess())) {
                        return;
                    }
                    NewHidsSearchEngine.this.fCachedMatches.add(fileMatch);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public Set<SearchHit> getMatches() {
                return null;
            }
        };
        return listener;
    }

    private void computeSearch(IReportHitsListener<SearchHit> reportHitslistener, Pattern searchPattern, FileSynchedAndAvailableManager fileManager, DVTEditor fTextEditor, int fOffset, IRfScopeElement fScope) throws Exception {
        if (VHDLRfReferencesUtils.isSemanticSearch(this.fRfElement)) {
            VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE TRIGGERED FROM VHDL FILE] Computing semantic search for " + this.fRfElement.getKindName() + " '" + this.fRfElement.getName() + "'"));
            this.computeSemanticSearchMatches(reportHitslistener, searchPattern, fileManager);
        } else {
            VHDLRfReferencesUtils.logDebug((String)("[SEARCH ENGINE TRIGGERED FROM VHDL FILE] Computing references for " + this.fRfElement.getKindName() + " '" + this.fRfElement.getName() + "'"));
            this.computeReferencesMatches(reportHitslistener, fTextEditor, fOffset, fScope, fileManager);
        }
    }

    private void computeSemanticSearchMatches(IReportHitsListener<SearchHit> listener, Pattern searchPattern, FileSynchedAndAvailableManager fileManager) throws Exception {
        Set projects = this.fCalculator.getProjects();
        if (projects == null || projects.isEmpty()) {
            return;
        }
        for (IProject project : projects) {
            if (project == null) continue;
            VHDLRfReferencesUtils.computeMatchesForSemanticSearch(listener, searchPattern, project, this.fRfElement, this.fProgressMonitor, this.fCalculator.getFilesMap(), fileManager, this.fIncludeDeclarations);
        }
    }

    private void computeReferencesMatches(IReportHitsListener<SearchHit> listener, DVTEditor editor, int offset, IRfScopeElement scope, FileSynchedAndAvailableManager fileManager) {
        IRfNamedElement elaboratedElement;
        RfSearchUtils.computeReferences(listener, (IProject)this.fProject, (IRfNamedElement)this.fRfElement, null, (String)this.fRfElement.getName(), (IProgressMonitor)this.fProgressMonitor, new HashMap(), (FileSynchedAndAvailableManager)fileManager, (boolean)this.fIncludeDeclarations, (boolean)this.fForRefactor, (boolean)this.fIsStrictVirtual, (boolean)false, (boolean)false);
        if (editor != null && offset != -1 && !this.fRfElement.checkEquals((Object)(elaboratedElement = RfSearchUtils.getElementToSearch((IRfNamedElement)this.fRfElement, (IRfScopeElement)scope, (DVTEditor)editor, (int)offset)))) {
            RfSearchUtils.computeReferences(listener, (IProject)this.fProject, (IRfNamedElement)elaboratedElement, null, (String)elaboratedElement.getName(), (IProgressMonitor)this.fProgressMonitor, new HashMap(), (FileSynchedAndAvailableManager)fileManager, (boolean)this.fIncludeDeclarations, (boolean)this.fForRefactor, (boolean)this.fIsStrictVirtual, (boolean)true, (boolean)false);
        }
    }
}

