/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.new_engine;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameConflictType;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.HitType;
import ro.amiq.dvt.ui.search.LeftRightHandSideOfOperatorEnum;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.SearchHitConnectedElementInfo;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;

public class ReferenceHidOperatorVisitor
implements IHidVisitor<RfHidOperator> {
    private static final String DUMMY_CHAR_STRING = "c";
    private IProject fProject;
    private boolean fForRefactor;
    private IRfNamedElement fRfElement;
    private ParserPath fParserPath;
    private IProgressMonitor fProgressMonitor;
    private DocumentManager fDocumentManager;
    private int fCheckForQueryInterruptionCounter = 0;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;
    private RWKind fSearchedPortElementWriteType;
    private IRfNamedElement fScope;
    private RenameAcrossHierarchyInfo fRenameWrapper;
    private String fCurrentConnectedElement;
    private Map<Integer, List<SearchedElementWrapper>> fSearchedElementsRelativeToPairs;
    private SearchedElementWrapper fElementWrapper;
    private boolean fSkipImplicitComponentEntityAssociation;
    private boolean assumeHitWhenSameNameAndType;
    private static final long ASSIGN_QUALIFIERS = HidUtils.toQualifiersSet((HidOperatorQualifier[])new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_EXPRESSION, HidOperatorQualifier.IS_CONTINUOUS_ASSIGN, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN, HidOperatorQualifier.IS_BLOCKING_ASSIGN, HidOperatorQualifier.IS_PROCEDURAL_CONTINUOUS_ASSIGN});

    public ReferenceHidOperatorVisitor(IReportHitsListener<SearchHit> listener, IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, IRfNamedElement element, IProject project, boolean forRefactor, DocumentManager documentManager, Map<Integer, List<SearchedElementWrapper>> searchedElementsRelativeToPairs, RenameAcrossHierarchyInfo renameWrapper, SearchedElementWrapper elementWrapper, boolean skipImplicitComponentEntityAssociation) {
        this.fRfElement = element;
        this.fProject = project;
        this.fForRefactor = forRefactor;
        this.fFileManager = fileManager;
        this.fListener = listener;
        this.fDocumentManager = documentManager;
        this.fProgressMonitor = progressMonitor;
        this.fSkipImplicitComponentEntityAssociation = skipImplicitComponentEntityAssociation;
        this.fSearchedPortElementWriteType = RfReferencesUtils.getPortElementWriteType((IRfNamedElement)element);
        this.fRenameWrapper = renameWrapper;
        this.fCurrentConnectedElement = null;
        this.fSearchedElementsRelativeToPairs = searchedElementsRelativeToPairs;
        this.fElementWrapper = elementWrapper;
    }

    public boolean visit(RfHidOperator hidOperator) {
        IRfNamedElement[] currentOperatorLHElement;
        boolean isPortOrArgumentConnection;
        boolean isPortConnection;
        ListContainer rhHidObjects;
        IHidObject lhHidObject;
        block13: {
            block12: {
                block11: {
                    block10: {
                        if (!this.fListener.shouldFilterIHidObject((IHidObject)hidOperator, null)) break block10;
                        return true;
                    }
                    if (this.fCheckForQueryInterruptionCounter++ == 20) {
                        if (this.fProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException("Operation Canceled");
                        }
                        this.fCheckForQueryInterruptionCounter = 0;
                    }
                    if (!hidOperator.hasQualifier(HidQualifierCache.IS_ALIAS_DECLARATION_QUALIFIER)) break block11;
                    return true;
                }
                lhHidObject = hidOperator.getLHValue();
                rhHidObjects = hidOperator.getRHValues();
                isPortConnection = hidOperator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION);
                isPortOrArgumentConnection = isPortConnection || hidOperator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE);
                this.fCurrentConnectedElement = null;
                currentOperatorLHElement = new IRfNamedElement[]{null};
                if (!this.checkLeftHandSideOfOperator(lhHidObject, (ListContainer<IHidObject>)rhHidObjects, hidOperator, currentOperatorLHElement, isPortConnection)) break block12;
                return true;
            }
            if (rhHidObjects != null && !rhHidObjects.isEmpty()) break block13;
            return true;
        }
        try {
            for (IHidObject rhValue : rhHidObjects) {
                this.checkRightHandSideOfOperator(rhValue, lhHidObject, hidOperator, currentOperatorLHElement[0], isPortConnection, isPortOrArgumentConnection);
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private boolean checkLeftHandSideOfOperator(IHidObject lhHidObject, ListContainer<IHidObject> rhHidObjects, RfHidOperator hidOperator, IRfNamedElement[] lhElement, boolean isPortConnection) throws Exception {
        if (HidUtils.isHid((IHidObject)lhHidObject)) {
            Hid lhHid = (Hid)lhHidObject;
            lhElement[0] = lhHid.getElement();
            if (this.checkLeftHandSideHidOfOperator(lhHid, rhHidObjects, hidOperator, isPortConnection)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkRightHandSideOfOperator(IHidObject rhValue, IHidObject lhHidObject, RfHidOperator hidOperator, IRfNamedElement lhElement, boolean isPortConnection, boolean isPortOrArgumentConnection) throws Exception {
        if (HidUtils.isHid((IHidObject)rhValue)) {
            Hid rhHid = (Hid)rhValue;
            this.checkRightHandSideHidOfOperator(lhHidObject, hidOperator, lhElement, rhHid, isPortConnection, isPortOrArgumentConnection);
        }
        return false;
    }

    private boolean checkRightHandSideHidOfOperator(IHidObject lhHidObject, RfHidOperator hidOperator, IRfNamedElement lhElement, Hid hid, boolean isPortConnection, boolean isPortOrArgumentConnection) throws Exception {
        boolean isMatch;
        IRfNamedElement rhHidElement = hid.getElement();
        String rhHidName = hid.getName().toLowerCase();
        boolean isPotentialMatch = this.fRfElement.getLowerCaseName().equals(rhHidName);
        boolean checkEquals = this.fRfElement.checkEquals((Object)rhHidElement);
        boolean bl = isMatch = checkEquals && isPotentialMatch;
        if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameWrapper) && this.fElementWrapper != null && this.fScope instanceof RfInstance && RfReferencesUtils.isElaboratedInstance((IRfSingleLangProject)RfManager.getInstance().getRfProject(this.fProject), (IRfInstanceElement)((RfInstance)this.fScope)) && isPortConnection && checkEquals) {
            this.collectLeftElement(lhHidObject);
        }
        if (RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameWrapper) && this.fElementWrapper != null && this.fScope instanceof RfInstance && checkEquals) {
            RfSearchUtils.addPreviewInfo((IRfNamedElement)((IRfNamedElement)rhHidElement.getEnclosingScope()), (IRfNamedElement)rhHidElement, (SearchedElementWrapper)this.fElementWrapper, (RenameAcrossHierarchyInfo)this.fRenameWrapper, (LeftRightHandSideOfOperatorEnum)LeftRightHandSideOfOperatorEnum.RIGHT_HAND_MATCH, (boolean)false, (RenameConflictType)RenameConflictType.NO_CONFLICT, (this.fElementWrapper.getRelativeLevel() == 0 ? 1 : 0) != 0, (HidOperator)hidOperator);
        }
        if (isMatch || isPotentialMatch && rhHidElement == null) {
            LinkedHashSet<SearchHitConnectedElementInfo> elements = new LinkedHashSet<SearchHitConnectedElementInfo>();
            Set flattenToHids = HidUtils.flattenToHids((IHidObject)lhHidObject, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
            if (flattenToHids != null && !flattenToHids.isEmpty()) {
                for (IHid flatten : flattenToHids) {
                    IRfNamedElement element = flatten.getElement();
                    int line = flatten.getLine();
                    int offset = flatten.getOffset();
                    if (element == null) continue;
                    elements.add(new SearchHitConnectedElementInfo(element, line, offset, this.fParserPath));
                }
            }
            this.reportRightHidMatch(hidOperator, lhElement, rhHidElement, isMatch, isPortOrArgumentConnection, hid, elements);
            return true;
        }
        return false;
    }

    private void reportRightHidMatch(RfHidOperator hidOperator, IRfNamedElement lhElement, IRfNamedElement rhHidElement, boolean isMatch, boolean isPortOrArgumentConnection, Hid hid, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        RWKind writeAccess = RWKind.NONE;
        if (isMatch) {
            if (isPortOrArgumentConnection && lhElement != null) {
                writeAccess = RfSearchUtils.computePortArgumentConnectionWriteAccess((IRfNamedElement)lhElement, (IRfNamedElement)rhHidElement, (boolean)true, (RWKind)this.computeWriteAccess(hidOperator));
            }
            if (RfReferencesUtils.checkFoundElementForReadAndWrite((IRfNamedElement)this.fRfElement, (IRfNamedElement)rhHidElement) && writeAccess == RWKind.NONE) {
                writeAccess = RWKind.READ;
            }
        }
        this.addReferenceMatchOcc(!isMatch, (IHidObject)hid, HitType.REGULAR, writeAccess, LeftRightHandSideOfOperatorEnum.RIGHT_HAND_MATCH, elements);
    }

    private boolean checkLeftHandSideHidOfOperator(Hid hid, ListContainer<IHidObject> rhHidObjects, RfHidOperator hidOperator, boolean isPortConnection) throws Exception {
        IRfNamedElement hidElement = hid.getElement();
        String hidName = hid.getName().toLowerCase();
        boolean isPotentialMatch = this.fRfElement.getLowerCaseName().equals(hidName);
        boolean isOrderedConnectionMatch = RfSearchUtils.allowOrderedConnections((IRfNamedElement)hidElement) && !this.fForRefactor && !RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameWrapper);
        boolean checkEquals = this.fRfElement.checkEquals((Object)hidElement);
        boolean isMatch = !this.fSkipImplicitComponentEntityAssociation && (isPotentialMatch || isOrderedConnectionMatch) && checkEquals || isPotentialMatch && this.assumeHitWhenSameNameAndType || this.fSkipImplicitComponentEntityAssociation && this.fRfElement.equals(hidElement);
        SearchedElementWrapper collectedElementWrapper = null;
        if (checkEquals && RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameWrapper) && this.fElementWrapper != null && this.fScope instanceof RfInstance && isPortConnection) {
            collectedElementWrapper = this.collectRightElement(rhHidObjects);
        }
        if (checkEquals && RfSearchUtils.isRenameAcrossHierarchyEnabled((RenameAcrossHierarchyInfo)this.fRenameWrapper) && this.fElementWrapper != null && this.fScope instanceof RfInstance && hidElement instanceof IRfPortElement) {
            RfSearchUtils.addPreviewInfo((IRfNamedElement)this.fScope, (IRfNamedElement)hidElement, (SearchedElementWrapper)this.fElementWrapper, (RenameAcrossHierarchyInfo)this.fRenameWrapper, (LeftRightHandSideOfOperatorEnum)LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH, (collectedElementWrapper != null && collectedElementWrapper.shouldBeRenamed() ? 1 : 0) != 0, (RenameConflictType)RenameConflictType.NO_CONFLICT, (this.fElementWrapper.getRelativeLevel() == 0 ? 1 : 0) != 0, (HidOperator)hidOperator);
        }
        if (isMatch || isPotentialMatch && hidElement == null) {
            LinkedHashSet<SearchHitConnectedElementInfo> elements = new LinkedHashSet<SearchHitConnectedElementInfo>();
            for (IHidObject rhHidObject : rhHidObjects) {
                Set flattenToHids = HidUtils.flattenToHids((IHidObject)rhHidObject, (Set)HidFlatteningOption.IMPLICITS_EXCLUDED);
                if (flattenToHids == null || flattenToHids.isEmpty()) continue;
                for (IHid flatten : flattenToHids) {
                    IRfNamedElement element = flatten.getElement();
                    int line = flatten.getLine();
                    int offset = flatten.getOffset();
                    if (element == null) continue;
                    elements.add(new SearchHitConnectedElementInfo(element, line, offset, this.fParserPath));
                }
            }
            this.reportLeftHidMatch(hidOperator, (IHidObject)(isPotentialMatch ? hid : hidOperator), hidElement, isMatch, elements);
            return true;
        }
        return false;
    }

    private void reportLeftHidMatch(RfHidOperator hidOperator, IHidObject hidObject, IRfNamedElement lhHidElement, boolean isMatch, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        RWKind writeAccess = RWKind.NONE;
        if (isMatch) {
            writeAccess = this.computeWriteAccess(hidOperator);
            if (RfReferencesUtils.checkFoundElementForReadAndWrite((IRfNamedElement)this.fRfElement, (IRfNamedElement)lhHidElement) && writeAccess == RWKind.NONE) {
                writeAccess = RWKind.READ;
            }
        }
        this.addReferenceMatchOcc(!isMatch, hidObject, HitType.REGULAR, writeAccess, LeftRightHandSideOfOperatorEnum.LEFT_HAND_MATCH, elements);
    }

    private SearchedElementWrapper collectRightElement(ListContainer<IHidObject> rhHidObjects) throws Exception {
        if (rhHidObjects == null) {
            return null;
        }
        int size = rhHidObjects.size();
        if (size <= 0 || size > 1) {
            return null;
        }
        IHidObject hidObject = (IHidObject)rhHidObjects.get(0);
        if (HidUtils.isHid((IHidObject)hidObject)) {
            Hid hid = (Hid)hidObject;
            return this.collectHidRightElement(hid);
        }
        return null;
    }

    private SearchedElementWrapper collectHidRightElement(Hid rhHid) throws Exception {
        boolean isNamingOk;
        IRfNamedElement rhHidElement = rhHid.getElement();
        if (!RfSearchUtils.scopeInsideDesignPath((RenameAcrossHierarchyInfo)this.fRenameWrapper, (IRfNamedElement)this.fScope)) {
            int collectedRelativeLevel = this.fElementWrapper.getRelativeLevel() + 1;
            SearchedElementWrapper newSearchedElementWrapper = new SearchedElementWrapper(rhHidElement, collectedRelativeLevel, (IRfInstanceElement)((RfInstance)this.fScope));
            if (RfSearchUtils.containsSearchedElement(this.fSearchedElementsRelativeToPairs, (SearchedElementWrapper)newSearchedElementWrapper)) {
                newSearchedElementWrapper.setShouldBeRenamed(true);
                return newSearchedElementWrapper;
            }
            return null;
        }
        if (!RfSearchUtils.shouldCollectRightElement((IRfNamedElement)rhHidElement, (RenameAcrossHierarchyInfo)this.fRenameWrapper, (IProject)this.fProject)) {
            return null;
        }
        boolean bl = isNamingOk = !this.fRenameWrapper.isMatchingNames() || !this.fRfElement.getName().equalsIgnoreCase(rhHidElement.getName());
        if (!isNamingOk) {
            return null;
        }
        int collectedRelativeLevel = this.fElementWrapper.getRelativeLevel() + 1;
        SearchedElementWrapper newSearchedElementWrapper = new SearchedElementWrapper(rhHidElement, collectedRelativeLevel, (IRfInstanceElement)((RfInstance)this.fScope));
        if (RfSearchUtils.shouldContinueWithRefactoring((boolean)true, (SearchedElementWrapper)this.fElementWrapper)) {
            boolean shouldBeRenamed;
            boolean bl2 = shouldBeRenamed = !RfSearchUtils.isAlreadyRenamedElementInSameEnclosingScope((RenameAcrossHierarchyInfo)this.fRenameWrapper, (IProject)this.fProject, this.fSearchedElementsRelativeToPairs, (IRfNamedElement)rhHidElement, (IRfInstanceElement)((RfInstance)this.fScope));
            if (!RfSearchUtils.containsSearchedElement(this.fSearchedElementsRelativeToPairs, (SearchedElementWrapper)newSearchedElementWrapper)) {
                newSearchedElementWrapper.setShouldBeRenamed(shouldBeRenamed);
                RfSearchUtils.collectNewSearchedElement(this.fSearchedElementsRelativeToPairs, (int)collectedRelativeLevel, (SearchedElementWrapper)newSearchedElementWrapper);
            }
        }
        this.fCurrentConnectedElement = rhHidElement.getName();
        return newSearchedElementWrapper;
    }

    private void collectLeftElement(IHidObject lhHidObject) throws Exception {
        if (HidUtils.isHid((IHidObject)lhHidObject)) {
            Hid lhHid = (Hid)lhHidObject;
            this.collectHidLeftElement(lhHid);
        }
    }

    private void collectHidLeftElement(Hid hid) throws Exception {
        boolean isNamingOk;
        IRfNamedElement lhHidElement = hid.getElement();
        if (!RfSearchUtils.shouldCollectLeftElement((IRfNamedElement)lhHidElement, (RenameAcrossHierarchyInfo)this.fRenameWrapper, (IProject)this.fProject)) {
            return;
        }
        boolean bl = isNamingOk = !this.fRenameWrapper.isMatchingNames() || !this.fRfElement.getName().equalsIgnoreCase(lhHidElement.getName());
        if (!isNamingOk) {
            return;
        }
        int collectedRelativeLevel = this.fElementWrapper.getRelativeLevel() - 1;
        SearchedElementWrapper newSearchedElementWrapper = new SearchedElementWrapper(lhHidElement, collectedRelativeLevel, (IRfInstanceElement)((RfInstance)this.fScope));
        if (RfSearchUtils.shouldContinueWithRefactoring((boolean)false, (SearchedElementWrapper)this.fElementWrapper)) {
            boolean shouldBeRenamed;
            boolean bl2 = shouldBeRenamed = !RfSearchUtils.isAlreadyRenamedElementInSameEnclosingScope((RenameAcrossHierarchyInfo)this.fRenameWrapper, (IProject)this.fProject, this.fSearchedElementsRelativeToPairs, (IRfNamedElement)lhHidElement, (IRfInstanceElement)((RfInstance)this.fScope));
            if (!RfSearchUtils.containsSearchedElement(this.fSearchedElementsRelativeToPairs, (SearchedElementWrapper)newSearchedElementWrapper)) {
                newSearchedElementWrapper.setShouldBeRenamed(shouldBeRenamed);
                RfSearchUtils.collectNewSearchedElement(this.fSearchedElementsRelativeToPairs, (int)collectedRelativeLevel, (SearchedElementWrapper)newSearchedElementWrapper);
            }
        }
        this.fCurrentConnectedElement = lhHidElement.getName();
    }

    private RWKind computeWriteAccess(RfHidOperator operator) {
        boolean isConnection;
        boolean isPatternAssign = operator.hasOccurrence(HidOperatorQualifier.IS_PATTERN_VALUE);
        boolean isAssign = operator.hasOccurrence(ASSIGN_QUALIFIERS);
        boolean bl = isConnection = operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION) || operator.hasOccurrence(HidOperatorQualifier.IS_GENERIC_VALUE) || operator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE);
        return isPatternAssign || isAssign ? RWKind.WRITE : (isConnection ? this.fSearchedPortElementWriteType : RWKind.NONE);
    }

    private void addReferenceMatchOcc(boolean isPossibleMatch, IHidObject hidObject, HitType type, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfConnection, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        if (!this.fFileManager.isSynchedFile(this.fParserPath, this.fProject)) {
            return;
        }
        IDocument document = this.fDocumentManager.getDocument(this.fParserPath, this.fProject);
        if (document == null) {
            return;
        }
        if (HidUtils.isHid((IHidObject)hidObject)) {
            this.addMatchOcc(isPossibleMatch, document, (Hid)hidObject, type, writeAccess, leftRightHandSideOfConnection, elements);
        } else if (HidUtils.isOperator((IHidObject)hidObject)) {
            this.addMatchOcc(isPossibleMatch, document, (HidOperator)hidObject, type, writeAccess, leftRightHandSideOfConnection, elements);
        }
    }

    private void addMatchOcc(boolean isPossibleMatch, IDocument document, Hid hid, HitType type, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfConnection, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        HidOccurrence occurence = hid.getOccurrence();
        if (occurence == null) {
            return;
        }
        int offset = occurence.getOffset();
        int virtualOffset = occurence.getVirtualOffset();
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        if (virtualOffset == -1) {
            this.addHitOccurence(false, offset, occurence.getLine(), document, isPossibleMatch, type, writeAccess, leftRightHandSideOfConnection, elements);
        }
    }

    private void addMatchOcc(boolean isPossibleMatch, IDocument document, HidOperator operator, HitType type, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfConnection, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        HidOperatorOccurrence occurence = operator.getOccurrence();
        if (occurence == null) {
            return;
        }
        int virtualOffset = occurence.getVirtualOffset();
        if (this.fCheckForQueryInterruptionCounter++ == 20) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        if (virtualOffset == -1) {
            this.addHitOccurence(false, operator.getOpenBoundary(), operator.getCloseBoundary(), occurence.getLine(), document, isPossibleMatch, type, writeAccess, leftRightHandSideOfConnection, elements);
        }
    }

    private void addHitOccurence(boolean isNonParameterHit, int offset, int line, IDocument document, boolean isPossibleMatch, HitType type, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfConnection, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        boolean isEscapedMatch;
        if (isNonParameterHit && this.fForRefactor) {
            return;
        }
        if (line == -1) {
            line = document.getLineOfOffset(offset) + 1;
        }
        IRegion info = document.getLineInformation(line - 1);
        String lineContents = document.get(info.getOffset(), info.getLength());
        int lineOffset = document.getLineOffset(line - 1);
        int matchLength = isNonParameterHit ? lineContents.trim().length() : this.fRfElement.getName().length();
        boolean bl = isEscapedMatch = lineContents.charAt(offset - lineOffset) == '\\';
        if (isEscapedMatch) {
            ++matchLength;
        }
        SearchHit lineEntry = new SearchHit(this.fParserPath, line, offset, lineContents, matchLength, this.fElementWrapper == null ? true : this.fElementWrapper.shouldBeRenamed(), this.fCurrentConnectedElement, this.fRfElement, this.fProject);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)this.fParserPath, (int)line, (int)offset, (boolean)isPossibleMatch));
        lineEntry.setLeftRightHandSideOfConnection(leftRightHandSideOfConnection);
        lineEntry.setConnectedElement(elements);
        String highlightName = this.fRfElement.getName();
        int counter = RfReferencesUtils.countStartWS((String)lineContents);
        if (isNonParameterHit && counter >= 0) {
            highlightName = lineContents.trim().substring(offset - lineOffset - counter);
            matchLength = highlightName.length();
        }
        int highlightOffset = offset;
        if (isEscapedMatch) {
            ++highlightOffset;
        }
        lineEntry.setAccess(writeAccess);
        if (this.fScope instanceof IRfInstanceElement) {
            lineEntry.setInstance((IRfInstanceElement)this.fScope);
            RfReferencesUtils.changeToPostConfigHit((IProject)this.fProject, (IRfInstanceElement)((IRfInstanceElement)this.fScope), (SearchHit)lineEntry);
        }
        if (this.assumeHitWhenSameNameAndType || this.fSkipImplicitComponentEntityAssociation) {
            lineEntry.setIsElaborationHit();
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, highlightOffset - lineOffset - counter, isPossibleMatch);
        }
        lineEntry.setHitType(type);
        this.fListener.addMatch((Object)lineEntry);
    }

    private void addHitOccurence(boolean isNonParameterHit, int startOoffset, int endOffset, int line, IDocument document, boolean isPossibleMatch, HitType type, RWKind writeAccess, LeftRightHandSideOfOperatorEnum leftRightHandSideOfConnection, Set<SearchHitConnectedElementInfo> elements) throws Exception {
        if (isNonParameterHit && this.fForRefactor) {
            return;
        }
        if (line == -1) {
            line = document.getLineOfOffset(startOoffset) + 1;
        }
        StringBuilder str = new StringBuilder();
        IRegion info = document.getLineInformation(line - 1);
        String lineContents = document.get(info.getOffset(), info.getLength());
        int lineOffset = document.getLineOffset(line - 1);
        int endJumpOffset = Math.min(endOffset, lineOffset + lineContents.length());
        int i = startOoffset;
        while (i < endJumpOffset) {
            str.append(DUMMY_CHAR_STRING);
            ++i;
        }
        String name = str.toString();
        int matchLength = isNonParameterHit ? lineContents.trim().length() : name.length();
        SearchHit lineEntry = new SearchHit(this.fParserPath, line, startOoffset, lineContents, matchLength, this.fElementWrapper == null ? true : this.fElementWrapper.shouldBeRenamed(), this.fCurrentConnectedElement, this.fRfElement, this.fProject);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)this.fParserPath, (int)line, (int)startOoffset, (boolean)isPossibleMatch));
        lineEntry.setLeftRightHandSideOfConnection(leftRightHandSideOfConnection);
        lineEntry.setConnectedElement(elements);
        String highlightName = name;
        int counter = RfReferencesUtils.countStartWS((String)lineContents);
        if (isNonParameterHit && counter >= 0) {
            highlightName = lineContents.trim().substring(startOoffset - lineOffset - counter);
            matchLength = highlightName.length();
        }
        lineEntry.setAccess(writeAccess);
        if (this.fScope instanceof IRfInstanceElement) {
            lineEntry.setInstance((IRfInstanceElement)this.fScope);
        }
        if (this.assumeHitWhenSameNameAndType) {
            lineEntry.setIsElaborationHit();
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, startOoffset - lineOffset - counter, isPossibleMatch);
        }
        lineEntry.setHitType(type);
        this.fListener.addMatch((Object)lineEntry);
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }

    public void setHolder(IHidHolder holder) {
        if (holder instanceof RfHidHolder) {
            this.fScope = ((RfHidHolder)holder).getScope();
        }
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setAssumeHitWhenSameNameAndType() {
        this.assumeHitWhenSameNameAndType = true;
    }
}

