/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.new_engine;

import java.text.MessageFormat;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.ui.search.RfSearchQueryElement;
import ro.amiq.vhdldt.ui.search.new_engine.NewHidsSearchEngine;
import ro.amiq.vhdldt.ui.search.new_engine.ReadersFileSearchResult;
import ro.amiq.vhdldt.ui.search.new_engine.WritersFileSearchResult;
import ro.amiq.vhdldt.ui.search.text.FileSearchQuery;
import ro.amiq.vhdldt.ui.search.text.FileSearchResult;

public class ReferenceHidSearchQuery
extends FileSearchQuery
implements ISearchQuery,
IBuildDoneListener {
    private IRfNamedElement fRfElement;
    private IProject fProject;
    private RfElementPath fRfElementPath;
    private boolean fProjectRebuilt;
    private RWSearchTypeEnum fSearchRWType;
    private DVTEditor fTextEditor;
    private int fOffset;
    private IRfScopeElement fScopeElement;

    public ReferenceHidSearchQuery(IProject project, String searchType, IRfNamedElement element, String searchLabel, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, FileTextSearchScope scope, int limitTo, boolean includeDeclarations, int searchFor, RWSearchTypeEnum searchRWType, DVTEditor textEditor, int offset, IRfScopeElement scopeElement) {
        super(searchType, element.getName(), searchLabel, isRegEx, isCaseSensitive, isWholeWord, scope, limitTo, false, false, searchFor);
        this.fRfElement = element;
        this.fRfElementPath = RfElementPath.path((IRfNamedElement)element);
        this.fIncludeDeclarations = includeDeclarations;
        this.fProject = project;
        this.fSearchRWType = searchRWType;
        this.fTextEditor = textEditor;
        this.fOffset = offset;
        this.fScopeElement = scopeElement;
        DVTMixedLangModelManager.getInstance().addBuildDoneListener((IBuildDoneListener)this);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IRfNamedElement getRfElement() {
        if (!this.fProjectRebuilt || this.fRfElement instanceof RfSearchQueryElement) {
            return this.fRfElement;
        }
        this.fRfElement = this.fRfElementPath.toNamedElement(this.fProject);
        this.fProjectRebuilt = false;
        return this.fRfElement;
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        Pattern searchPattern;
        if (this.getRfElement() == null) {
            return Status.OK_STATUS;
        }
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        if (!this.isAccumulateResults()) {
            textResult.removeAll();
        }
        if ((searchPattern = this.getSearchPattern()) == null) {
            return Status.CANCEL_STATUS;
        }
        return new NewHidsSearchEngine(this.fIncludeDeclarations, this.getSearchType(), this.fSearchRWType, this.fProject, this).search(this.getRfElement(), this.fScope, textResult, searchPattern, monitor, this.fTextEditor, this.fOffset, this.fScopeElement);
    }

    public String getResultLabel(int nMatches) {
        String readersWritersType;
        if (this.fProject == null) {
            return super.getResultLabel(nMatches);
        }
        String searchString = this.getSearchLabel();
        String searchType = this.getSearchType();
        String projectName = this.fProject.getName();
        String searchTypeField = this.getSearchedElementKind().toLowerCase();
        if (searchString.isEmpty()) {
            return super.getResultLabel(nMatches);
        }
        Set unsynchedFiles = this.getUnsynchedFiles();
        if (this.fSearchRWType == RWSearchTypeEnum.USAGES) {
            String description = DVTStringUtil.removeTicks((String)this.getScope().getDescription());
            if (nMatches == 1) {
                Object[] args = new Object[]{searchType, searchString, description, projectName};
                return String.valueOf(MessageFormat.format(SearchMessages.ReferenceSearchQuery_singularLabel, args)) + (unsynchedFiles != null && !unsynchedFiles.isEmpty() ? " (incomplete)" : "");
            }
            Object[] args = new Object[]{searchType, searchString, nMatches, description, projectName};
            return String.valueOf(MessageFormat.format(SearchMessages.ReferenceSearchQuery_pluralPattern, args)) + (unsynchedFiles != null && !unsynchedFiles.isEmpty() ? " (incomplete)" : "");
        }
        String string = readersWritersType = this.fSearchRWType == RWSearchTypeEnum.WRITERS ? "Writers" : "Readers";
        if (nMatches == 1) {
            Object[] args = new Object[]{readersWritersType, searchTypeField, searchString, projectName};
            return String.valueOf(MessageFormat.format(SearchMessages.ReferenceSearchQuery_readersWriters_singularLabel, args)) + (unsynchedFiles != null && !unsynchedFiles.isEmpty() ? " (incomplete)" : "");
        }
        Object[] args = new Object[]{readersWritersType, searchTypeField, searchString, nMatches, projectName};
        return String.valueOf(MessageFormat.format(SearchMessages.ReferenceSearchQuery_readersWriters_pluralPattern, args)) + (unsynchedFiles != null && !unsynchedFiles.isEmpty() ? " (incomplete)" : "");
    }

    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason)) {
            return;
        }
        if (this.fProject == null) {
            return;
        }
        if (projectName != null && projectName.equals(this.fProject.getName())) {
            this.fProjectRebuilt = true;
        }
    }

    @Override
    protected BaseFileSearchResult makeFileSearchResult(BaseTextSearchQuery baseSearchQuery) {
        if (this.fSearchRWType == RWSearchTypeEnum.READERS) {
            return new ReadersFileSearchResult((BaseTextSearchQuery)this);
        }
        if (this.fSearchRWType == RWSearchTypeEnum.WRITERS) {
            return new WritersFileSearchResult((BaseTextSearchQuery)this);
        }
        return new FileSearchResult((BaseTextSearchQuery)this);
    }
}

