/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.new_engine;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.HidMatch;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfReferencesUtils;
import ro.amiq.vhdldt.ui.search.new_engine.SignalReadWriteVisitor;

public class ReferenceHidSearchVisitor
extends RfHidVisitor {
    private IRfNamedElement fRfElement;
    private IProject fProject;
    private DocumentManager fDocumentManager;
    private IProgressMonitor fProgressMonitor;
    private int fCheckForQueryInterruptionCounter = 0;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;
    private Map<IRfScopeElement, List<HidMatch>> fHitBuffer = new LinkedHashMap<IRfScopeElement, List<HidMatch>>();
    private IRfScopeElement fHolderScope;
    private RfProject fRfProject;
    private SearchedElementWrapper fElementWrapper;
    private boolean fSkipImplicitComponentEntityAssociation;

    @Override
    public void setHolder(IHidHolder holder) {
        super.setHolder(holder);
        if (!(holder instanceof RfHidHolder)) {
            return;
        }
        RfHidHolder rfHidHolder = (RfHidHolder)holder;
        this.fHolderScope = rfHidHolder.getScope();
        if (this.fHitBuffer.isEmpty()) {
            return;
        }
        IRfScopeElement firstBufferedScope = this.fHitBuffer.keySet().iterator().next();
        if (this.isParentScope(firstBufferedScope, this.fHolderScope)) {
            return;
        }
        try {
            this.reportFromBuffer();
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean isParentScope(IRfScopeElement parent, IRfScopeElement child) {
        while (child != parent) {
            if ((child = child.getEnclosingScope()) != null) continue;
            return false;
        }
        return true;
    }

    public ReferenceHidSearchVisitor(IReportHitsListener<SearchHit> listener, IRfNamedElement element, IProject project, DocumentManager documentManager, FileSynchedAndAvailableManager fileManager, IProgressMonitor progressMonitor, SearchedElementWrapper elementWrapper, boolean skipImplicitComponentEntityAssociation) {
        this.fRfElement = element;
        this.fProject = project;
        this.fRfProject = RfManager.getInstance().getRfProject(project);
        this.fDocumentManager = documentManager;
        this.fFileManager = fileManager;
        this.fListener = listener;
        this.fElementWrapper = elementWrapper;
        this.fProgressMonitor = progressMonitor;
        this.fSkipImplicitComponentEntityAssociation = skipImplicitComponentEntityAssociation;
    }

    public boolean visit(RfHid hid) {
        IRfNamedElement element;
        block15: {
            block14: {
                String hidName;
                block13: {
                    block12: {
                        block11: {
                            try {
                                if (!this.fListener.shouldFilterIHidObject((IHidObject)hid, null)) break block11;
                                return true;
                            }
                            catch (Exception e) {
                                if (e instanceof OperationCanceledException) {
                                    throw (OperationCanceledException)((Object)e);
                                }
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                return false;
                            }
                        }
                        if (this.fCheckForQueryInterruptionCounter++ == 20) {
                            if (this.fProgressMonitor.isCanceled()) {
                                throw new OperationCanceledException("Operation Canceled");
                            }
                            this.fCheckForQueryInterruptionCounter = 0;
                        }
                        if (!hid.hasQualifier(HidQualifierCache.ALIAS_TARGET)) break block12;
                        return true;
                    }
                    hidName = hid.getName();
                    if (hidName != null && this.fRfElement.getName() != null) break block13;
                    return true;
                }
                if (hidName.equalsIgnoreCase(this.fRfElement.getName())) break block14;
                return true;
            }
            element = hid.getElement();
            if (element != null) break block15;
            this.addReferenceMatch(hid, true);
            return true;
        }
        if (!this.fSkipImplicitComponentEntityAssociation && element.checkEquals((Object)this.fRfElement) || this.fSkipImplicitComponentEntityAssociation && element.equals(this.fRfElement)) {
            boolean isAmbiguousFunctionCall = element instanceof RfFunctionsHolder && ((RfFunctionsHolder)element).hasMultipleFunctions();
            this.addReferenceMatch(hid, isAmbiguousFunctionCall);
        }
        return true;
    }

    private void addReferenceMatch(RfHid hid, boolean potentiaMatch) throws Exception {
        if (hid == null) {
            return;
        }
        if (!this.fFileManager.isSynchedFile(this.parserPath, this.fProject)) {
            return;
        }
        IDocument openDocument = this.fDocumentManager.getDocument(this.parserPath, this.fProject);
        if (openDocument == null) {
            return;
        }
        this.addMatch(potentiaMatch, openDocument, hid);
    }

    private void addMatch(boolean isPossibleMatch, IDocument openDocument, RfHid hid) throws Exception {
        this.computeReadersWritersHits(isPossibleMatch, openDocument, hid);
    }

    private void computeReadersWritersHits(boolean isPossibleMatch, IDocument openDocument, RfHid hid) {
        List<HidMatch> scopeHits = this.fHitBuffer.get(this.fHolderScope);
        if (scopeHits == null) {
            scopeHits = new ArrayList<HidMatch>();
            this.fHitBuffer.put(this.fHolderScope, scopeHits);
        }
        scopeHits.add(new HidMatch(isPossibleMatch, openDocument, (Hid)hid, this.parserPath, this.fRfElement));
    }

    private void addHitOccurence(int offset, int line, IDocument openDocument, boolean isPossibleMatch, RWKind writeAccess, ParserPath parserPath) throws Exception {
        if (line == -1) {
            line = openDocument.getLineOfOffset(offset) + 1;
        }
        IRegion info = openDocument.getLineInformation(line - 1);
        String lineContents = openDocument.get(info.getOffset(), info.getLength());
        int lineOffset = openDocument.getLineOffset(line - 1);
        int matchLength = this.fRfElement.getName().length();
        boolean isEscaped = lineContents.charAt(offset - lineOffset) == '\\';
        String highlightName = this.fRfElement.getName();
        if (isEscaped) {
            ++matchLength;
        }
        SearchHit lineEntry = new SearchHit(parserPath, line, offset, lineContents, matchLength, this.fElementWrapper == null ? true : this.fElementWrapper.shouldBeRenamed(), null, this.fRfElement, this.fProject);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)line, (int)offset, (boolean)isPossibleMatch));
        lineEntry.setAccess(writeAccess);
        int counter = VHDLRfReferencesUtils.countStartWS((IDocument)openDocument, (IRegion)info);
        int highlightOffset = offset;
        if (isEscaped) {
            ++highlightOffset;
        }
        if (counter >= 0) {
            lineEntry.setSearchedElement(highlightName, highlightOffset - lineOffset - counter, isPossibleMatch);
        }
        this.fListener.addMatch((Object)lineEntry);
    }

    public void reportFromBuffer() throws Exception {
        if (this.fHitBuffer == null || this.fHitBuffer.isEmpty()) {
            return;
        }
        IRfScopeElement topScope = this.fHitBuffer.keySet().iterator().next();
        if (!(topScope instanceof RfNamedElement)) {
            return;
        }
        IdentityHashMap<Hid, HidMatch> rwMap = new IdentityHashMap<Hid, HidMatch>();
        this.fHitBuffer.values().forEach(x -> x.forEach(y -> {
            HidMatch hidMatch = rwMap.put(y.getHid(), (HidMatch)y);
        }));
        this.fHitBuffer.clear();
        ((IRfNamedElement)topScope).visitHidObject((IRfSingleLangProject)this.fRfProject, (IHidVisitor)new SignalReadWriteVisitor(rwMap));
        for (HidMatch hidMatch : rwMap.values()) {
            if (VHDLRfReferencesUtils.checkFoundElementForReadAndWrite((IRfNamedElement)this.fRfElement, (IRfNamedElement)hidMatch.getHid().getElement()) && hidMatch.getAccess() == RWKind.NONE) {
                hidMatch.addReadOccurence(hidMatch.getHid().getOccurrence());
            }
            this.reportOccurences(hidMatch);
        }
    }

    private void reportOccurences(HidMatch hidMatch) throws Exception {
        boolean isPossibleMatch = hidMatch.isPossibleMatch();
        IDocument openDocument = hidMatch.getOpenDocument();
        Hid hid = hidMatch.getHid();
        HidOccurrence occurence = hid.getOccurrence();
        if (occurence == null) {
            return;
        }
        if (this.isDeclaration(occurence, this.fRfElement, openDocument)) {
            return;
        }
        if (occurence.hasQualifier(HidQualifierCache.CONSTRUCTOR_DECLARATION)) {
            return;
        }
        if (this.fCheckForQueryInterruptionCounter++ == 10) {
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException("Operation Canceled");
            }
            this.fCheckForQueryInterruptionCounter = 0;
        }
        int offset = occurence.getOffset();
        int virtualOffset = occurence.getVirtualOffset();
        if (virtualOffset == -1) {
            this.addHitOccurence(offset, occurence.getLine(), openDocument, isPossibleMatch, hidMatch.getAccess(), hidMatch.getParserPath());
        }
    }

    private boolean isDeclaration(HidOccurrence occurrence, IRfNamedElement element, IDocument document) throws Exception {
        return this.checkDeclaration(occurrence, element, document);
    }

    private boolean checkDeclaration(HidOccurrence occurrence, IRfNamedElement element, IDocument openDocument) throws Exception {
        int startOffsetLine = openDocument.getLineOfOffset(occurrence.getOffset());
        int currentMatchStartLine = startOffsetLine + 1;
        int endOffsetLine = openDocument.getLineOfOffset(occurrence.getOffset() + element.getName().length());
        if (element instanceof RfNamedElement) {
            ArrayList<RfDefElement> declarations = new ArrayList<RfDefElement>(this.fRfElement.getDeclarations());
            if (this.fRfElement instanceof RfFunction) {
                if (((RfFunction)this.fRfElement).isPrototype()) {
                    RfFunction rfFunction = ((RfFunction)this.fRfElement).getImplementation();
                    if (rfFunction != this.fRfElement) {
                        declarations.addAll(rfFunction.getDeclarations());
                    }
                } else {
                    RfFunction rfFunction = ((RfFunction)this.fRfElement).getPrototype();
                    if (rfFunction != this.fRfElement) {
                        declarations.addAll(rfFunction.getDeclarations());
                    }
                }
            }
            for (IRfDefElement iRfDefElement : declarations) {
                if (iRfDefElement.getDefFile() == null || !iRfDefElement.getDefFile().getParserPath().equals((Object)this.parserPath) || iRfDefElement.getStartLine() != currentMatchStartLine && openDocument.getLineOfOffset(iRfDefElement.getEndOffset()) != endOffsetLine) continue;
                return true;
            }
        } else {
            IRfDefElement typeLayer = this.fRfElement.getDeclaration();
            if (typeLayer.getDefFile() != null && typeLayer.getDefFile().getParserPath().equals((Object)this.parserPath) && (typeLayer.getStartLine() == currentMatchStartLine || openDocument.getLineOfOffset(typeLayer.getEndOffset()) == endOffsetLine)) {
                return true;
            }
        }
        return false;
    }
}

