/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.search.new_engine;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfReferencesUtils;

public class ReferenceImportExportHidOperatorVisitor
implements IHidVisitor<RfHidOperator> {
    private IProject fProject;
    private IRfNamedElement fRfElement;
    private ParserPath fParserPath;
    private IProgressMonitor fProgressMonitor;
    private DocumentManager fDocumentManager;
    private int fCheckForQueryInterruptionCounter = 0;
    private IReportHitsListener<SearchHit> fListener;
    private FileSynchedAndAvailableManager fFileManager;

    public ReferenceImportExportHidOperatorVisitor(IReportHitsListener<SearchHit> listener, IProgressMonitor progressMonitor, FileSynchedAndAvailableManager fileManager, IRfNamedElement element, IProject project, DocumentManager documentManager) {
        this.fRfElement = element;
        this.fProject = project;
        this.fFileManager = fileManager;
        this.fListener = listener;
        this.fDocumentManager = documentManager;
        this.fProgressMonitor = progressMonitor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(RfHidOperator hidOperator) {
        try {
            if (this.fCheckForQueryInterruptionCounter++ == 20) {
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException("Operation Canceled");
                }
                this.fCheckForQueryInterruptionCounter = 0;
            }
            if (!hidOperator.hasOccurrence(HidOperatorQualifier.IS_IMPORT) && !hidOperator.hasOccurrence(HidOperatorQualifier.IS_EXPORT)) {
                return true;
            }
            IHidObject lhHidObject = hidOperator.getLHValue();
            ListContainer rhHidObjects = hidOperator.getRHValues();
            RfHidImplicit pkgHidImplicit = (RfHidImplicit)lhHidObject;
            String pkgName = pkgHidImplicit.getName();
            if (pkgName == null) {
                return true;
            }
            boolean leftSide = true;
            if (this.fRfElement.getName().equals(pkgName)) {
                this.addReferenceImportExportMatch(hidOperator, leftSide);
            }
            Iterator iterator = rhHidObjects.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                IHidObject rhHidObject = (IHidObject)iterator.next();
                if (!(rhHidObject instanceof RfHidImplicit)) continue;
                RfHidImplicit rhHidImplicit = (RfHidImplicit)rhHidObject;
                if (this.fRfElement.getName().equals(rhHidImplicit.getName())) break;
            }
            leftSide = false;
            this.addReferenceImportExportMatch(hidOperator, leftSide);
            return true;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private void addReferenceImportExportMatch(RfHidOperator hidOperator, boolean leftSide) throws Exception {
        if (this.fFileManager.isSynchedFile(this.fParserPath, this.fProject)) {
            return;
        }
        IDocument document = this.fDocumentManager.getDocument(this.fParserPath, this.fProject);
        if (document == null) {
            return;
        }
        this.addImportExportMatch(hidOperator, document, leftSide);
    }

    private void addImportExportMatch(RfHidOperator hidOperator, IDocument document, boolean leftSide) throws Exception {
        if (!this.fFileManager.isSynchedFile(this.fParserPath, this.fProject)) {
            return;
        }
        if (!(this.fRfElement instanceof RfPackage) && leftSide || this.fRfElement instanceof RfPackage && !leftSide) {
            return;
        }
        HidOperatorOccurrence importExportOccurrence = hidOperator.getOccurrence(HidOperatorQualifier.IS_IMPORT.value());
        if (importExportOccurrence == null) {
            importExportOccurrence = hidOperator.getOccurrence(HidOperatorQualifier.IS_EXPORT.value());
        }
        if (importExportOccurrence == null) {
            return;
        }
        int line = importExportOccurrence.getLine();
        if (line == -1) {
            return;
        }
        IRegion lineInformation = document.getLineInformation(line - 1);
        int lineStart = lineInformation.getOffset();
        if (lineStart == -1) {
            return;
        }
        String lineContents = document.get(lineInformation.getOffset(), lineInformation.getLength());
        int index = lineContents.indexOf(this.fRfElement.getName());
        if (index == -1) {
            return;
        }
        int offset = leftSide ? importExportOccurrence.getOffset() - this.fRfElement.getName().length() : importExportOccurrence.getOffset() + 2;
        SearchHit lineEntry = new SearchHit(this.fParserPath, line, offset, lineContents, this.fRfElement.getName().length(), this.fProject);
        lineEntry.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)this.fParserPath, (int)lineEntry.getLine(), (int)lineEntry.getOffset(), (boolean)false));
        int counter = VHDLRfReferencesUtils.countStartWS((String)lineContents);
        if (counter >= 0) {
            lineEntry.setSearchedElement(this.fRfElement.getName(), offset - lineStart - counter, false);
        }
        this.fListener.addMatch((Object)lineEntry);
    }

    public Class<RfHidOperator> getType() {
        return RfHidOperator.class;
    }

    public void setParserPath(ParserPath parserPath) {
        this.fParserPath = parserPath;
    }
}

